//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $RCSmodulefile   :
// $Author          :
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 0.1
// $Date: 22-Dec-2008
// $State: Complete
// $Locker:
// ---------------------------------------------------------------------------
// Dependencies     :
// Description      : Wep Class For TB
//
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

// From IEEE 802.11 2007
`define   ICV_CRC_POLYNOME    33'b1_0000_0100_1100_0001_0001_1101_1011_0111
`define   ICV_CRC_INIT        33'b1_1111_1111_1111_1111_1111_1111_1111_1111

// Taken from IEEE 802.11 2007 H.6.2
bit [7:0]   KEY_IEEE[8]  =  {8'hfb,8'h02,8'h9e,8'h30,8'h31,8'h32,8'h33,8'h34};

bit [7:0]  DATA_IEEE[86] =  {8'haa,8'haa,8'h03,8'h00,8'h00,8'h00,8'h08,8'h00,
                             8'h45,8'h00,8'h00,8'h4e,8'h66,8'h1a,8'h00,8'h00,
                             8'h80,8'h11,8'hbe,8'h64,8'h0a,8'h00,8'h01,8'h22,
                             8'h0a,8'hff,8'hff,8'hff,8'h00,8'h89,8'h00,8'h89,
                             8'h00,8'h3a,8'h00,8'h00,8'h80,8'ha6,8'h01,8'h10,
                             8'h00,8'h01,8'h00,8'h00,8'h00,8'h00,8'h00,8'h00,
                             8'h20,8'h45,8'h43,8'h45,8'h4a,8'h45,8'h48,8'h45,
                             8'h43,8'h46,8'h43,8'h45,8'h50,8'h46,8'h45,8'h45,
                             8'h49,8'h45,8'h46,8'h46,8'h43,8'h43,8'h41,8'h43,
                             8'h41,8'h43,8'h41,8'h43,8'h41,8'h43,8'h41,8'h41,
                             8'h41,8'h00,8'h00,8'h20,8'h00,8'h01};

bit [7:0] PLAIN_IEEE[90] =  {8'haa,8'haa,8'h03,8'h00,8'h00,8'h00,8'h08,8'h00,
                             8'h45,8'h00,8'h00,8'h4e,8'h66,8'h1a,8'h00,8'h00,
                             8'h80,8'h11,8'hbe,8'h64,8'h0a,8'h00,8'h01,8'h22,
                             8'h0a,8'hff,8'hff,8'hff,8'h00,8'h89,8'h00,8'h89,
                             8'h00,8'h3a,8'h00,8'h00,8'h80,8'ha6,8'h01,8'h10,
                             8'h00,8'h01,8'h00,8'h00,8'h00,8'h00,8'h00,8'h00,
                             8'h20,8'h45,8'h43,8'h45,8'h4a,8'h45,8'h48,8'h45,
                             8'h43,8'h46,8'h43,8'h45,8'h50,8'h46,8'h45,8'h45,
                             8'h49,8'h45,8'h46,8'h46,8'h43,8'h43,8'h41,8'h43,
                             8'h41,8'h43,8'h41,8'h43,8'h41,8'h43,8'h41,8'h41,
                             8'h41,8'h00,8'h00,8'h20,8'h00,8'h01,8'h1b,8'hd0,
                             8'hb6,8'h04};

bit [7:0] CIPHER_IEEE[90]=  {8'hf6,8'h9c,8'h58,8'h06,8'hbd,8'h6c,8'he8,8'h46,
                             8'h26,8'hbc,8'hbe,8'hfb,8'h94,8'h74,8'h65,8'h0a,
                             8'had,8'h1f,8'h79,8'h09,8'hb0,8'hf6,8'h4d,8'h5f,
                             8'h58,8'ha5,8'h03,8'ha2,8'h58,8'hb7,8'hed,8'h22,
                             8'heb,8'h0e,8'ha6,8'h49,8'h30,8'hd3,8'ha0,8'h56,
                             8'ha5,8'h57,8'h42,8'hfc,8'hce,8'h14,8'h1d,8'h48,
                             8'h5f,8'h8a,8'ha8,8'h36,8'hde,8'ha1,8'h8d,8'hf4,
                             8'h2c,8'h53,8'h80,8'h80,8'h5a,8'hd0,8'hc6,8'h1a,
                             8'h5d,8'h6f,8'h58,8'hf4,8'h10,8'h40,8'hb2,8'h4b,
                             8'h7d,8'h1a,8'h69,8'h38,8'h56,8'hed,8'h0d,8'h43,
                             8'h98,8'he7,8'hae,8'he3,8'hbf,8'h0e,8'h2a,8'h2c,
                             8'ha8,8'hf7};

// Taken from OpenSSL (under a linux shell)
// openssl rc4 -k RC4Key128 -P -nosalt     ---> 6C9C078D7D9EA5CC980EC4ED84B7099C
bit [7:0] KEY_128_OPENSSL[16] =   {8'h6C,8'h9C,8'h07,8'h8D,8'h7D,8'h9E,8'hA5,8'hCC,
                                   8'h98,8'h0E,8'hC4,8'hED,8'h84,8'hB7,8'h09,8'h9C};

// echo -ne "Dien Is Awesome" | od -t x1   ---> 44 69 65 6e 20 49 73 20 41 77 65 73 6f 6d 65
bit [7:0]   PLAIN_OPENSSL[15] =   {8'h44,8'h69,8'h65,8'h6e,8'h20,8'h49,8'h73,8'h20,
                                   8'h41,8'h77,8'h65,8'h73,8'h6f,8'h6d,8'h65};

// echo -ne "Dien Is Awesome" | openssl rc4 -k RC4Key128 -e -nosalt | od -t x1  ---> 28 c3 96 01 04 9a 13 d1 4e e5 88 e2 e4 03 7a
bit [7:0]  CIPHER_OPENSSL[15] =   {8'h28,8'hc3,8'h96,8'h01,8'h04,8'h9a,8'h13,8'hd1,
                                   8'h4e,8'he5,8'h88,8'he2,8'he4,8'h03,8'h7a};

typedef enum {KEYDEFAULT=0,KEYMAPPING}  wep_key_t;
typedef enum {RC4_64=0,RC4_128,RC4_256} wep_length_t;

class wep;

  parameter             S_BOX_SIZE = 256;

  // WEP
  bit             [8:0] seedWepPRBS;
  bit             [8:0] prbs;
  bit             [8:0] nextprbs;
  bit            [23:0] IV;

  // Data
  bit             [7:0] plain_data[];
  bit            [31:0] ICV;
  bit             [7:0] enc_data[];
  bit             [7:0] dec_data[];

  bit             [7:0] enc_data_rtl[];
  bit             [7:0] dec_data_rtl[];

  // Key
  bit             [7:0] Key[];
  bit            [63:0] Key64;
  bit           [127:0] Key128;

  // RC4
  bit             [7:0] S_box[];
  bit             [7:0] S_var;
  bit             [7:0] RC4_out;

  // Others
  bit             [7:0] j,f,k;
  int                   i,g;

  int                   testIEEE_err_cnt;
  int                   testOpenSSLKey128_err_cnt;

  // When this object is create delete all the dynamic array
  function new();
    plain_data.delete();
    enc_data.delete();
    dec_data.delete();
    Key.delete();
    S_box.delete();
  endfunction : new

  // G(x) = x32 + x26 + x23 + x22 + x16 + x12 + x11 + x10 + x8 + x7 + x5 + x4 + x2 + x + 1
  function void crc32(input bit [7:0] data2crc[], output bit [31:0] crc_out);
    bit lfsr_in;
    bit [31:0] crc_result = 32'hFFFF_FFFF;

    for(i = 0; i<data2crc.size(); i=i+1)
    begin
      for(g=0; g<8; g=g+1)
      begin
        lfsr_in             =  crc_result[31] ^ data2crc[i][g];
        crc_result[31]      =  crc_result[30];
        crc_result[30]      =  crc_result[29];
        crc_result[29]      =  crc_result[28];
        crc_result[28]      =  crc_result[27];
        crc_result[27]      =  crc_result[26];
        crc_result[26]      =  crc_result[25] ^ lfsr_in;
        crc_result[25]      =  crc_result[24];
        crc_result[24]      =  crc_result[23];
        crc_result[23]      =  crc_result[22] ^ lfsr_in;
        crc_result[22]      =  crc_result[21] ^ lfsr_in;
        crc_result[21]      =  crc_result[20];
        crc_result[20]      =  crc_result[19];
        crc_result[19]      =  crc_result[18];
        crc_result[18]      =  crc_result[17];
        crc_result[17]      =  crc_result[16];
        crc_result[16]      =  crc_result[15] ^ lfsr_in;
        crc_result[15]      =  crc_result[14];
        crc_result[14]      =  crc_result[13];
        crc_result[13]      =  crc_result[12];
        crc_result[12]      =  crc_result[11] ^ lfsr_in;
        crc_result[11]      =  crc_result[10] ^ lfsr_in;
        crc_result[10]      =  crc_result[9]  ^ lfsr_in;
        crc_result[9]       =  crc_result[8];
        crc_result[8]       =  crc_result[7]  ^ lfsr_in;
        crc_result[7]       =  crc_result[6]  ^ lfsr_in;
        crc_result[6]       =  crc_result[5];
        crc_result[5]       =  crc_result[4]  ^ lfsr_in;
        crc_result[4]       =  crc_result[3]  ^ lfsr_in;
        crc_result[3]       =  crc_result[2];
        crc_result[2]       =  crc_result[1]  ^ lfsr_in;
        crc_result[1]       =  crc_result[0]  ^ lfsr_in;
        crc_result[0]       =                   lfsr_in;
      end
    end

    crc_result[31:0] = ~crc_result[31:0];

    for(i=0;i<32;i=i+1)
    begin
      if(i<8)
        crc_out[7-i]     = crc_result[i];
      else if(i<16)
        crc_out[15-i+8]  = crc_result[i];
      else if(i<24)
        crc_out[23-i+16] = crc_result[i];
      else
        crc_out[31-i+24] = crc_result[i];
    end

  endfunction : crc32

  // Random generation of IV
  function void IV_gen();
    if(seedWepPRBS != 0)
    begin
      prbs        = seedWepPRBS;

      nextprbs[0] = prbs[2] ^ prbs[6] ^ prbs[1];
      nextprbs[1] = prbs[3] ^ prbs[7] ^ prbs[2];
      nextprbs[2] = prbs[4] ^ prbs[8] ^ prbs[3];
      nextprbs[3] = prbs[0] ^ prbs[4];
      nextprbs[4] = prbs[1] ^ prbs[5];
      nextprbs[5] = prbs[2] ^ prbs[6];
      nextprbs[6] = prbs[3] ^ prbs[7];
      nextprbs[7] = prbs[4] ^ prbs[8];
      nextprbs[8] = prbs[0];

      IV[7:0] = nextprbs[7:0];
      prbs = nextprbs;

      nextprbs[0] = prbs[2] ^ prbs[6] ^ prbs[1];
      nextprbs[1] = prbs[3] ^ prbs[7] ^ prbs[2];
      nextprbs[2] = prbs[4] ^ prbs[8] ^ prbs[3];
      nextprbs[3] = prbs[0] ^ prbs[4];
      nextprbs[4] = prbs[1] ^ prbs[5];
      nextprbs[5] = prbs[2] ^ prbs[6];
      nextprbs[6] = prbs[3] ^ prbs[7];
      nextprbs[7] = prbs[4] ^ prbs[8];
      nextprbs[8] = prbs[0];

      IV[15:8] = nextprbs[7:0];
      prbs = nextprbs;

      nextprbs[0] = prbs[2] ^ prbs[6] ^ prbs[1];
      nextprbs[1] = prbs[3] ^ prbs[7] ^ prbs[2];
      nextprbs[2] = prbs[4] ^ prbs[8] ^ prbs[3];
      nextprbs[3] = prbs[0] ^ prbs[4];
      nextprbs[4] = prbs[1] ^ prbs[5];
      nextprbs[5] = prbs[2] ^ prbs[6];
      nextprbs[6] = prbs[3] ^ prbs[7];
      nextprbs[7] = prbs[4] ^ prbs[8];
      nextprbs[8] = prbs[0];

      IV[23:16] = nextprbs[7:0];
    end
    else
    begin
      IV[23:0] = $urandom_range(2**24-1,1);
    end
  endfunction : IV_gen

  // Random generation of Key 64 bits
  function void Key64_gen();
    Key64[63:32] = $urandom_range((2**32)-1,0);
    Key64[31:0]  = $urandom_range((2**32)-1,1);
    Key64[23:0]  = IV;
    Key          = new[8];

    foreach(Key[i])
    begin
      Key[i] = Key64[i*8 +: 8];
    end
  endfunction : Key64_gen

  // Random generation of Key 128 bits
  function void Key128_gen();
    Key128[127:96] = $urandom_range((2**32)-1,0);
    Key128[95:64]  = $urandom_range((2**32)-1,0);
    Key128[63:32]  = $urandom_range((2**32)-1,0);
    Key128[31:0]   = $urandom_range((2**32)-1,1);
    Key128[23:0]   = IV;
    Key            = new[16];

    foreach(Key[i])
    begin
      Key[i] = Key128[i*8 +: 8];
    end
  endfunction : Key128_gen

  // Random generation of Plain data
  function void Plain_gen(int len=0);
    int length = (len !=0 ) ? len : $urandom_range(256,1);
    plain_data = new[length];
    foreach(plain_data[i])
    begin
      plain_data[i] = $urandom_range(255,0);
    end
  endfunction : Plain_gen

  // Random generation of Encrypted data
  function void Encrypted_gen(int len=0);
    int length = (len !=0 ) ? len : $urandom_range(256,1);
    enc_data = new[length];
    foreach(plain_data[i])
    begin
      enc_data[i] = $urandom_range(255,0);
    end
  endfunction : Encrypted_gen

  // key init
  function void key_scheduling();
    S_box.delete();
    S_box = new[S_BOX_SIZE];

    for(i = 0; i < S_BOX_SIZE; i = i+1)
    begin
      S_box[i] = i;
    end

    f = 0;
    g = 0;
    for(i = 0; i < S_BOX_SIZE; i = i+1)
    begin
      f         = (f+S_box[i]+Key[g]);
      S_var     = S_box[i];
      S_box[i]  = S_box[f];
      S_box[f]  = S_var;
      g         = (g+1)%(Key.size());
    end
  endfunction : key_scheduling

  // This is call for each data byte to encrypt or decrypt
  function void rc4(bit restart=0,bit debug=0);
    if(restart)
    begin
      j = 0;
      f = 0;
      k = 0;
    end

    j = (j + 1);
    f = (f + S_box[j]);

    if (debug)
    begin
      $display("j=%0d",j);
      $display("f=%0d",f);
      $display("S_box[j]=%2h",S_box[j]);
      $display("S_box[f]=%2h",S_box[f]);
    end

    S_var     = S_box[j];
    S_box[j]  = S_box[f];
    S_box[f]  = S_var;
    k         = (S_box[j] + S_box[f]);
    if (debug)
    begin
      $display("S_var=%2h",S_var);
      $display("k=%0d",k);
      $display("S_box[k]=%2h",S_box[k]);
    end
    RC4_out   = S_box[k];
  endfunction : rc4

  // encrypt
  function void encrypt();
    enc_data = new[plain_data.size()];

    key_scheduling();

    foreach(plain_data[i])
    begin
      if(i == 0)
        rc4(1,0);
      else
        rc4(0,0);

      enc_data[i] = plain_data[i] ^ RC4_out;
      //$display("enc_data[%0d] %2h = plain_data[%0d] %2h ^ RC4_out %2h",i,enc_data[i],i, plain_data[i],RC4_out);
    end
  endfunction : encrypt

  // decrypt
  function void decrypt();
    dec_data = new[enc_data.size()];

    key_scheduling();

    foreach(enc_data[i])
    begin
      if(i == 0)
        rc4(1);
      else
        rc4(0);

      dec_data[i] = enc_data[i] ^ RC4_out;
    end
  endfunction : decrypt

  // test Encrypt and Decrypt of Key 128 bits
  function void testOpenSSLKey128();
    //
    testOpenSSLKey128_err_cnt = 0;

    // Create all the arrays
    plain_data = new[$size(PLAIN_OPENSSL)];
    enc_data   = new[$size(PLAIN_OPENSSL)];
    dec_data   = new[$size(PLAIN_OPENSSL)];
    Key        = new[$size(KEY_128_OPENSSL)];

    // init plain data array
    foreach(plain_data[i])
    begin
      plain_data[i] = PLAIN_OPENSSL[i];
    end

    // init key array
    foreach(Key[i])
    begin
      Key[i] = KEY_128_OPENSSL[i];
    end

    // Encryption
    encrypt();

    // Compare ecrypt array against test cipher data
    foreach(enc_data[i])
    begin
      if(enc_data[i] != CIPHER_OPENSSL[i])
      begin
        $display(" testOpenSSLKey128 enc_data[%02h] = %02h differs from test_cipher %02h",i,enc_data[i],CIPHER_OPENSSL[i]);
        testOpenSSLKey128_err_cnt = testOpenSSLKey128_err_cnt + 1;
      end
    end

    // init enc data
    foreach(enc_data[i])
    begin
      enc_data[i] = CIPHER_OPENSSL[i];
    end

    // Decrypt
    decrypt();

    // Compare
    foreach(dec_data[i])
    begin
      if(dec_data[i] != PLAIN_OPENSSL[i])
      begin
        $display(" testOpenSSLKey128 dec_data[%02h] = %02h differs from test_plain %02h",i,dec_data[i],PLAIN_OPENSSL[i]);
        testOpenSSLKey128_err_cnt = testOpenSSLKey128_err_cnt + 1;
      end
    end
  endfunction : testOpenSSLKey128

  // test IEEE Test Vector
  function void testIEEE();
    //
    testIEEE_err_cnt = 0;

    // Create all the arrays
    plain_data = new[$size(PLAIN_IEEE)];
    enc_data   = new[$size(PLAIN_IEEE)];
    dec_data   = new[$size(PLAIN_IEEE)];
    Key        = new[$size(KEY_IEEE)];

    // init plain data array
    foreach(plain_data[i])
    begin
      plain_data[i] = PLAIN_IEEE[i];
    end

    // init key array
    foreach(Key[i])
    begin
      Key[i] = KEY_IEEE[i];
    end

    // Encryption
    encrypt();

    // Compare ecrypt array against test cipher data
    foreach(enc_data[i])
    begin
      if(enc_data[i] != CIPHER_IEEE[i])
      begin
        $display(" testIEEE enc_data[%02h] = %02h differs from CIPHER_IEEE %02h",i,enc_data[i],CIPHER_IEEE[i]);
        testIEEE_err_cnt = testIEEE_err_cnt + 1;
      end
    end

    // init encoded data array
    foreach(enc_data[i])
    begin
      enc_data[i] = CIPHER_IEEE[i];
    end

    // Decrypt
    decrypt();

    // Compare
    foreach(dec_data[i])
    begin
      if(dec_data[i] != PLAIN_IEEE[i])
      begin
        $display(" testIEEE dec_data[%02h] = %02h differs from PLAIN_IEEE %02h",i,dec_data[i],PLAIN_IEEE[i]);
        testIEEE_err_cnt = testIEEE_err_cnt + 1;
      end
    end
  endfunction : testIEEE

endclass : wep
