//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
`timescale 1ns/1ps

`ifndef WLAN_TOP_TB_SV
`define WLAN_TOP_TB_SV

//--------------------------------------------------------------------
module wlan_top_tb();

  //---------------------------------------------
  // import test and component packages
  //---------------------------------------------
  `include "uvm_macros.svh"
  import uvm_pkg::*;
  import wlan_test_pkg::*;
  import modem_test_pkg::*;
  import mac_test_pkg::*;
  //---------------------------------------------

  ////////////////////////////////////////////////////////////////////////////
  //!                 Processor interface signals                          !//
  ////////////////////////////////////////////////////////////////////////////

  wire                 proc_hready;
  wire [31:0]          proc_haddr;
  wire [ 1:0]          proc_htrans;
  wire                 proc_hwrite;
  wire [ 2:0]          proc_hsize;
  wire [31:0]          proc_hrdata;
  wire [31:0]          proc_hwdata;
  wire [ 1:0]          proc_hresp;

  wire                 host_irq;        // Interrupt from host
  wire  [95:20]        proc_irq;        // Interrupts to processor
  wire                 cpu_single_irq;  // Single Interrupt to processor

  ////////////////////////////////////////////////////////////////////////////
  //!                 MAC signals                                          !//
  ////////////////////////////////////////////////////////////////////////////

  // Interrupt signals
  wire                 intGen_n;            // General Interrupt
  wire                 intProtTrigger_n;    // Protocol Trigger Interrupt
  wire                 intTxTrigger_n;      // Tx Trigger Interrupt
  wire                 intRxTrigger_n;      // Rx Trigger Interrupt
  wire                 intTxRxMisc_n;       // Misc. Interrupt
  wire                 intTxRxTimer_n;      // Timer Interrupt
  wire                 internalError;       // Internal Error
  wire  [31:0]         debugPort;           // Debug port

  ////////////////////////////////////////////////////////////////////////////
  //!                 MODEM signals                                        !//
  ////////////////////////////////////////////////////////////////////////////

  // Interrupt signals
  wire                 Interrupt;     // General Interrupt

  //ADC/DAC clock for radio interface
  wire                 ADCDataEn;
  wire [11:0]          ADCDataI0;
  wire [11:0]          ADCDataQ0;
  wire                 ADCOn0;
  wire [11:0]          ADCDataI1;
  wire [11:0]          ADCDataQ1;
  wire                 ADCOn1;
  reg  [31:0]          AGCCount;

  /* DAC */
  wire [11:0]          DACDataI0;
  wire [11:0]          DACDataQ0;
  wire                 DACDataEn0;
  wire                 DACOn0;
  wire [11:0]          DACDataI1;
  wire [11:0]          DACDataQ1;
  wire                 DACDataEn1;
  wire                 DACOn1;
  reg  [31:0]          DACCount;

  wire                 rf_spi_in;
  wire                 rf_spi_ss_n;
  wire                 rf_spi_clk;
  wire                 rf_spi_out;
  wire [7:0]           rf_gpio;
  wire                 rf_resetn;
  wire                 rf_agcfreeze;
  wire                 rf_interrupt;
  wire                 rf_tmode;
  wire                 rf_trsw0;
  wire                 rf_trsw1;
  wire                 rf_extpaon_ch0_5G9;
  wire                 rf_extpaon_ch0_2G4;
  wire                 rf_extpaon_ch1_5G9;
  wire                 rf_extpaon_ch1_2G4;

  /*  system resets */
  logic                sys_rst_n;

   /*  rw_nx_platform clock */
  reg                  plf_root_clk;           // Platform Root clock
  reg                  mac_lp_root_clk;        // Low-Power clock
  reg                  mac_wt_root_clk;        // Low-Power clock
  reg                  mac_core_root_clk;      // MAC Core clock

  reg                  ref_clk = 1;               // Reference clock for PHY (240/480 Mhz)
  int                  mac_core_clk_cnt;
  wire                 fe_clk;
  wire                 fe_rst_n;
  wire                 plf_clk;           // Platform clock
  wire                 plf_rst_n;         // Platform Reset clock
  wire                 plf_por_n;         // Platform POR

  /*  rw_nx_platform clock enables */
  reg                  platform_wake_up;       // Wake Up platform
  reg                  mac_lp_clkswitch;       // Switch MAC Lower Clock.

  /* Clock internal signals */
  reg                  mac_lp_clk_i = 1;       // Internal low power clock
  reg                  mac_pi_clk_i = 1;       // Internal Platform clock
  reg                  mac_core_clk_i = 1;     // Internal Core clock
  reg                  mac_wt_clk_i = 1;       // Internal WEP/TKIP clock
  reg                  clk_1mhz = 1;           // signal for probing


  //---------------------------------------------
  // interface instances
  //---------------------------------------------
  rst_if                               i_rst_if();
  ahb_master_if                        i_ahb_master_if();
  mac_phy_if                           i_mac_phy_if();
  radio_ctrl_if                        i_radio_ctrl_if();
  modem_stream_if#(`ADCWIDTH)          i_modem_stream_adc_if();
  modem_stream_if#(`DACWIDTH)          i_modem_stream_dac_if();
  rui_if                               i_rui_if();
  sram_if                              i_sram_if();
  mac_bf_if                            i_mac_bf_if();
  phy_bf_if                            i_phy_bf_if();
  coex_bt_if                           i_coex_bt_if();
  pta_wlan_if                          i_pta_wlan_if();
  bus_monitor_if                       i_bus_monitor_if();
  modem_stream_if #(`TXCOREDATA_WIDTH) i_hdmcore_tx_if();
  modem_stream_if #(`TXMAPDATA_WIDTH)  i_hdmcore_mapper_if();
  modem_stream_if #(`DEINTERWIDTH)     i_deint_if();
  modem_stream_if #(`EQUWIDTH)         i_equ_if();
  modem_stream_if #(`EQUWIDTH)         i_equ1_if();
  modem_stream_if #(`LDPCWIDTH)        i_ldpc_if();
  modem_stream_if #(`LDPCDATAWIDTH)    i_ldpc_data_if();
  modem_stream_if #(`VITERBIWIDTH)     i_viterbi_in_if();
  mem_if #(`FFTIF_WIDTH)               i_fft_in_if();
  mem_if #(`FFTIF_WIDTH)               i_fft_out_if();
  mem_if #(`HMEM_WIDTH)                i_h_mem_if();

  // MAC interrupt controller INPUTS
  irq_raw_if#(`MAC_IRQ_CTRL_IN_WIDTH)  i_mac_in_irq_raw_if (
    .clk  (`PATH_TO_MAC_INTERRUPT_CTRL.macPIClk),
    .nrst (`PATH_TO_MAC_INTERRUPT_CTRL.macPIClkHardRst_n)
  );
  // MAC interrupt controller OUTPUTS
  irq_raw_if#(`MAC_IRQ_CTRL_OUT_WIDTH)  i_mac_out_irq_raw_if (
    .clk  (`PATH_TO_MAC_INTERRUPT_CTRL.macPIClk),
    .nrst (`PATH_TO_MAC_INTERRUPT_CTRL.macPIClkHardRst_n)
  );

  // Platform interrupt controller INPUTS
  irq_raw_if#(`PLATFORM_IN_IRQ_WIDTH)  i_platf_in_irq_raw_if (
    .clk  (`PATH_TO_PLATFORM_INTERRUPT_CTRL.clk),
    .nrst (`PATH_TO_PLATFORM_INTERRUPT_CTRL.rst_n)
  );

  // Platform interrupt controller OUTPUT
  irq_raw_if#(`PLATFORM_OUT_IRQ_WIDTH)  i_platf_out_irq_raw_if (
    .clk  (`PATH_TO_PLATFORM_INTERRUPT_CTRL.clk),
    .nrst (`PATH_TO_PLATFORM_INTERRUPT_CTRL.rst_n)
  );

  axi_slave_if i_axi_slave_if (
    .aclk    (plf_clk),
    .aresetn (plf_rst_n)
  );

  sram_bus_if i_sram_bus_if(
   .clk (`TOP_MEMORIES.plf_clk),
   .nrst(plf_rst_n)
  );

  ////////////////////////////////////////////////////////////////////////
  //?                                                                  ?//
  //?                         TEST BENCH INIT                          ?//
  //?                                                                  ?//
  ////////////////////////////////////////////////////////////////////////

  initial begin
    //-------------------------------------------------
    // Set virtual interfaces to proper UVM components
    //-------------------------------------------------
    uvm_config_db #(virtual rst_if)          ::set(null, "*.m_rst_agent.*",                          "vif", i_rst_if);
    uvm_config_db #(virtual ahb_master_if)   ::set(null, "*.m_ahb_master_agent.*",                   "vif", i_ahb_master_if);
    uvm_config_db #(virtual mac_phy_if)      ::set(null, "*.m_mac_phy_env.*",                        "vif", i_mac_phy_if);
    uvm_config_db #(virtual radio_ctrl_if)   ::set(null, "*.m_radio_env.*",                          "vif", i_radio_ctrl_if);
    uvm_config_db #(virtual modem_stream_if#(`ADCWIDTH)) ::set(null, "*.m_radio_env.m_modem_stream_adc_agent.*", "vif", i_modem_stream_adc_if);
    uvm_config_db #(virtual modem_stream_if#(`DACWIDTH)) ::set(null, "*.m_radio_env.m_modem_stream_dac_agent.*", "vif", i_modem_stream_dac_if);
    uvm_config_db #(virtual rui_if)          ::set(null, "*.m_radio_env.*",                          "vif", i_rui_if);
    uvm_config_db #(virtual sram_if)         ::set(null, "*.m_sram_agent.*",                         "vif", i_sram_if);
    uvm_config_db #(virtual mac_bf_if)       ::set(null, "*.m_mac_bf_agent.*",                       "vif", i_mac_bf_if);
    uvm_config_db #(virtual phy_bf_if)       ::set(null, "*.m_phy_bf_agent.*",                       "vif", i_phy_bf_if);
    uvm_config_db #(virtual mem_if#(`HMEM_WIDTH))::set(null, "*.m_h_mem_agent.*",                    "vif", i_h_mem_if);
    uvm_config_db #(virtual axi_slave_if)    ::set(null, "*.m_axi_slave_write_agent.*",              "vif", i_axi_slave_if);
    uvm_config_db #(virtual axi_slave_if)    ::set(null, "*.m_axi_slave_read_agent.*",               "vif", i_axi_slave_if);
    uvm_config_db #(virtual irq_raw_if #(`PLATFORM_IN_IRQ_WIDTH))  ::set(null, "*.m_irq_raw_platf_in_agent.*",  "vif", i_platf_in_irq_raw_if);
    uvm_config_db #(virtual irq_raw_if #(`PLATFORM_OUT_IRQ_WIDTH)) ::set(null, "*.m_irq_raw_platf_out_agent.*", "vif", i_platf_out_irq_raw_if);
    uvm_config_db #(virtual irq_raw_if #(`MAC_IRQ_CTRL_IN_WIDTH))  ::set(null, "*.m_irq_raw_mac_in_agent.*",  "vif", i_mac_in_irq_raw_if);
    uvm_config_db #(virtual irq_raw_if #(`MAC_IRQ_CTRL_OUT_WIDTH)) ::set(null, "*.m_irq_raw_mac_out_agent.*", "vif", i_mac_out_irq_raw_if);
    uvm_config_db #(virtual coex_bt_if)      ::set(null, "*.m_coex_bt_agent.*",                      "vif", i_coex_bt_if);
    uvm_config_db #(virtual sram_bus_if)     ::set(null, "*.m_sram_bus_agent.*",                     "vif", i_sram_bus_if);
    uvm_config_db #(virtual pta_wlan_if)     ::set(null, "*.m_pta_wlan_agent.*",                     "vif", i_pta_wlan_if);
    uvm_config_db #(virtual bus_monitor_if)  ::set(null, "*.m_bus_monitor_agent.*",                  "vif", i_bus_monitor_if);
    uvm_config_db #(virtual modem_stream_if#(`TXCOREDATA_WIDTH))  ::set(null, "*.m_hdmcore_agent.*", "vif", i_hdmcore_tx_if);
    uvm_config_db #(virtual modem_stream_if#(`TXMAPDATA_WIDTH))   ::set(null, "*.m_txmapper_agent.*","vif", i_hdmcore_mapper_if);
    uvm_config_db #(virtual modem_stream_if#(`EQUWIDTH))          ::set(null, "*.m_equ_agent.*",     "vif", i_equ_if);
    uvm_config_db #(virtual modem_stream_if#(`EQUWIDTH))          ::set(null, "*.m_equ1_agent.*",    "vif", i_equ1_if);
    uvm_config_db #(virtual modem_stream_if#(`LDPCWIDTH))         ::set(null, "*.m_ldpc_agent.*",    "vif", i_ldpc_if);
    uvm_config_db #(virtual modem_stream_if#(`LDPCDATAWIDTH))     ::set(null, "*.m_ldpc_data_agent.*", "vif", i_ldpc_data_if);
    uvm_config_db #(virtual modem_stream_if#(`VITERBIWIDTH))      ::set(null, "*.m_viterbi_in_agent.*", "vif", i_viterbi_in_if);
    uvm_config_db #(virtual mem_if#(`FFTIF_WIDTH))                ::set(null, "*.m_fft_in_agent.*",  "vif", i_fft_in_if);
    uvm_config_db #(virtual mem_if#(`FFTIF_WIDTH))                ::set(null, "*.m_fft_out_agent.*", "vif", i_fft_out_if);
    uvm_config_db #(virtual modem_stream_if#(`DEINTERWIDTH))      ::set(null, "*.m_deint_agent.*",   "vif", i_deint_if);
    //-------------------------------------------------
    run_test();
  end

  ////////////////////////////////////////////////////////////////////////
  //?                                                                  ?//
  //?                    CLOCK & RESET GENERATION                      ?//
  //?                                                                  ?//
  ////////////////////////////////////////////////////////////////////////

  initial
  begin
    `uvm_info("wlan_top_tb", $sformatf(" "), UVM_NONE)
    `uvm_info("wlan_top_tb", $sformatf("System Clocks Configuration"), UVM_NONE)
    `uvm_info("wlan_top_tb", $sformatf("-----------------"), UVM_NONE)
    `uvm_info("wlan_top_tb", $sformatf(" "), UVM_NONE)
    `uvm_info("wlan_top_tb", $sformatf("    - Mac Platform  : %3.3f MHz",( real'(500)/real'(`MACPI_CLK_PERIOD  ) )), UVM_NONE)
    `uvm_info("wlan_top_tb", $sformatf("    - Mac Core      : %3.3f MHz",( real'(500)/real'(`MACCORE_CLK_PERIOD) )), UVM_NONE)
    `uvm_info("wlan_top_tb", $sformatf("    - Mac WEP/TKIP  : %3.3f MHz",( real'(500)/real'(`WT_CLK_PERIOD     ) )), UVM_NONE)
    `uvm_info("wlan_top_tb", $sformatf("    - Mac Low Power : %3.3f KHz",( real'(500e3)/real'(`MACLP_CLK_PERIOD) )), UVM_NONE)
    `uvm_info("wlan_top_tb", $sformatf("    - Phy Ref       : %3.3f MHz",( real'(500)/real'(`SYS_CLK_PERIOD    ) )), UVM_NONE)
    `uvm_info("wlan_top_tb", $sformatf(" "), UVM_NONE)
  end

  // GENERATED CLOCKS
  always #`SYS_CLK_PERIOD     ref_clk   = ~ref_clk;

  always #`MACPI_CLK_PERIOD   mac_pi_clk_i   = ~mac_pi_clk_i;

  always #`MACLP_CLK_PERIOD   mac_lp_clk_i   = ~mac_lp_clk_i;

  always #(`CLK_1MHZ_PERIOD / 2) clk_1mhz = ~clk_1mhz;

  assign plf_root_clk      = mac_pi_clk_i  ;

  assign mac_lp_root_clk   = mac_lp_clk_i;

  always @(negedge mac_wt_clk_i or negedge sys_rst_n)
  begin
    if (!sys_rst_n)
      mac_core_clk_cnt <= 2'd`WEP_2_BB_CLK_RATIO;
    else if ( (mac_core_clk_cnt) == 2'd1)
      mac_core_clk_cnt <= 2'd`WEP_2_BB_CLK_RATIO;
    else
      mac_core_clk_cnt <= mac_core_clk_cnt - 2'd1;
  end

  assign sys_rst_n = i_rst_if.rst_sig;
  assign i_rst_if.clk_1mhz_sig = clk_1mhz;

  //--------------------------------------------------------------------------
  // AHB master signal connections
  //--------------------------------------------------------------------------
  assign proc_haddr  = i_ahb_master_if.haddr;
  assign proc_hwdata = i_ahb_master_if.hwdata;
  assign proc_htrans = i_ahb_master_if.htrans;
  assign proc_hsize  = i_ahb_master_if.hsize;
 // assign proc_hburst = i_ahb_master_if.hburst;
  assign proc_hwrite = i_ahb_master_if.hwrite;

  assign i_ahb_master_if.hrdata  = proc_hrdata;
  assign i_ahb_master_if.hresp   = proc_hresp;
  assign i_ahb_master_if.hclk    = plf_clk;
  assign i_ahb_master_if.hresetn = plf_rst_n;
  assign i_ahb_master_if.hready  = proc_hready;

  // MAC-PHY IF signal connections
  assign i_mac_phy_if.clk   = `RW_HE_TOP.mpif_clk;
  assign i_mac_phy_if.rst_n = `RW_HE_TOP.mac_mpif_rst_n;

`ifndef STANDALONE_MAC

  //--------------------------------------------------------------------------
  // ADC connections
  //--------------------------------------------------------------------------
  assign i_modem_stream_adc_if.clk      = fe_clk;
  assign i_modem_stream_adc_if.rst_n    = fe_rst_n;

  assign ADCDataI0 = i_modem_stream_adc_if.DataI0;
  assign ADCDataQ0 = i_modem_stream_adc_if.DataQ0;
  assign ADCDataI1 = i_modem_stream_adc_if.DataI1;
  assign ADCDataQ1 = i_modem_stream_adc_if.DataQ1;
  assign i_modem_stream_adc_if.On0      = ADCOn0;
  assign i_modem_stream_adc_if.On1      = ADCOn1;

  assign ADCDataEn = ADCOn0 | i_modem_stream_adc_if.DataEn0 | i_modem_stream_adc_if.DataEn1;

  always @ (posedge `RW_HE_CRM.ref80_root_clk, negedge `RW_HE_CRM.ref80_rst_n) begin
    if (!`RW_HE_CRM.ref80_rst_n) begin
      AGCCount <= 'h0;
    end else begin
      if ((ADCDataEn === 1'b1) && (i_modem_stream_adc_if.data_valid === 1'b1))
        AGCCount <= AGCCount + 'h1;
      else
        AGCCount <= 'h0;
    end
  end

  //--------------------------------------------------------------------------
  // DAC connections
  //--------------------------------------------------------------------------
  assign i_modem_stream_dac_if.clk     = fe_clk;
  assign i_modem_stream_dac_if.rst_n   = fe_rst_n;
  assign i_modem_stream_dac_if.DataI0  = DACDataI0;
  assign i_modem_stream_dac_if.DataQ0  = DACDataQ0;
  assign i_modem_stream_dac_if.DataEn0 = DACDataEn0;
  assign i_modem_stream_dac_if.On0     = DACOn0;
  assign i_modem_stream_dac_if.DataI1  = DACDataI1;
  assign i_modem_stream_dac_if.DataQ1  = DACDataQ1;
  assign i_modem_stream_dac_if.DataEn1 = DACDataEn1;
  assign i_modem_stream_dac_if.On1     = DACOn1;

  //--------------------------------------------------------------------------
  // HDMCore Tx path connections
  //--------------------------------------------------------------------------
  assign i_hdmcore_tx_if.clk        = `HDM_TXCORE.clk;
  assign i_hdmcore_tx_if.rst_n      = `HDM_TXCORE.rst_n;
  assign i_hdmcore_tx_if.data_valid = `HDM_TXCORE.feif_valid;
  assign i_hdmcore_tx_if.data_ready = `HDM_TXCORE.feif_ready;
  assign i_hdmcore_tx_if.data       = {`HDM_TXCORE.feif_enable,
                                       `HDM_TXCORE.feif_i,
                                       `HDM_TXCORE.feif_q};

  //--------------------------------------------------------------------------
  // HDMCore mapper path connections
  //--------------------------------------------------------------------------
  reg [`SYMBCNT_WIDTH-1:0]  map_symb_cnt;
  reg [`MAPINDEX_WIDTH-1:0] fft_index_scaled;

  assign i_hdmcore_mapper_if.clk        = `HDM_TXCORE.clk;
  assign i_hdmcore_mapper_if.rst_n      = `HDM_TXCORE.rst_n;
  assign i_hdmcore_mapper_if.data_valid = `HDM_TXCORE.u_tx_fd_dup.fft_en;
  assign i_hdmcore_mapper_if.data_ready = 1'b1;
  assign i_hdmcore_mapper_if.data       = {fft_index_scaled,
                                           map_symb_cnt,
                                           `HDM_TXCORE.u_tx_fd_dup.fft_i0,
                                           `HDM_TXCORE.u_tx_fd_dup.fft_q0};

  // calculate number of symbols processed
  always @(posedge `HDM_TXCORE.clk,negedge `HDM_TXCORE.rst_n)
  begin
    if (!`HDM_TXCORE.rst_n)
      map_symb_cnt <= 0;
    else if (`PHY_DUT.feif_tx_done) // reset counter when frame is processed
      map_symb_cnt <= 0;
    else if (`HDM_TXCORE.u_tx_fd_dup.done)
      map_symb_cnt <= map_symb_cnt + 1;
  end

  // FFT index needs scaling for some symbols
  always @(*)
  begin : FFT_INDEX_SCALED
    case (`HDM_TXCORE.u_tx_scheduler.s_fd_symbol)
      "HESTF": fft_index_scaled = 4 * `HDM_TXCORE.u_tx_fd_dup.fft_index;

      "HELTF": if (`HDM_TXCORE.u_tx_fd_dup.frame_heltf_type == 2'b00)
                 fft_index_scaled = 4 * `HDM_TXCORE.u_tx_fd_dup.fft_index;
               else if (`HDM_TXCORE.u_tx_fd_dup.frame_heltf_type == 2'b01)
                 fft_index_scaled = 2 * `HDM_TXCORE.u_tx_fd_dup.fft_index;
               else
                 fft_index_scaled = `HDM_TXCORE.u_tx_fd_dup.fft_index;

      "HEPE":  fft_index_scaled = 4 * `HDM_TXCORE.u_tx_fd_dup.fft_index;
      default: fft_index_scaled = `HDM_TXCORE.u_tx_fd_dup.fft_index;
    endcase
  end

  //--------------------------------------------------------------------------
  // FFT input memory
  //--------------------------------------------------------------------------
  reg [15:0] fft_in_symb_cnt;

  always @(posedge `PHYFFT.clk, negedge `PHYFFT.rst_n)
  begin
    if (!`PHYFFT.rst_n)
      fft_in_symb_cnt <= 0;
    else if (`RXTD_TOP.FDDone) //end of frame
      fft_in_symb_cnt <= 0;
    else if (`PHY_DUT.mfsm_rxend && i_fft_in_if.is_write_active == 0 && i_fft_out_if.is_read_active == 0)
      fft_in_symb_cnt <= 0;
    else if (`PHYFFT.start && `RXTD_TOP.RxTDEnable) //end of symbol
      if (`PHYFFT.rxtd_wlen == 3'b110)
        fft_in_symb_cnt <= fft_in_symb_cnt + 2; //increment by 2 for primary-secondary
      else
        fft_in_symb_cnt <= fft_in_symb_cnt + 1;
  end

  assign i_fft_in_if.clk      = `PHYFFT.clk;
  assign i_fft_in_if.rst_n    = `PHYFFT.rst_n;
  assign i_fft_in_if.done     = `PHYFFT.done | `RXTD_TOP.FDDone;
  assign i_fft_in_if.enable   = `PHYFFT.enable;
  assign i_fft_in_if.symb_cnt = fft_in_symb_cnt;

  always @(*)
  begin : FORCE_FFTMUX_INPUTS
    if (i_fft_in_if.is_write_active == 1'b1) begin
      force `PHYFFT.start       = i_fft_in_if.start;
      force `PHYFFT.dir         = i_fft_in_if.dir;
      force `PHY_DUT.u_fft.dir  = i_fft_in_if.dir;
      force `PHYFFT.rxtd_wen    = i_fft_in_if.wen;
      force `PHYFFT.rxtd_wsel   = i_fft_in_if.wsel;
      force `PHYFFT.rxtd_windex = i_fft_in_if.windex;
      force `PHYFFT.rxtd_wscale = i_fft_in_if.wscale;
      force `PHYFFT.rxtd_wlen   = i_fft_in_if.wlen;
      force `PHYFFT.rxtd_wpi    = i_fft_in_if.wpi;
      force `PHYFFT.rxtd_wpq    = i_fft_in_if.wpq;
      force `PHYFFT.rxtd_wsi    = i_fft_in_if.wsi;
      force `PHYFFT.rxtd_wsq    = i_fft_in_if.wsq;
      force `RXTD_TOP.RxTDDone  = i_fft_in_if.td_done;
    end
    else begin
      i_fft_in_if.start    = `PHYFFT.start & i_mac_phy_if.rx_req;
      i_fft_in_if.wen      = `PHYFFT.rxtd_wen;
      i_fft_in_if.wsel     = `PHYFFT.rxtd_wsel;
      //i_fft_in_if.windex   = `PHYFFT.rxtd_windex;
      i_fft_in_if.windex   = `PHY_DUT.tdmemwraddr;
      i_fft_in_if.wlen     = `PHYFFT.rxtd_wlen;
      i_fft_in_if.wpi      = `PHYFFT.rxtd_wpi;
      i_fft_in_if.wpq      = `PHYFFT.rxtd_wpq;
      i_fft_in_if.wsi      = `PHYFFT.rxtd_wsi;
      i_fft_in_if.wsq      = `PHYFFT.rxtd_wsq;
    end
  end// FORCE_FFTMUX_INPUTS

  //--------------------------------------------------------------------------
  // FFT output memory
  //--------------------------------------------------------------------------
  reg [15:0] fft_out_symb_cnt;
  wire       fft_out_en;
  reg        sec_read_en; // read of secondary
  reg        last_ff1, last_ff2;
  reg        f_valid1, f_valid2;
  reg        addr_valid1, addr_valid2;
  reg [8:0]  delayed_index1, delayed_index2;
  reg        delayed_ren1, delayed_ren2;

  // start reading secondary channel samples
  always @(posedge `PHYFFT.clk, negedge `PHYFFT.rst_n)
  begin
    if (!`PHYFFT.rst_n)
      sec_read_en <= 0;
    else if (`PHYFFT.rxfd_ren & `PHYFFT.rxfd_rps & ~`PHYFFT.rxfd_rvalid) //end of frame
      sec_read_en <= 1;
    else if (`PHYFFT.done && fft_out_en)
      sec_read_en <= 0;
  end

  always @(posedge `PHYFFT.clk, negedge `PHYFFT.rst_n)
  begin
    if (!`PHYFFT.rst_n)
      fft_out_symb_cnt <= 0;
    else if (`RXFD_TOP.FDDone) //end of frame
      fft_out_symb_cnt <= 0;
    else if (`PHY_DUT.mfsm_rxend && i_fft_out_if.is_read_active == 0 && i_fft_in_if.is_write_active == 0)
      fft_out_symb_cnt <= 0;
    else if (`PHYFFT.done && fft_out_en) //end of symbol
      if (sec_read_en)  // read secondary channel
        fft_out_symb_cnt <= fft_out_symb_cnt + 2;
      else
        fft_out_symb_cnt <= fft_out_symb_cnt + 1;
  end

  // 2 clock cycles delay for read index last
  always @(posedge `PHYFFT.clk, negedge `PHYFFT.rst_n)
  begin
    if (!`PHYFFT.rst_n) begin
      last_ff1 <= 1'b0;
      last_ff2 <= 1'b0;
      f_valid1 <= 1'b0;
      f_valid2 <= 1'b0;
      addr_valid1 <= 1'b0;
      addr_valid2 <= 1'b0;
      delayed_index1  <= 9'b0;
      delayed_index2  <= 9'b0;
      delayed_ren1    <= 1'b0;
      delayed_ren2    <= 1'b0;
    end
    else begin
      f_valid1        <= `EQU_TOP.u_equalizer_genindex.f_valid;
      f_valid2        <= f_valid1;
      last_ff1        <= `EQU_TOP.u_equalizer_genindex.f_last;
      delayed_index1  <= `RXFD_TOP.FFTMemRdAddr;
      delayed_index2  <= delayed_index1;
      delayed_ren1    <= `RXFD_TOP.FFTMemRdEn;
      delayed_ren2    <= delayed_ren1;
      last_ff2        <= last_ff1;
      addr_valid1     <= `RXFD_TOP.U_ChEstSmthTop.FFTBufRdAddrEnOut;
      addr_valid2     <= addr_valid1;
    end
  end

  assign fft_out_en = `RXFD_TOP.FDEnable | i_fft_out_if.is_read_active;

  assign i_fft_out_if.clk      = `PHYFFT.clk;
  assign i_fft_out_if.rst_n    = `PHYFFT.rst_n;
  assign i_fft_out_if.start    = `PHYFFT.start;
  assign i_fft_out_if.done     = `PHYFFT.done;
  assign i_fft_out_if.enable   = `PHYFFT.enable;
  assign i_fft_out_if.symb_cnt = fft_out_symb_cnt;
  assign i_fft_out_if.ri       = `PHYFFT.rxfd_ri;
  assign i_fft_out_if.rq       = `PHYFFT.rxfd_rq;
  assign i_fft_out_if.rvalid   = f_valid2 | addr_valid2;
  assign i_fft_out_if.rsel     = `PHYFFT.rxfd_rsel;
  assign i_fft_out_if.rlen     = `PHY_DUT.fftmux_len;
  assign i_fft_out_if.last     = last_ff2;


  always @(*)
  begin : FORCE_RXFD_MEM_RD
    if (i_fft_out_if.is_read_active) begin
      force `PHYFFT.rxfd_ren     = i_fft_out_if.ren;
      force `PHYFFT.rxfd_rindex  = i_fft_out_if.rindex;
      force `PHYFFT.rxfd_rps     = i_fft_out_if.rps;
    end
    else begin
      i_fft_out_if.ren    = delayed_ren2;
      i_fft_out_if.rindex = delayed_index2;
      i_fft_out_if.rps    = `PHYFFT.rxfd_rps;
    end
  end

  //--------------------------------------------------------------------------
  // RUI IF -  AGC bypass
  //--------------------------------------------------------------------------
  assign i_rui_if.clk    = `PHY_DUT.phy_clk;
  assign i_rui_if.rst_n  = `PHY_DUT.phy_rst_n;
  assign i_rui_if.ADC0On =  ADCOn0;
  assign i_rui_if.ADC1On =  ADCOn1;

  reg [1:0]  fdfft_buf_rd_ptr;
  reg [1:0]  tdfft_buf_wr_ptr;
  reg [15:0] latency_cnt;
  reg        start_cnt;
  reg [7:0]  fddone_latency_cnt;
  reg        tddone_flag;
  wire       agcBypass_fe;
  reg        agcBypass_d;
  wire       fddone;
  reg        set_format_mod;
  reg        ren_d;
  wire       ren_fe;
  reg        param_update1;
  reg        param_update2;
  reg        param_update3;
  reg        param_update4;
  reg        param_update5;
  reg [1:0]  fft_buf_ptr;
  reg [1:0]  bd_buf_rd_ptr;
  reg [2:0]  bd_buf0_rd_ptr;
  reg [2:0]  bd_buf1_rd_ptr;
  reg [2:0]  bd_row_rd_ptr;
  reg [15:0] bd_cnt_latency;
  reg [15:0] bd0_cnt_latency;
  reg [15:0] bd1_cnt_latency;
  reg [15:0] bd_row_cnt_latency;
  reg        start_bd_cnt;
  reg        start_bd0_cnt;
  reg        start_bd1_cnt;
  reg        start_bd_row_cnt;
  reg [2:0]  fft_len;

  always @(posedge `PHY_DUT.phy_clk, negedge `PHY_DUT.phy_rst_n)
  begin : CAPTURE_FFT_LEN
    if (!`PHY_DUT.phy_rst_n)
      fft_len <= 0;
    else if (`PHYFFT.start)
      fft_len <= `RXTD_TOP.FFTLen;
  end

  always @(posedge `PHY_DUT.phy_clk, negedge `PHY_DUT.phy_rst_n)
  begin : GEN_FDFFT_RD_PTR
    if (!`PHY_DUT.phy_rst_n) begin
      fdfft_buf_rd_ptr <= 0;
      tdfft_buf_wr_ptr <= 0;
      start_cnt        <= 0;
      latency_cnt      <= 0;
    end
    else if (  (fft_len == 3'b000 && latency_cnt == `LATENCY_FFT64)
            || (fft_len == 3'b001 && latency_cnt == `LATENCY_FFT128)
            || (fft_len == 3'b010 && latency_cnt == `LATENCY_FFT256)
            || (fft_len == 3'b011 && latency_cnt == `LATENCY_FFT512)
            || (fft_len == 3'b100 && latency_cnt == `LATENCY_FFT1024)
            // secondary channel
            || (fft_len == 3'b110 && latency_cnt == (2*`LATENCY_FFT64))) begin
      fdfft_buf_rd_ptr <= tdfft_buf_wr_ptr;
      latency_cnt      <= 0;
      start_cnt        <= 0;
    end
    else if (fft_len == 3'b111) begin
      latency_cnt      <= 0;
      tdfft_buf_wr_ptr <= 0;
      start_cnt        <= 0;
    end
    else if (tdfft_buf_wr_ptr != `RXTD_TOP.U_RxTimeDomainStMc.TDFFTBufWrPtr) begin
      tdfft_buf_wr_ptr <= `RXTD_TOP.U_RxTimeDomainStMc.TDFFTBufWrPtr;
      latency_cnt      <= 0;
      start_cnt        <= 1'b1;
    end
    else if (start_cnt) begin
      latency_cnt <= latency_cnt + 1;
    end
  end//always

  always @(posedge `PHY_DUT.phy_clk, negedge `PHY_DUT.phy_rst_n)
  begin : GEN_FDDONE
    if (!`PHY_DUT.phy_rst_n) begin
      tddone_flag <= 0;
      fddone_latency_cnt <= 0;
    end
    else if (tddone_flag == 0 && agcBypass_fe) begin
      tddone_flag <= 1'b1;
    end
    else if (tddone_flag == 1'b1 && fddone_latency_cnt < `LATENCY_FDDONE) begin
      fddone_latency_cnt <= fddone_latency_cnt + 1;
    end
    else begin
      fddone_latency_cnt <= 0;
      tddone_flag        <= 0;
    end
    agcBypass_d <= i_rui_if.agcBypass;
  end//always

  // capture faling edge of agcBypass
  assign agcBypass_fe = (~i_rui_if.agcBypass && agcBypass_d) ? 1'b1 : 1'b0;
  // create FDDone pulse when terminal count is reached
  assign fddone = (fddone_latency_cnt == `LATENCY_FDDONE) ? 1'b1 : 1'b0;

  // update FDFormatMod in proper time
  always @(posedge `PHY_DUT.phy_clk, negedge `PHY_DUT.phy_rst_n)
  begin: SET_FORMAT_MOD_UPDATE
    if (!`PHY_DUT.phy_rst_n) begin
      set_format_mod <= 1'b0;
      ren_d          <= 1'b0;
      param_update1  <= 1'b0;
      param_update2  <= 1'b0;
      param_update3  <= 1'b0;
      param_update4  <= 1'b0;
      param_update5  <= 1'b0;
    end
    else begin
      ren_d <= `PHYFFT.rxfd_ren;

      // set param update 1
      if (`RXFD_TOP.FDDone)
        param_update1 <= 1'b0;
      else if (( (i_rui_if.frm_format_mod <= 4'h1 && fft_out_symb_cnt >= 16'd2) //NON-HT
               ||(i_rui_if.frm_format_mod == 4'h2 && fft_out_symb_cnt >= 16'd4) //HT-MF
               ||(i_rui_if.frm_format_mod == 4'h3 && fft_out_symb_cnt >= 16'd3) //HT-GF
               ||(i_rui_if.frm_format_mod == 4'h4 && fft_out_symb_cnt >= 16'd4) //VHT
               ||(i_rui_if.frm_format_mod >= 4'h5 && fft_out_symb_cnt >= 16'd5)) && ren_fe) //HE
        param_update1 <= 1'b1;

      // set param update 2
      if (`RXFD_TOP.FDDone)
        param_update2 <= 1'b0;
      else if (( (i_rui_if.frm_format_mod <= 4'h1 && fft_out_symb_cnt >= 16'd2) //NON-HT
               ||(i_rui_if.frm_format_mod == 4'h2 && fft_out_symb_cnt >= 16'd4) //HT-MF
               ||(i_rui_if.frm_format_mod == 4'h3 && fft_out_symb_cnt >= 16'd3) //HT-GF
               ||(i_rui_if.frm_format_mod == 4'h4 && fft_out_symb_cnt >= 16'd4) //VHT
               ||(i_rui_if.frm_format_mod >= 4'h5 && fft_out_symb_cnt >= 16'd5)) && ren_fe) //HE
        param_update2 <= 1'b1;

      // set param update 3
      if (`RXFD_TOP.FDDone)
        param_update3 <= 1'b0;
      else if (( (i_rui_if.frm_format_mod <= 4'h1 && fft_out_symb_cnt >= 16'd2) //NON-HT
               ||(i_rui_if.frm_format_mod == 4'h2 && fft_out_symb_cnt >= 16'd3) //HT-MF
               ||(i_rui_if.frm_format_mod == 4'h3 && fft_out_symb_cnt >= 16'd2) //HT-GF
               ||(i_rui_if.frm_format_mod == 4'h4 && fft_out_symb_cnt >= 16'd4) //VHT
               ||(i_rui_if.frm_format_mod >= 4'h5 && fft_out_symb_cnt >= 16'd5)) && ren_fe) //HE
        param_update3 <= 1'b1;

      // set param update 4
      if (`RXFD_TOP.FDDone)
        param_update4 <= 1'b0;
      else if (i_rui_if.frm_format_mod == 4'h3) //HT-GF
        param_update4 <= 1'b0;
      else if (( (i_rui_if.frm_format_mod <= 4'h1 && fft_out_symb_cnt >= 16'd2) //NON-HT
               ||(i_rui_if.frm_format_mod == 4'h2 && fft_out_symb_cnt >= 16'd2) //HT-MF
               ||(i_rui_if.frm_format_mod == 4'h4 && fft_out_symb_cnt >= 16'd2) //VHT
               ||(i_rui_if.frm_format_mod >= 4'h5 && fft_out_symb_cnt >= 16'd2)) && ren_fe) //HE
        param_update4 <= 1'b1;

      // set param update 5
      if (`RXFD_TOP.FDDone)
        param_update5 <= 1'b0;
      else if (fft_out_symb_cnt >= 16'd3 && ren_fe) //HE
        param_update5 <= 1'b1;


      // set format mode
      if (`RXFD_TOP.FDDone)
        set_format_mod <= 1'b0;
      else if (( (i_rui_if.frm_format_mod <= 4'h2 && fft_out_symb_cnt >= 16'd3)
               ||(i_rui_if.frm_format_mod == 4'h3 && fft_out_symb_cnt >= 16'd2)
               ||(i_rui_if.frm_format_mod == 4'h4 && fft_out_symb_cnt >= 16'd4)
               ||(i_rui_if.frm_format_mod >= 4'h5 && fft_out_symb_cnt >= 16'd4)) && ren_fe)
        set_format_mod <= 1'b1;
    end//else
  end//always

  assign ren_fe = (i_fft_out_if.is_read_active == 1'b1)
                  ? ((~`PHYFFT.rxfd_ren && ren_d) ? 1'b1 : 1'b0)// TD domain testing
                  : 1'b1;

  // Time Domain Block
  always @(*)
  begin : FORCE_FRAME_PARAM_INPUTS_TD
    if (i_fft_out_if.is_read_active == 1'b1) begin
      // drive frame parameters
      force `RXTD_TOP.FrameParam1Update   = param_update1;
      force `RXTD_TOP.FrameParam8Update   = param_update2;
      force `RXTD_TOP.FrameParam7Update   = param_update1;


      if (param_update1) begin
        force `RXTD_TOP.FrameParamNESS      = i_rui_if.frm_param_ness;
        force `RXTD_TOP.FrameParamNHeltf    = i_rui_if.frm_param_num_he_ltf;
        force `RXTD_TOP.FrameParamNHeSigB   = i_rui_if.frm_param_he_sigb;
        force `RXTD_TOP.FrameParamNSym      = i_rui_if.frm_param_nsymb;
        force `RXTD_TOP.FrameParamGIType    = i_rui_if.frm_param_gi_type;
        force `RXTD_TOP.FrameParamHeltfType = i_rui_if.frm_param_he_ltf_type;
        force `RXTD_TOP.FrameParamCBW       = i_rui_if.frm_param_cbw;
        force `RXTD_TOP.FrameParamVHTNDP    = i_rui_if.frm_param_vht_ndp;
        force `RXTD_TOP.FrameParamNSTS      = i_rui_if.frm_param_nsts;
        force `RXTD_TOP.FrameParamTPE       = i_rui_if.frm_param_tpe;
        force `RXTD_TOP.FrameParamDoppler   = i_rui_if.frm_param_doppler;
        force `RXTD_TOP.FrameParamMidamble  = i_rui_if.frm_param_midamble;
        force `RXTD_TOP.FrameParamNMA       = i_rui_if.frm_param_nma;
        force `RXTD_TOP.FDCpeSlope          = i_rui_if.FDCpeSlope;
        force `RXTD_TOP.FrameParamNSD       = i_rui_if.frm_param_nsd;
      end
      else begin
        force `RXTD_TOP.FrameParamNESS      = 0;
        force `RXTD_TOP.FrameParamNHeltf    = 0;
        force `RXTD_TOP.FrameParamNHeSigB   = 0;
        force `RXTD_TOP.FrameParamNSym      = 0;
        force `RXTD_TOP.FrameParamGIType    = 0;
        force `RXTD_TOP.FrameParamHeltfType = 0;
        force `RXTD_TOP.FrameParamCBW       = 0;
        force `RXTD_TOP.FrameParamVHTNDP    = 0;
        force `RXTD_TOP.FrameParamNSTS      = 0;
        force `RXTD_TOP.FrameParamTPE       = 0;
        force `RXTD_TOP.FrameParamDoppler   = 0;
        force `RXTD_TOP.FrameParamMidamble  = 0;
        force `RXTD_TOP.FrameParamNMA       = 0;
        force `RXTD_TOP.FDCpeSlope          = 0;
        force `RXTD_TOP.FrameParamNSD       = 0;
      end
      if (set_format_mod)
        force `RXTD_TOP.FDFormatMod = i_rui_if.frm_format_mod;
      else
        force `RXTD_TOP.FDFormatMod = 0;

      // Disabling Freq & Bit domain block for TD testing
      force `RXFD_TOP.FDEnable    = 1'b0;
      force `RXBD_TOP.enable        = 1'b0;
      force `PHY_DUT.core_enable  = 1'b1;
      force `PHY_DUT.mfsm_rxend   = 1'b1;
      force `PHY_DUT.mfsm_rxvector1_done = 1'b1;
      // drive read pointer for TD
      force `RXTD_TOP.FDFFTBufRdPtr = fdfft_buf_rd_ptr;
      // force always because of delay
      force `RXTD_TOP.FDDone              = fddone;
      force `PHY_DUT.mfsm_ofdm_rx_fd_done = fddone;
      force `PHY_DUT.mfsm_ofdm_rx_sfo_done = fddone;
    end//if
  end//FORCE_FRAME_PARAM_INPUTS_TD

  // Frequency Domain Block
  always @(*)
  begin : FORCE_FRAME_PARAM_INPUTS_FD

    if (i_fft_in_if.is_write_active == 1'b1) begin

//       force `RXTD_TOP.U_TDFOTop.RatioNoiseSignal = i_rui_if.RatioNoiseSignal;
//       force `RXTD_TOP.U_TDFOTop.RatioShift       = i_rui_if.RatioShift;

      // Disabling Bit Domain block for FD testcases
      force `RXBD_TOP.enable = 1'b0;

      // force to unlock mfsm
      force `PHY_DUT.mfsm_rxend           = 1'b1;
      force `PHY_DUT.mfsm_rxvector1_done  = 1'b1;

      // drive frame parameters
      force `RXFD_TOP.FrameParam1Update   = param_update1;
      force `RXFD_TOP.FrameParam2Update   = param_update2;
      force `RXFD_TOP.FrameParam3Update   = param_update5;
      force `RXFD_TOP.FrameParam4Update   = param_update4;
      force `RXFD_TOP.FrameParam6Update   = param_update4;
      force `RXFD_TOP.FrameParam7Update   = param_update1;
      force `RXFD_TOP.FrameParam8Update   = param_update2;

      force `RXFD_TOP.FrameParam1NSD         = i_rui_if.frm_param_nsd;
      force `RXFD_TOP.FrameParam1NBPSC0      = i_rui_if.frm_param_nbpsc0;
      force `RXFD_TOP.FrameParam1NBPSC1      = i_rui_if.frm_param_nbpsc1;
      force `RXFD_TOP.FrameParam1NSS         = i_rui_if.frm_param_nss;
      force `RXFD_TOP.FrameParam1NSTS        = i_rui_if.frm_param_nsts;
      force `RXFD_TOP.FrameParam1NESS        = i_rui_if.frm_param_ness;
      force `RXFD_TOP.FrameParam1STBC        = i_rui_if.frm_param_stbc;
      force `RXFD_TOP.FrameParam1FEC         = i_rui_if.frm_param_fec;
      force `RXFD_TOP.FrameParam1Smoothing   = i_rui_if.frm_param_smoothing;
      force `RXFD_TOP.FrameParam1HTNDP       = i_rui_if.frm_param_htndp;
      force `RXFD_TOP.FrameParam1NHeltf      = i_rui_if.frm_param_num_he_ltf;
      force `RXFD_TOP.FrameParam1CBW         = i_rui_if.frm_param_cbw;
      force `RXFD_TOP.FrameParam1HeltfType   = i_rui_if.frm_param_he_ltf_type;
      force `RXFD_TOP.FrameParam1NBPSCHeSigB = i_rui_if.frm_param_nbpsc_hesigb;
      force `RXFD_TOP.FrameParam1Doppler     = i_rui_if.frm_param_doppler;
      force `RXFD_TOP.FrameParam1Midamble    = i_rui_if.frm_param_midamble;
      force `RXFD_TOP.FrameParam1DCM         = i_rui_if.frm_param_dcm;
      force `RXFD_TOP.FrameParam1HESIGBMCS   = i_rui_if.frm_param_hesigb_mcs;
      force `RXFD_TOP.FrameParam1HESIGBDCM   = i_rui_if.frm_param_hesigb_dcm;
      force `RXFD_TOP.FrameParam2RUIndex     = i_rui_if.frm_param_ruindex+1;
      force `RXFD_TOP.FrameParam2RUType      = i_rui_if.frm_param_rutype;
      force `RXFD_TOP.FrameParam2HEMUDCM     = i_rui_if.frm_param_dcm;
      force `RXFD_TOP.FrameParam8NSym        = i_rui_if.frm_param_nsymb;
      force `RXFD_TOP.FrameParam8NMA         = i_rui_if.frm_param_nma;

      // HE-MU
      if (i_rui_if.frm_format_mod == 4'h6) begin
        force `RXFD_TOP.FrameParam2HEMUFEC   = i_rui_if.frm_param_fec;
        force `RXFD_TOP.FrameParam2MuNBPSC   = i_rui_if.frm_param_nbpsc0;
      end
      else begin
        force `RXFD_TOP.FrameParam2HEMUFEC   = 0;
        force `RXFD_TOP.FrameParam2MuNBPSC   = 0;
      end
      force `RXFD_TOP.FrameParam3RLSIG       = i_rui_if.frm_param5_rlsig;
      force `RXFD_TOP.FrameParam4LSIG6M      = i_rui_if.frm_param_lsig6m;
      force `RXFD_TOP.FrameParam6HeSu        = ~i_rui_if.frm_param4_hemu;
      force `RXFD_TOP.FrameParam7NHeSigB     = i_rui_if.frm_param_he_sigb;


      // FD buffer pointer
      force `RXFD_TOP.FFTBufPtr = fft_buf_ptr;
      // disable RxTD block
      force `RXTD_TOP.RxTDEnable = 0;
      // force BD buffer read pointer
      force `RXFD_TOP.bdfd_rdptr          = bd_buf_rd_ptr;
      force `RXFD_TOP.bdfd_ch0_rdptr      = bd_buf0_rd_ptr;
      force `RXFD_TOP.bdfd_ch1_rdptr      = bd_buf1_rd_ptr;
      force `RXFD_TOP.bdfd_row_fifo_rdptr = bd_row_rd_ptr;
`ifdef RW_NX_LDPC_DEC
      // force BD fifo ready for LDPC
      force `RXFD_TOP.bdfd_ldpc_ready = 1;
`endif
    end//if
  end//FORCE_FRAME_PARAM_INPUTS_FD

  always @(posedge `PHY_DUT.phy_clk, negedge `PHY_DUT.phy_rst_n)
  begin: SET_FFT_BUF_PTR
    if (!`PHY_DUT.phy_rst_n) begin
      fft_buf_ptr        <= 0;
      bd_buf_rd_ptr      <= 0;
      bd_buf0_rd_ptr     <= 0;
      bd_buf1_rd_ptr     <= 0;
      bd_row_rd_ptr      <= 0;
      bd_cnt_latency     <= 0;
      bd0_cnt_latency    <= 0;
      bd1_cnt_latency    <= 0;
      bd_row_cnt_latency <= 0;
      start_bd_cnt       <= 0;
      start_bd0_cnt      <= 0;
      start_bd1_cnt      <= 0;
      start_bd_row_cnt   <= 0;
    end
    else begin
      if (`RXFD_TOP.FDDone)
        fft_buf_ptr <= 0;
      else if (`PHYFFT.done)
        fft_buf_ptr <= fft_buf_ptr + 1;

      // assign BD read pointer
      if (bd_buf_rd_ptr != `RXFD_TOP.bdfd_wrptr && start_bd_cnt == 1'b0) begin
        start_bd_cnt <= 1'b1;
      end
      else if (bd_cnt_latency == `LATENCY_BDBUFRD) begin
        bd_buf_rd_ptr  <= bd_buf_rd_ptr + 1;
        bd_cnt_latency <= 0;
        start_bd_cnt   <= 0;
      end
      else if (start_bd_cnt) begin
        bd_cnt_latency <= bd_cnt_latency + 1;
      end

      // assign BD channel content read pointers for HE-SIGB
      if (bd_buf0_rd_ptr != `RXFD_TOP.bdfd_ch0_wrptr && start_bd0_cnt == 1'b0) begin
        start_bd0_cnt <= 1'b1;
      end
      else if (bd0_cnt_latency == `LATENCY_BDBUFRD) begin
        bd_buf0_rd_ptr  <= bd_buf0_rd_ptr + 1;
        bd0_cnt_latency <= 0;
        start_bd0_cnt   <= 0;
      end
      else if (start_bd0_cnt) begin
        bd0_cnt_latency <= bd0_cnt_latency + 1;
      end
      if (bd_buf1_rd_ptr != `RXFD_TOP.bdfd_ch1_wrptr && start_bd1_cnt == 1'b0) begin
        start_bd1_cnt <= 1'b1;
      end
      else if (bd1_cnt_latency == `LATENCY_BDBUFRD) begin
        bd_buf1_rd_ptr  <= bd_buf1_rd_ptr + 1;
        bd1_cnt_latency <= 0;
        start_bd1_cnt   <= 0;
      end
      else if (start_bd1_cnt) begin
        bd1_cnt_latency <= bd1_cnt_latency + 1;
      end
      // assign BD row fifo content read pointers for viterbi
      if (bd_row_rd_ptr != `RXFD_TOP.bdfd_row_fifo_wrptr && start_bd_row_cnt == 1'b0) begin
        start_bd_row_cnt <= 1'b1;
      end
      else if (bd_row_cnt_latency == `LATENCY_BDBUFRD) begin
        bd_row_rd_ptr      <= bd_row_rd_ptr + 1;
        bd_row_cnt_latency <= 0;
        start_bd_row_cnt   <= 0;
      end
      else if (start_bd_row_cnt) begin
        bd_row_cnt_latency <= bd_row_cnt_latency + 1;
      end

    end//else
  end//always

  // forcing FE signals
  always @(*)
  begin : FORCE_FE_INPUTS
    if (i_rui_if.agcBypass == 1'b1) begin
      // signals that must be forced
      force `HDM_RXCORE.AGCOFDMHTSTF  = 1'b0;
      force `PHY_DUT.agc_ofdm_lock    = i_rui_if.AGCOFDMLock;
      force `PHY_DUT.agc_p1_noise_var_db = i_rui_if.noise_variance;
      force `PHY_DUT.agc_p1_update    = i_rui_if.agc_update;
      // drive FE input signals
      force `PHY_DUT.feif_rx_20p_i0   = i_rui_if.RxDataIn20PRe0;
      force `PHY_DUT.feif_rx_20p_q0   = i_rui_if.RxDataIn20PIm0;
      force `PHY_DUT.feif_rx_valid_20 = i_rui_if.RxDataValidIn20;
      force `PHY_DUT.feif_rx_20s_i0   = i_rui_if.RxDataIn20SRe;
      force `PHY_DUT.feif_rx_20s_q0   = i_rui_if.RxDataIn20SIm;
      force `PHY_DUT.feif_rx_40p_i0   = i_rui_if.RxDataIn40PRe0;
      force `PHY_DUT.feif_rx_40p_q0   = i_rui_if.RxDataIn40PIm0;
      force `PHY_DUT.feif_rx_valid_40 = i_rui_if.RxDataValidIn40;
      force `PHY_DUT.feif_rx_80p_i0   = i_rui_if.RxDataIn80PRe0;
      force `PHY_DUT.feif_rx_80p_q0   = i_rui_if.RxDataIn80PIm0;
      force `PHY_DUT.feif_rx_valid_80 = i_rui_if.RxDataValidIn80;
      // drive SNR
      force `PHY_DUT.agc_p1_snr       = i_rui_if.agc_snr;
      // flag to know when PHY has finished with reception
      i_rui_if.data_done              =   `PHY_DUT.mfsm_ofdm_rx_td_done
                                        | `PHY_DUT.mfsm_ofdm_rx_fd_done
                                        | `PHY_DUT.mac_rxerr
                                        | `RXBD_TOP.mfsm_frame_violation;

    end//if
    else begin
      release `HDM_RXCORE.AGCOFDMHTSTF;
      release `PHY_DUT.agc_ofdm_lock;
      release `PHY_DUT.agc_p1_noise_var_db;
      release `PHY_DUT.agc_p1_update;
      // drive FE input signals
      release `PHY_DUT.feif_rx_20p_i0;
      release `PHY_DUT.feif_rx_20p_q0;
      release `PHY_DUT.feif_rx_valid_20;
      release `PHY_DUT.feif_rx_20s_i0;
      release `PHY_DUT.feif_rx_20s_q0;
      release `PHY_DUT.feif_rx_40p_i0;
      release `PHY_DUT.feif_rx_40p_q0;
      release `PHY_DUT.feif_rx_valid_40;
      // drive SNR
      release `PHY_DUT.agc_p1_snr;
      i_rui_if.data_done = 0;
    end//else
  end//FORCE_FE_INPUTS

  //--------------------------------------------------------------------------
  // SPI
  //--------------------------------------------------------------------------
  assign rf_spi_in = i_radio_ctrl_if.spi_miso;    // SPI Master IN slave OUT
  assign i_radio_ctrl_if.spi_ss_n = rf_spi_ss_n;  // SPI slave select
  assign i_radio_ctrl_if.spi_clk  = rf_spi_clk;   // SPI clock
  assign i_radio_ctrl_if.spi_mosi = rf_spi_out;   // SPI Master OUT slave IN

  //--------------------------------------------------------------------------
  // radio_ctrl IF
  //--------------------------------------------------------------------------
  assign i_radio_ctrl_if.clk   = `RW_HE_CRM.ref80_root_clk;
  assign i_radio_ctrl_if.rst_n = `RW_HE_CRM.ref80_rst_n;

  //--------------------------------------------------------------------------
  // RF_GPIO (AGC setting)
  //--------------------------------------------------------------------------
  assign i_radio_ctrl_if.gpio            = rf_gpio;
  assign i_radio_ctrl_if.AGCCount        = AGCCount;
  assign i_radio_ctrl_if.extpaon_ch0_5G9 = rf_extpaon_ch0_5G9;
  assign i_radio_ctrl_if.extpaon_ch0_2G4 = rf_extpaon_ch0_2G4;
  assign i_radio_ctrl_if.extpaon_ch1_5G9 = rf_extpaon_ch1_5G9;
  assign i_radio_ctrl_if.extpaon_ch1_2G4 = rf_extpaon_ch1_2G4;
  assign i_radio_ctrl_if.trsw0           = rf_trsw0;
  assign i_radio_ctrl_if.trsw1           = rf_trsw1;
  assign i_radio_ctrl_if.resetn          = rf_resetn;
  assign i_radio_ctrl_if.agcfreeze       = rf_agcfreeze;
  assign i_radio_ctrl_if.tmode           = rf_tmode;

`endif//STANDALONE_MAC

`ifdef STANDALONE_MAC
  // ------------------
  // MAC to PHY signals
  // ------------------

  assign i_mac_phy_if.tx_req            = `RW_HE_PLATF.mpif_txreq;
  assign i_mac_phy_if.rx_req            = `RW_HE_PLATF.mpif_rxreq;
  assign i_mac_phy_if.tx_data           = `RW_HE_PLATF.mpif_txdata;
  assign i_mac_phy_if.tx_data_uid       =  0;
  assign i_mac_phy_if.rx_data_uid       =  0;
  assign i_mac_phy_if.mac_data_valid    = `RW_HE_PLATF.mpif_macdatavalid;

  // ------------------
  // PHY to MAC signals
  // ------------------
  always @ (*) begin
    force `RW_HE_PLATF.mpif_phyrdy           = i_mac_phy_if.phy_rdy;
    force `RW_HE_PLATF.mpif_txend_p          = i_mac_phy_if.tx_end;
    force `RW_HE_PLATF.mpif_rxdata           = i_mac_phy_if.rx_data;
    force `RW_HE_PLATF.mpif_cca_pri20        = i_mac_phy_if.cca_primary_20;
    force `RW_HE_PLATF.mpif_cca_sec20        = i_mac_phy_if.cca_secondary_20;
    force `RW_HE_PLATF.mpif_cca_sec40        = i_mac_phy_if.cca_secondary_40;
    force `RW_HE_PLATF.mpif_rxendfortiming_p = i_mac_phy_if.rx_end_for_timing;
    force `RW_HE_PLATF.mpif_rxerr_p          = i_mac_phy_if.rx_err;
    force `RW_HE_PLATF.mpif_rxend_p          = i_mac_phy_if.rx_end;
    force `RW_HE_PLATF.mpif_phyerr_p         = i_mac_phy_if.phy_err;
    force `RW_HE_PLATF.mpif_rifsrxdetected   = i_mac_phy_if.rifs_rx_detected;
  end

`elsif STANDALONE_PHY

 // ------------------
  // MAC to PHY signals
  // ------------------
  always @ (*) begin
    force `RW_HE_PLATF.mpif_txreq           = i_mac_phy_if.tx_req;
    force `RW_HE_PLATF.mpif_rxreq           = i_mac_phy_if.rx_req;
    force `RW_HE_PLATF.mpif_txdata          = i_mac_phy_if.tx_data;
    force `RW_HE_PLATF.mpif_macdatavalid    = i_mac_phy_if.mac_data_valid;
    force `RW_HE_PLATF.mpif_mimocmdvalid    = i_mac_phy_if.mimo_cmd_valid;
    force `RW_HE_PLATF.mpif_keeprfon        = i_mac_phy_if.keep_rf_on;

  end

  // ------------------
  // PHY to MAC signals
  // ------------------
  assign i_mac_phy_if.phy_rdy           = `RW_HE_PLATF.mpif_phyrdy;

  assign i_mac_phy_if.tx_end            = `RW_HE_PLATF.mpif_txend_p;
  assign i_mac_phy_if.rx_data           = `RW_HE_PLATF.mpif_rxdata;
  assign i_mac_phy_if.cca_primary_20    = `RW_HE_PLATF.mpif_cca_pri20;
  assign i_mac_phy_if.cca_secondary_20  = `RW_HE_PLATF.mpif_cca_sec20;
  assign i_mac_phy_if.cca_secondary_40  = `RW_HE_PLATF.mpif_cca_sec40;
  assign i_mac_phy_if.rx_end_for_timing = `RW_HE_PLATF.mpif_rxendfortiming_p;
  assign i_mac_phy_if.rx_err            = `RW_HE_PLATF.mpif_rxerr_p;
  assign i_mac_phy_if.rx_end            = `RW_HE_PLATF.mpif_rxend_p;
  assign i_mac_phy_if.phy_err           = `RW_HE_PLATF.mpif_phyerr_p;
  assign i_mac_phy_if.rifs_rx_detected  = `RW_HE_PLATF.mpif_rifsrxdetected;


`else // Platform mode, MAC_PHY_IF is monitors-only

  // ------------------
  // MAC to PHY signals
  // ------------------
  assign i_mac_phy_if.tx_req            = `RW_HE_PLATF.mpif_txreq;
  assign i_mac_phy_if.rx_req            = `RW_HE_PLATF.mpif_rxreq;
  assign i_mac_phy_if.tx_data           = `RW_HE_PLATF.mpif_txdata;
  assign i_mac_phy_if.mac_data_valid    = `RW_HE_PLATF.mpif_macdatavalid;

  // ------------------
  // PHY to MAC signals
  // ------------------
  assign i_mac_phy_if.phy_rdy           = `RW_HE_PLATF.mpif_phyrdy;

  assign i_mac_phy_if.tx_end            = `RW_HE_PLATF.mpif_txend_p;
  assign i_mac_phy_if.rx_data           = `RW_HE_PLATF.mpif_rxdata;
  assign i_mac_phy_if.cca_primary_20    = `RW_HE_PLATF.mpif_cca_pri20;
  assign i_mac_phy_if.cca_secondary_20  = `RW_HE_PLATF.mpif_cca_sec20;
  assign i_mac_phy_if.cca_secondary_40  = `RW_HE_PLATF.mpif_cca_sec40;
  assign i_mac_phy_if.rx_end_for_timing = `RW_HE_PLATF.mpif_rxendfortiming_p;
  assign i_mac_phy_if.rx_err            = `RW_HE_PLATF.mpif_rxerr_p;
  assign i_mac_phy_if.rx_end            = `RW_HE_PLATF.mpif_rxend_p;
  assign i_mac_phy_if.phy_err           = `RW_HE_PLATF.mpif_phyerr_p;
  assign i_mac_phy_if.rifs_rx_detected  = `RW_HE_PLATF.mpif_rifsrxdetected;

`endif

  //--------------------------------------------------------------------------
  // BUS MONITOR CONNECTIONS
  //--------------------------------------------------------------------------

  assign i_bus_monitor_if.rst_n  = sys_rst_n;
  assign i_bus_monitor_if.tx_end = `RW_HE_PLATF.mpif_txend_p;
  assign i_bus_monitor_if.rx_end = `RW_HE_PLATF.mpif_rxend_p;
  assign i_bus_monitor_if.frame_violation = `PHY_DUT.mfsm_frame_violation;
  // SIG signals
  assign i_bus_monitor_if.sig_update = `HDM_TXCORE.u_txvecdec.framep3_update;
  assign i_bus_monitor_if.l_sig      = `HDM_TXCORE.u_txvecdec.framep3_lsig;
  assign i_bus_monitor_if.ht_sig     = `HDM_TXCORE.u_txvecdec.framep3_htsig;
  assign i_bus_monitor_if.he_siga    = `HDM_TXCORE.u_txvecdec.framep3_hesiga;
  // These two signals is used to monitor the SynchSkip during Doppler
  assign i_bus_monitor_if.doppler    = `RXTD_TOP.FrameParamDoppler;
  assign i_bus_monitor_if.SynchSkip  = `RXFD_TOP.U_FDOffsetTop.SynchSkip;
  // RxTD status registers
  assign i_bus_monitor_if.status_coarse_fo_angle = `RXTD_TOP.StatusCoarseFOAngle;
  assign i_bus_monitor_if.status_fine_fo_angle   = `RXTD_TOP.StatusFineFOAngle;
//   assign i_bus_monitor_if.totalPower             = `RXTD_TOP.U_TDFOTop.totalPower;
//   assign i_bus_monitor_if.noisePower             = `RXTD_TOP.U_TDFOTop.MaxNoisePower1;
//   assign i_bus_monitor_if.noisePowerMant         = `RXTD_TOP.U_TDFOTop.noisePowerMant;
//   assign i_bus_monitor_if.noisePowerExp          = `RXTD_TOP.U_TDFOTop.noisePowerExp;
//   assign i_bus_monitor_if.RatioNoiseSignal       = `RXTD_TOP.U_TDFOTop.RatioNoiseSignal;
//   assign i_bus_monitor_if.RatioShift             = `RXTD_TOP.U_TDFOTop.RatioShift;
  assign i_bus_monitor_if.StatusFDOData          = `RXFD_TOP.StatusFDOData;
  assign i_bus_monitor_if.StatusFDOPreamb        = `RXFD_TOP.StatusFDOPreamb;
  assign i_bus_monitor_if.StatusdPhi             = `HDM_RXCORE.StatusdPhi;
  assign i_bus_monitor_if.StatusTsNormOut        = `HDM_RXCORE.StatusTsNormOut;
  //--------------------------------------------------------------------------
  // SHARED RAM connection,
  // NOTE: for PHY standalone testbench SRAM agent is not active
  //--------------------------------------------------------------------------
`ifndef STANDALONE_PHY
   always @(*) begin
     // when 32bit write access
     if (i_sram_if.wr_byte == 1'b0) begin
       if (i_sram_if.wr_addr[2] == 1'b0)
         `SHARED_RAM[i_sram_if.wr_addr[31:3]][31:0]  = i_sram_if.wr_data;
       else
         `SHARED_RAM[i_sram_if.wr_addr[31:3]][63:32] = i_sram_if.wr_data;
     end
     // when 8bit write access
     else begin
       case(i_sram_if.wr_addr[2:0])
         3'b000 : `SHARED_RAM[i_sram_if.wr_addr[31:3]][7:0]   = i_sram_if.wr_data[7:0];
         3'b001 : `SHARED_RAM[i_sram_if.wr_addr[31:3]][15:8]  = i_sram_if.wr_data[7:0];
         3'b010 : `SHARED_RAM[i_sram_if.wr_addr[31:3]][23:16] = i_sram_if.wr_data[7:0];
         3'b011 : `SHARED_RAM[i_sram_if.wr_addr[31:3]][31:24] = i_sram_if.wr_data[7:0];
         3'b100 : `SHARED_RAM[i_sram_if.wr_addr[31:3]][39:32] = i_sram_if.wr_data[7:0];
         3'b101 : `SHARED_RAM[i_sram_if.wr_addr[31:3]][47:40] = i_sram_if.wr_data[7:0];
         3'b110 : `SHARED_RAM[i_sram_if.wr_addr[31:3]][55:48] = i_sram_if.wr_data[7:0];
         3'b111 : `SHARED_RAM[i_sram_if.wr_addr[31:3]][63:56] = i_sram_if.wr_data[7:0];
       endcase
     end
   end //always

   always @(*) begin
     // when 32bit read access
     if (i_sram_if.rd_byte == 1'b0) begin
       if (i_sram_if.rd_addr[2] == 1'b0)
         i_sram_if.rd_data = `SHARED_RAM[i_sram_if.rd_addr[31:3]][31:0];
       else
         i_sram_if.rd_data = `SHARED_RAM[i_sram_if.rd_addr[31:3]][63:32];
     end
     // when 8bit read access
     else begin
       case(i_sram_if.rd_addr[2:0])
         3'b000 :  i_sram_if.rd_data[7:0] = `SHARED_RAM[i_sram_if.rd_addr[31:3]][7:0];
         3'b001 :  i_sram_if.rd_data[7:0] = `SHARED_RAM[i_sram_if.rd_addr[31:3]][15:8];
         3'b010 :  i_sram_if.rd_data[7:0] = `SHARED_RAM[i_sram_if.rd_addr[31:3]][23:16];
         3'b011 :  i_sram_if.rd_data[7:0] = `SHARED_RAM[i_sram_if.rd_addr[31:3]][31:24];
         3'b100 :  i_sram_if.rd_data[7:0] = `SHARED_RAM[i_sram_if.rd_addr[31:3]][39:32];
         3'b101 :  i_sram_if.rd_data[7:0] = `SHARED_RAM[i_sram_if.rd_addr[31:3]][47:40];
         3'b110 :  i_sram_if.rd_data[7:0] = `SHARED_RAM[i_sram_if.rd_addr[31:3]][55:48];
         3'b111 :  i_sram_if.rd_data[7:0] = `SHARED_RAM[i_sram_if.rd_addr[31:3]][63:56];
       endcase
     end
   end //always
  //--------------------------------------------------------------------------
`endif //STANDALONE_PHY

  //--------------------------------------------------------------------------
  // H memory connections
  //--------------------------------------------------------------------------
`ifndef STANDALONE_MAC
  assign i_h_mem_if.clk      = `PHYFFT.clk;
  assign i_h_mem_if.rst_n    = `PHYFFT.rst_n;
  assign i_h_mem_if.start    = 0;
  assign i_h_mem_if.done     = 0;
  assign i_h_mem_if.symb_cnt = 0;
  assign i_h_mem_if.ri       = `PHYFFT.h_ri0;
  assign i_h_mem_if.rq       = `PHYFFT.h_rq0;
  assign i_h_mem_if.rvalid   = `PHYFFT.h_rvalid;
  assign i_h_mem_if.ren      = `PHYFFT.h_ren0;
  assign i_h_mem_if.rindex   = {`PHYFFT.h_rindex[8],`PHYFFT.h_rindex[8:0]}; //sign extension
  assign i_h_mem_if.rsel     = 0;
`endif// STANDALONE_MAC

  //--------------------------------------------------------------------------
  // Beamformee connections
  //--------------------------------------------------------------------------
`ifdef RW_BFMEE_EN

  `ifdef STANDALONE_MAC
    always @(*) begin
      i_phy_bf_if.clk           = `RW_HE_PLATF.mpif_clk;
      i_phy_bf_if.start         = `RW_HE_PLATF.bfr_start;
      force `RW_HE_PLATF.bfr_done = i_phy_bf_if.done;
      i_phy_bf_if.chbw          = `RW_HE_PLATF.bfr_ch_bw;
      i_phy_bf_if.feedback_type = `RW_HE_PLATF.bfr_feedback_type;
      i_phy_bf_if.codebook      = `RW_HE_PLATF.bfr_codebook;
      i_phy_bf_if.grouping      = `RW_HE_PLATF.bfr_grouping;
      i_phy_bf_if.nr            = `RW_HE_PLATF.bfr_nr;
      i_phy_bf_if.nc            = `RW_HE_PLATF.bfr_nc;
      i_phy_bf_if.he                = `RW_HE_PLATF.bfr_he;
      i_phy_bf_if.he_runindex_start = `RW_HE_PLATF.bfr_he_rustartidx;
      i_phy_bf_if.he_runindex_end   = `RW_HE_PLATF.bfr_he_ruendidx;
      force `RW_HE_PLATF.bfr_data = i_phy_bf_if.data;
      force `RW_HE_PLATF.bfr_data_valid = i_phy_bf_if.data_valid;
      i_phy_bf_if.data_ready    = `RW_HE_PLATF.bfr_data_ready;
    end //always
  `else
    always @(*) begin
      i_phy_bf_if.clk           = `RW_HE_PLATF.mpif_clk;
      i_phy_bf_if.start         = `RW_HE_PLATF.bfr_start;
      i_phy_bf_if.done          = `RW_HE_PLATF.bfr_done;
      i_phy_bf_if.chbw          = `RW_HE_PLATF.bfr_ch_bw;
      i_phy_bf_if.feedback_type = `RW_HE_PLATF.bfr_feedback_type;
      i_phy_bf_if.codebook      = `RW_HE_PLATF.bfr_codebook;
      i_phy_bf_if.grouping      = `RW_HE_PLATF.bfr_grouping;
      i_phy_bf_if.nr            = `RW_HE_PLATF.bfr_nr;
      i_phy_bf_if.nc            = `RW_HE_PLATF.bfr_nc;
      i_phy_bf_if.he                = `RW_HE_PLATF.bfr_he;
      i_phy_bf_if.he_runindex_start = `RW_HE_PLATF.bfr_he_rustartidx;
      i_phy_bf_if.he_runindex_end   = `RW_HE_PLATF.bfr_he_ruendidx;
      i_phy_bf_if.data          = `RW_HE_PLATF.bfr_data;
      i_phy_bf_if.data_valid    = `RW_HE_PLATF.bfr_data_valid;
      i_phy_bf_if.data_ready    = `RW_HE_PLATF.bfr_data_ready;
    end //always
  `endif//STANDALONE_MAC

  `ifdef STANDALONE_PHY
    // beamformee signals
    assign i_mac_bf_if.bfmee_clk          = `PHY_DUT.mpif_clk;
    assign i_mac_bf_if.bfmee_rst_n        = `PHY_DUT.mpif_rst_n;
    // control
    assign i_mac_bf_if.bfmee_mac_done     = `PHY_DUT.mac_bfr_done;
    always @(*) begin
      // control
      force `PHY_DUT.mac_bfr_start         = i_mac_bf_if.bfmee_mac_start;
      // configuration
      force `PHY_DUT.mac_bfr_ch_bw         = i_mac_bf_if.bfmee_mac_ChBw;
      force `PHY_DUT.mac_bfr_codebook      = i_mac_bf_if.bfmee_mac_Codebook;
      force `PHY_DUT.mac_bfr_feedback_type = i_mac_bf_if.bfmee_mac_FeedbackType;
      force `PHY_DUT.mac_bfr_grouping      = i_mac_bf_if.bfmee_mac_Grouping;
      force `PHY_DUT.mac_bfr_nc            = i_mac_bf_if.bfmee_mac_Nc;
      force `PHY_DUT.mac_bfr_nr            = i_mac_bf_if.bfmee_mac_Nr;
      // data beamforming report
      force `PHY_DUT.mac_bfr_data_request  = i_mac_bf_if.bfmee_mac_DataOutRequest;
      force `PHY_DUT.mac_bfr_he_rustartidx = i_mac_bf_if.bfmee_mac_he_rustartidx;
      force `PHY_DUT.mac_bfr_he_ruendidx   = i_mac_bf_if.bfmee_mac_he_ruendidx;
      force `PHY_DUT.mac_bfr_he            = i_mac_bf_if.bfmee_mac_he;
    end
    // data beamforming report
    assign i_mac_bf_if.bfmee_mac_DataOut      = `PHY_DUT.mac_bfr_data;
    assign i_mac_bf_if.bfmee_mac_DataOutValid = `PHY_DUT.mac_bfr_data_valid;
  `else
    // beamformee signals
    assign i_mac_bf_if.bfmee_clk                = `PHY_DUT.mpif_clk;
    assign i_mac_bf_if.bfmee_rst_n              = `PHY_DUT.mpif_rst_n;
    assign i_mac_bf_if.bfmee_mac_start          = `PHY_DUT.mac_bfr_start;
    assign i_mac_bf_if.bfmee_mac_ChBw           = `PHY_DUT.mac_bfr_ch_bw;
    assign i_mac_bf_if.bfmee_mac_Codebook       = `PHY_DUT.mac_bfr_codebook;
    assign i_mac_bf_if.bfmee_mac_FeedbackType   = `PHY_DUT.mac_bfr_feedback_type;
    assign i_mac_bf_if.bfmee_mac_Grouping       = `PHY_DUT.mac_bfr_grouping;
    assign i_mac_bf_if.bfmee_mac_Nc             = `PHY_DUT.mac_bfr_nc;
    assign i_mac_bf_if.bfmee_mac_Nr             = `PHY_DUT.mac_bfr_nr;
    assign i_mac_bf_if.bfmee_mac_DataOutRequest = `PHY_DUT.mac_bfr_data_request;
    assign i_mac_bf_if.bfmee_mac_done           = `PHY_DUT.mac_bfr_done;
    assign i_mac_bf_if.bfmee_mac_DataOut        = `PHY_DUT.mac_bfr_data;
    assign i_mac_bf_if.bfmee_mac_DataOutValid   = `PHY_DUT.mac_bfr_data_valid;
    assign i_mac_bf_if.bfmee_mac_he_rustartidx  = `PHY_DUT.mac_bfr_he_rustartidx;
    assign i_mac_bf_if.bfmee_mac_he_ruendidx    = `PHY_DUT.mac_bfr_he_ruendidx;
    assign i_mac_bf_if.bfmee_mac_he             = `PHY_DUT.mac_bfr_he;
  `endif // STANDALONE_PHY

`endif // RW_BFMEE_EN

// Shared RAM connection
assign i_sram_bus_if.ena         = `TOP_MEMORIES.sharedram_en;
assign i_sram_bus_if.wea[7:0]    = `TOP_MEMORIES.sharedram_wen[7:0];
assign i_sram_bus_if.addra[14:0] = `TOP_MEMORIES.sharedram_addr[14:0];
assign i_sram_bus_if.dina[63:0]  = `TOP_MEMORIES.sharedram_wdata[63:0] ;
assign i_sram_bus_if.douta[63:0] = `TOP_MEMORIES.sharedram_rdata[63:0];

// PTA Wlan Interface
`ifdef RW_WLAN_COEX_EN
assign i_pta_wlan_if.wlan_tx          = `PTA_DUT.coex_wlan_tx;         // WLAN Transmission On-going
assign i_pta_wlan_if.wlan_rx          = `PTA_DUT.coex_wlan_rx;         // WLAN Reception On-going
assign i_pta_wlan_if.wlan_tx_abort    = `PTA_DUT.coex_wlan_tx_abort;   // WLAN Transmission Abort Request
assign i_pta_wlan_if.wlan_rx_abort    = `PTA_DUT.coex_wlan_rx_abort;   // WLAN Reception Abort Request
assign i_pta_wlan_if.wlan_pti         = `PTA_DUT.coex_wlan_pti;        // WLAN Packet Traffic Information
assign i_pta_wlan_if.wlan_pti_tog     = `PTA_DUT.coex_wlan_pti_tog;    // WLAN Packet Traffic Information Qualifier (Toggle When PTI change)
assign i_pta_wlan_if.wlan_chan_freq   = `PTA_DUT.coex_wlan_chan_freq;  // WLAN Primary Channel Center Frequency (12-84MHZ)
assign i_pta_wlan_if.wlan_chan_bw     = `PTA_DUT.coex_wlan_chan_bw;    // WLAN Channel Bandwidth (0:20MHz, 1:40MHz)
assign i_pta_wlan_if.wlan_chan_offset = `PTA_DUT.coex_wlan_chan_offset;// WLAN Secondary Channel Offset (0:Lower, 1:Upper)
`endif // RW_WLAN_COEX_EN

  //--------------------------------------------------------------------------
  // Rx deinterleave outputs - soft bits
  //--------------------------------------------------------------------------
  reg  [`CARRIERNBWIDTH-1:0]    carrier_num_d[30];
  wire [`CARRIERNBWIDTH-1:0]    carrier_num;
  genvar                        i;

generate
  for (i=0; i<30; i++) begin : DELAY_CARRIER_NUMBER
    always @(posedge `PHY_DUT.phy_clk, negedge `PHY_DUT.phy_rst_n)
    begin
      if (!`PHY_DUT.phy_rst_n)
        carrier_num_d[i] <= 0;
      else
        if (i == 0)
          carrier_num_d[i] <= `RXFD_TOP.CarrierNb;
        else
          carrier_num_d[i] <= carrier_num_d[i-1];
    end
  end//for
endgenerate

  assign carrier_num = carrier_num_d[28];

  //--------------------------------------------------------------
  // RISING_EDGE_BDDONE logic
  //--------------------------------------------------------------
  logic bddone_d, bddone_re, bddone_re_d, bddone_re_dd;

  always @(posedge `RXFD_TOP.PhyClk, negedge `RXFD_TOP.nPhyRst)
  begin : RISING_EDGE_BDDONE
    if (!`RXFD_TOP.nPhyRst) begin
      bddone_d     <= 0;
      bddone_re_d  <= 0;
      bddone_re_dd <= 0;
    end
    else begin
      bddone_d     <= `RXFD_TOP.BDDone;
      bddone_re_d  <= bddone_re;
      bddone_re_dd <= bddone_re_d;
    end
  end

  assign bddone_re = ~bddone_d & `RXFD_TOP.BDDone;
  //--------------------------------------------------------------

  // SS1/2SB0/7 Compressed samples
  assign i_deint_if.clk          = `RXFD_TOP.PhyClk;
  assign i_deint_if.rst_n        = `RXFD_TOP.nPhyRst;
  assign i_deint_if.data_ready   = 1'b1;
  // Collect the samples only when, there are valid indexes
  assign i_deint_if.data_valid   = `RXFD_TOP.SBValid;
  assign i_deint_if.data_last    = (`RXFD_TOP.SBLast & `RXFD_TOP.SBValid) | bddone_re_dd | i_mac_phy_if.rx_end;
  assign i_deint_if.data         = {carrier_num,
                                    50'b0,
                                    `RXFD_TOP.SS1SB9,
                                    `RXFD_TOP.SS1SB8,
                                    `RXFD_TOP.SS1SB7,
                                    `RXFD_TOP.SS1SB6,
                                    `RXFD_TOP.SS1SB5,
                                    `RXFD_TOP.SS1SB4,
                                    `RXFD_TOP.SS1SB3,
                                    `RXFD_TOP.SS1SB2,
                                    `RXFD_TOP.SS1SB1,
                                    `RXFD_TOP.SS1SB0 };

  // SS1SB0...7 + index non-compressed samples
  assign i_equ_if.clk          = `EQU_TOP.PhyClk;
  assign i_equ_if.rst_n        = `EQU_TOP.nPhyRst;
  assign i_equ_if.data_ready   = 1'b1;
  assign i_equ_if.data_valid   = `EQU_TOP.s8_valid;
  assign i_equ_if.data_last    = `EQU_TOP.s8_last | bddone_re_dd | i_mac_phy_if.rx_end;
  assign i_equ_if.data         = {`EQU_TOP.s8_index,
                                  `EQU_TOP.s8_dmap0_sb9,
                                  `EQU_TOP.s8_dmap0_sb8,
                                  `EQU_TOP.s8_dmap0_sb7,
                                  `EQU_TOP.s8_dmap0_sb6,
                                  `EQU_TOP.s8_dmap0_sb5,
                                  `EQU_TOP.s8_dmap0_sb4,
                                  `EQU_TOP.s8_dmap0_sb3,
                                  `EQU_TOP.s8_dmap0_sb2,
                                  `EQU_TOP.s8_dmap0_sb1,
                                  `EQU_TOP.s8_dmap0_sb0 };

  // Collected from data symbols in case of STBC
  // SS1SB0...7 + index non-compressed samples
  assign i_equ1_if.clk          = `EQU_TOP.PhyClk;
  assign i_equ1_if.rst_n        = `EQU_TOP.nPhyRst;
  assign i_equ1_if.data_ready   = 1'b1;
  assign i_equ1_if.data_valid   = `EQU_TOP.s8_valid & `EQU_TOP.StbcEn;
  assign i_equ1_if.data_last    = (`EQU_TOP.s8_last & `EQU_TOP.StbcEn) | ((bddone_re_dd | i_mac_phy_if.rx_end) & `EQU_TOP.StbcEn);
  assign i_equ1_if.data         = {`EQU_TOP.s8_index,
                                  `EQU_TOP.s8_dmap1_sb9,
                                  `EQU_TOP.s8_dmap1_sb8,
                                  `EQU_TOP.s8_dmap1_sb7,
                                  `EQU_TOP.s8_dmap1_sb6,
                                  `EQU_TOP.s8_dmap1_sb5,
                                  `EQU_TOP.s8_dmap1_sb4,
                                  `EQU_TOP.s8_dmap1_sb3,
                                  `EQU_TOP.s8_dmap1_sb2,
                                  `EQU_TOP.s8_dmap1_sb1,
                                  `EQU_TOP.s8_dmap1_sb0 };

  // Viterbi mapping
  assign i_viterbi_in_if.clk        = `RXBD_TOP.vtb_clk;
  assign i_viterbi_in_if.rst_n      = `RXBD_TOP.vtb_rst_n;
  assign i_viterbi_in_if.data_ready = `RXBD_TOP.vtbin_ready;
  assign i_viterbi_in_if.data_valid = `RXBD_TOP.vtbctrl_vtrbinvalid;
  assign i_viterbi_in_if.data_last  = `RXBD_TOP.vtbin_last;
  assign i_viterbi_in_if.data       = {`RXBD_TOP.chmux_sel,
                                       `RXBD_TOP.vtbin_sb3,
                                       `RXBD_TOP.vtbin_sb2,
                                       `RXBD_TOP.vtbin_sb1,
                                       `RXBD_TOP.vtbin_sb0};

  // LDPC output mapping
`ifdef RW_NX_LDPC_DEC
  // LDPC mapping
  assign i_ldpc_if.clk         = `LDPC_TOP.ldpc_clk;
  assign i_ldpc_if.rst_n       = `LDPC_TOP.ldpc_rst_n;
  assign i_ldpc_if.data_ready  = `LDPC_TOP.ldec0_in_ready;
  assign i_ldpc_if.data_valid  = `RXBD_TOP.ldpc_global_enable ? `LDPC_TOP.ldec0_in_valid & `LDPC_TOP.ldec0_in_ready : 0;
  assign i_ldpc_if.data        = {`LDPC_TOP.ldec0_in_len,
                                  `LDPC_TOP.in_sb9,
                                  `LDPC_TOP.in_sb8,
                                  `LDPC_TOP.in_sb7,
                                  `LDPC_TOP.in_sb6,
                                  `LDPC_TOP.in_sb5,
                                  `LDPC_TOP.in_sb4,
                                  `LDPC_TOP.in_sb3,
                                  `LDPC_TOP.in_sb2,
                                  `LDPC_TOP.in_sb1,
                                  `LDPC_TOP.in_sb0 };



  assign i_ldpc_data_if.clk         = `LDPC_TOP.ldpc_clk;
  assign i_ldpc_data_if.rst_n       = `LDPC_TOP.ldpc_rst_n;
  assign i_ldpc_data_if.data_ready  = `LDPC_TOP.out_ready;
  assign i_ldpc_data_if.data_valid  = `LDPC_TOP.out_valid & `LDPC_TOP.out_ready;
  assign i_ldpc_data_if.data        = `LDPC_TOP.out_data;
`endif

//-----------------------------------------------------------------------------
// General Interrupt Event Register
//-----------------------------------------------------------------------------
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_IMPPRITBTT_BIT_POS      ]  = `PATH_TO_MAC_INTERRUPT_CTRL.impPriTBTT;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_IMPSECTBTT_BIT_POS      ]  = `PATH_TO_MAC_INTERRUPT_CTRL.impSecTBTT;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_IDLEINTERRUPT_BIT_POS   ]  = `PATH_TO_MAC_INTERRUPT_CTRL.idleInterrupt;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_ABSGENTIMERS_BIT_POS    ]  = `PATH_TO_MAC_INTERRUPT_CTRL.absGenTimers;
`ifdef RW_WLAN_COEX_EN
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_COEXEVENT_BIT_POS       ]  = `PATH_TO_MAC_INTERRUPT_CTRL.coexEvent;
`else
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_COEXEVENT_BIT_POS       ]  = 1'b0;
`endif
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_MACPHYIFOVERFLOW_BIT_POS]  = `PATH_TO_MAC_INTERRUPT_CTRL.macPHYIFOverflow;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_RXDMAEMPTY_BIT_POS      ]  = 1'b0;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_RXFIFOOVERFLOW_BIT_POS  ]  = `PATH_TO_MAC_INTERRUPT_CTRL.rxFIFOOverFlow;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_OLBCOFDM_BIT_POS        ]  = `PATH_TO_MAC_INTERRUPT_CTRL.olbcOFDM;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_OLBCDSSS_BIT_POS        ] = `PATH_TO_MAC_INTERRUPT_CTRL.olbcDSSS;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_TIMSET_BIT_POS          ] = `PATH_TO_MAC_INTERRUPT_CTRL.timSet;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_PTERROR_BIT_POS         ] = `PATH_TO_MAC_INTERRUPT_CTRL.ptError;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC0TXDMADEAD_BIT_POS    ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac0TxDMADead;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC1TXDMADEAD_BIT_POS    ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac1TxDMADead;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC2TXDMADEAD_BIT_POS    ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac2TxDMADead;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC3TXDMADEAD_BIT_POS    ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac3TxDMADead;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_BCNTXDMADEAD_BIT_POS    ] = `PATH_TO_MAC_INTERRUPT_CTRL.bcnTxDMADead;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_IMPPRIDTIM_BIT_POS      ] = `PATH_TO_MAC_INTERRUPT_CTRL.impPriDTIM;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_IMPSECDTIM_BIT_POS      ] = `PATH_TO_MAC_INTERRUPT_CTRL.impSecDTIM;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_HWERR_BIT_POS           ] = `PATH_TO_MAC_INTERRUPT_CTRL.hwErr;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_MACPHYIFUNDERRUN_BIT_POS] = `PATH_TO_MAC_INTERRUPT_CTRL.macPHYIFUnderRun;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_PHYERR_BIT_POS          ] = `PATH_TO_MAC_INTERRUPT_CTRL.phyErr;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_PHYRXSTART_BIT_POS      ] = `PATH_TO_MAC_INTERRUPT_CTRL.phyRxStart;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_RXHEADERDMADEAD_BIT_POS ] = `PATH_TO_MAC_INTERRUPT_CTRL.rxHeaderDMADead;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_RXPAYLOADDMADEAD_BIT_POS] = `PATH_TO_MAC_INTERRUPT_CTRL.rxPayloadDMADead;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_TBTXDMADEAD_BIT_POS     ] = `PATH_TO_MAC_INTERRUPT_CTRL.tbTxDMADead;

//-----------------------------------------------------------------------------
// Transmit/Receive Interrupt Event Register
//-----------------------------------------------------------------------------
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC0PROTTRIGGER_BIT_POS  ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac0ProtTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC1PROTTRIGGER_BIT_POS  ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac1ProtTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC2PROTTRIGGER_BIT_POS  ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac2ProtTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC3PROTTRIGGER_BIT_POS  ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac3ProtTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_TBPROTTRIGGER_BIT_POS   ] = `PATH_TO_MAC_INTERRUPT_CTRL.tbProtTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_RDPROTTRIGGER_BIT_POS   ] = 1'b0;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC0TXTRIGGER_BIT_POS    ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac0TxTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC1TXTRIGGER_BIT_POS    ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac1TxTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC2TXTRIGGER_BIT_POS    ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac2TxTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC3TXTRIGGER_BIT_POS    ] = `PATH_TO_MAC_INTERRUPT_CTRL.tbTxTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_TBTXTRIGGER_BIT_POS     ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac3TxTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_RDTXTRIGGER_BIT_POS     ] = 1'b0;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_BCNTXTRIGGER_BIT_POS    ] = `PATH_TO_MAC_INTERRUPT_CTRL.bcnTxTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_TXOPCOMPLETE_BIT_POS    ] = `PATH_TO_MAC_INTERRUPT_CTRL.txopComplete;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_TIMERTXTRIGGER_BIT_POS  ] = `PATH_TO_MAC_INTERRUPT_CTRL.timerTxTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_SECUSERTXTRIGGER_BIT_POS] = 1'b0;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_RXBUFFER1TRIGGER_BIT_POS] = `PATH_TO_MAC_INTERRUPT_CTRL.rxBuffer1Trigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_TIMERRXTRIGGER_BIT_POS  ] = `PATH_TO_MAC_INTERRUPT_CTRL.timerRxTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_RXBUFFER2TRIGGER_BIT_POS] = `PATH_TO_MAC_INTERRUPT_CTRL.rxBuffer2Trigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_COUNTERRXTRIGGER_BIT_POS] = 1'b0;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC0BWDROPTRIGGER_BIT_POS] = `PATH_TO_MAC_INTERRUPT_CTRL.ac0BWDropTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC1BWDROPTRIGGER_BIT_POS] = `PATH_TO_MAC_INTERRUPT_CTRL.ac1BWDropTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC2BWDROPTRIGGER_BIT_POS] = `PATH_TO_MAC_INTERRUPT_CTRL.ac2BWDropTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC3BWDROPTRIGGER_BIT_POS] = `PATH_TO_MAC_INTERRUPT_CTRL.ac3BWDropTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC0TXBUFTRIGGER_BIT_POS ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac0TxBufTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC1TXBUFTRIGGER_BIT_POS ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac1TxBufTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC2TXBUFTRIGGER_BIT_POS ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac2TxBufTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_AC3TXBUFTRIGGER_BIT_POS ] = `PATH_TO_MAC_INTERRUPT_CTRL.ac3TxBufTrigger;
assign i_mac_in_irq_raw_if.irq_sig[`MAC_IRQ_BCNTXBUFTRIGGER_BIT_POS ] = `PATH_TO_MAC_INTERRUPT_CTRL.bcnTxBufTrigger;

//-----------------------------------------------------------------------------
// MAC interrupt controller OUTPUTS (connection)
//-----------------------------------------------------------------------------
assign i_mac_out_irq_raw_if.irq_sig[`MAC_IRQ_OUT_INTTXRXTIMER_N_BIT_POS]    = `PATH_TO_MAC_INTERRUPT_CTRL.intTxRxTimer_n;
assign i_mac_out_irq_raw_if.irq_sig[`MAC_IRQ_OUT_INTTXRXMISC_N_BIT_POS]     = `PATH_TO_MAC_INTERRUPT_CTRL.intTxRxMisc_n;
assign i_mac_out_irq_raw_if.irq_sig[`MAC_IRQ_OUT_INTRXTRIGGER_N_BIT_POS]    = `PATH_TO_MAC_INTERRUPT_CTRL.intRxTrigger_n;
assign i_mac_out_irq_raw_if.irq_sig[`MAC_IRQ_OUT_INTTXTRIGGER_N_BIT_POS]    = `PATH_TO_MAC_INTERRUPT_CTRL.intTxTrigger_n;
assign i_mac_out_irq_raw_if.irq_sig[`MAC_IRQ_OUT_INTGEN_N_BIT_POS]          = `PATH_TO_MAC_INTERRUPT_CTRL.intGen_n;
assign i_mac_out_irq_raw_if.irq_sig[`MAC_IRQ_OUT_INTPROTTRIGGER_N_BIT_POS]  = `PATH_TO_MAC_INTERRUPT_CTRL.intProtTrigger_n;

//-----------------------------------------------------------------------------
// Platform interrupt controller connection
//-----------------------------------------------------------------------------
assign i_platf_in_irq_raw_if.irq_sig[`PLATFORM_IN_IRQ_WIDTH-1:0] = `PATH_TO_PLATFORM_INTERRUPT_CTRL.irq_source[63:0]; // 64 interrupt inputs
assign i_platf_out_irq_raw_if.irq_sig[0]                         = `PATH_TO_PLATFORM_INTERRUPT_CTRL.irq_n;            // 1 interrupt output (inverted)

  ////////////////////////////////////////////////////////////////////////
  //?                                                                  ?//
  //?                           DUT                                    ?//
  //?                                                                  ?//
  ////////////////////////////////////////////////////////////////////////

  // Interrupt source decoding for testbench purposes

  /* MAC */
  assign intProtTrigger_n = ~proc_irq[55];
  assign intGen_n         = ~proc_irq[54];
  assign intTxTrigger_n   = ~proc_irq[53];
  assign intRxTrigger_n   = ~proc_irq[52];
  assign intTxRxMisc_n    = ~proc_irq[51];
  assign intTxRxTimer_n   = ~proc_irq[50];

  /* PHY */
  assign Interrupt        = ~proc_irq[70];

`ifdef WLAN_HE_WITH_CPU
  rw_he_top_cpu     u_rw_he_top_cpu     (
`else
  rw_he_top_wrapper u_rw_he_top_wrapper (
`endif//WLAN_HE_WITH_CPU
                                         // system resets
                                         .sys_rst_n              (sys_rst_n),
                                         // rw_nx_platform clock
                                         .plf_root_clk           (plf_root_clk),            //Platform clock
                                         .mac_lp_root_clk        (mac_lp_root_clk),         //Low-Power clock
                                         .ref1_root_clk          (1'b0),                    //Not Used
                                         .ref0_root_clk          (ref_clk),                 //Reference clock for PHY (240 Mhz)
                                         .fe_clk                 (fe_clk),
                                         .fe_rst_n               (fe_rst_n),
                                         .plf_clk                (plf_clk),
                                         .plf_rst_n              (plf_rst_n),
                                         .plf_por_n              (plf_por_n),
                                         // rw_nx_platform clock enables
                                         .platform_wake_up       (platform_wake_up),        //Wake Up platform
`ifdef WLAN_HE_WITH_CPU
                                         // AHB slave interface
                                         .target_hready          (proc_hready),          // Processor hready
                                         .target_hready_in       (proc_hready),          // Processor hready_in
                                         .target_haddr           (proc_haddr),           // Processor haddr
                                         .target_htrans          (proc_htrans),          // Processor htrans
                                         .target_hwrite          (proc_hwrite),          // Processor hwrite
                                         .target_hmastlock       (1'b0),                 // Processor hmastlock
                                         .target_hburst          (3'h0),                 // Processor hburst
                                         .target_hprot           (4'h0),                 // Processor hprot
                                         .target_hsize           (proc_hsize),           // Processor hsize
                                         .target_hrdata          (proc_hrdata),          // Processor hrdata
                                         .target_hwdata          (proc_hwdata),          // Processor hwdata
                                         .target_hresp           (proc_hresp),           // Processor hresp
`else
                                         //  Processor (firmware)  AHB interface
                                         .proc_hready            (proc_hready),             //Processor hready
                                         .proc_hready_in         (proc_hready),             //Processor hready_in
                                         .proc_haddr             (proc_haddr[27:0]),        //Processor haddr
                                         .proc_htrans            (proc_htrans),             //Processor htrans
                                         .proc_hwrite            (proc_hwrite),             //Processor hwrite
                                         .proc_hsize             (proc_hsize[1:0]),         //Processor hsize
                                         .proc_hrdata            (proc_hrdata),             //Processor hrdata
                                         .proc_hwdata            (proc_hwdata),             //Processor hwdata
                                         .proc_hresp             (proc_hresp),              //Processor hresp

                                         // Interrupts line
                                         .proc_irq               (proc_irq),
                                         .cpu_single_irq         (cpu_single_irq),
                                         .tick_timer_irq         (),         // Tick Timer Interrupt to processor (Active High)
                                         .soft_irq               (),         // Software Interrupt to processor (Active High)

`endif//WLAN_HE_WITH_CPU
                                         .host_irq               (host_irq),
                                         // GPIO interface
                                         .gpio_out               (),
                                         .gpio_in                (32'h0),
                                         .gpio_oen               (),
`ifdef RW_WLAN_COEX_EN
                                         // Bluetooth Coexistence Interface
                                         .coex_bt_tx             (i_coex_bt_if.bt_tx      ), // BT Transmission On-going
                                         .coex_bt_rx             (i_coex_bt_if.bt_rx      ), // BT Reception    On-going
                                         .coex_bt_event          (i_coex_bt_if.bt_event   ), // BT Event        On-going
                                         .coex_bt_tx_abort       (i_coex_bt_if.bt_tx_abort), // BT Transmission Abort Request
                                         .coex_bt_rx_abort       (i_coex_bt_if.bt_rx_abort), // BT Reception    Abort Request
                                         .coex_bt_pti            (i_coex_bt_if.bt_pti     ), // BT Packet Traffic Information
                                         .coex_bt_channel        (i_coex_bt_if.bt_channel ), // BT Channel (0-78)
                                         .coex_bt_bw             (i_coex_bt_if.bt_bw      ), // BT Bandwidth (0:1MHz, 1:2MHz)
`endif // RW_WLAN_COEX_EN
                                         //upstream interface
                                         .dma0_awid              (i_axi_slave_if.awid),
                                         .dma0_awaddr            (i_axi_slave_if.awaddr),
                                         .dma0_awlen             (i_axi_slave_if.awlen),
                                         .dma0_awsize            (i_axi_slave_if.awsize),
                                         .dma0_awburst           (i_axi_slave_if.awburst),
                                         .dma0_awuser            (i_axi_slave_if.awuser),
                                         .dma0_awvalid           (i_axi_slave_if.awvalid),
                                         .dma0_awready           (i_axi_slave_if.awready),

                                         .dma0_wid               (i_axi_slave_if.wid),
                                         .dma0_wdata             (i_axi_slave_if.wdata),
                                         .dma0_wstrb             (i_axi_slave_if.wstrb),
                                         .dma0_wlast             (i_axi_slave_if.wlast),
                                         .dma0_wvalid            (i_axi_slave_if.wvalid),
                                         .dma0_wready            (i_axi_slave_if.wready),

                                         .dma0_bid               (i_axi_slave_if.bid),
                                         .dma0_bresp             (i_axi_slave_if.bresp),
                                         .dma0_bvalid            (i_axi_slave_if.bvalid),
                                         .dma0_bready            (i_axi_slave_if.bready),

                                         //downstream interface
                                         .dma1_arid              (i_axi_slave_if.arid),
                                         .dma1_araddr            (i_axi_slave_if.araddr),
                                         .dma1_arlen             (i_axi_slave_if.arlen),
                                         .dma1_arsize            (i_axi_slave_if.arsize),
                                         .dma1_arburst           (i_axi_slave_if.arburst),
                                         .dma1_arvalid           (i_axi_slave_if.arvalid),
                                         .dma1_arready           (i_axi_slave_if.arready),

                                         .dma1_rid               (i_axi_slave_if.rid),
                                         .dma1_rdata             (i_axi_slave_if.rdata),
                                         .dma1_rresp             (i_axi_slave_if.rresp),
                                         .dma1_rlast             (i_axi_slave_if.rlast),
                                         .dma1_rvalid            (i_axi_slave_if.rvalid),
                                         .dma1_rready            (i_axi_slave_if.rready),

                                          // RC Coexistence interface
                                         .rc_tx_abort            (),         // Radio Controller Transmission Abort Request
                                         .rc_rx_abort            (),         // Radio Controller Reception    Abort Request
                                          // Diagnostic Ports
                                         .ext_diagport           (32'h0),    // Diagnostic port
                                         .reg_bootrom_enable     (),         // CPU Boot enable
                                         .rw_nx_ss_diag          (),         // Diagnostic port to be used with IQ for source synchrone capture
                                         .rw_nx_diag0            (),         // Diagnostic port
                                         .rw_nx_diag1            (),         // Diagnostic port
                                         .rw_nx_diag2            (),         // Diagnostic port
                                         .rw_nx_diag3            (),         // Diagnostic port
                                         .rw_nx_diag4            (),         // Diagnostic port
                                         .rw_nx_diag5            (),         // Diagnostic port
                                         .rw_nx_diag6            (),         // Diagnostic port
                                         .mac_internal_error     (),         // MAC internal Error
                                         .mac_debug_ksr          (1'b0),     // Debug Key Storage RAM.
                                         .macbypass_trigger      (),         // MAC Bypass Trigger Port
                                         .reg_diag_trigger       (),         // SW Trigger Port
`ifdef WLAN_HE_WITH_CPU
                                         // JTAG interface
                                         .jtag_rtck (),
                                         .jtag_tdo  (),
                                         .jtag_tdi  (1'b0),
                                         .jtag_tms  (1'b0),
                                         .jtag_tck  (1'b0),
`endif//WLAN_HE_WITH_CPU
                                         // ADC Interface
                                         .adc0_on                (ADCOn0),
                                         .adc0_i                 (ADCDataI0),
                                         .adc0_q                 (ADCDataQ0),
`ifdef RW_NX_DERIV_FE_PATH1
                                         .adc1_i                 (ADCDataI1),
                                         .adc1_q                 (ADCDataQ1),
`endif
                                         // DAC Interface
                                         .dac0_on                (DACOn0),
                                         .dac0_en                (DACDataEn0),
                                         .dac0_i                 (DACDataI0),
                                         .dac0_q                 (DACDataQ0),
`ifdef RW_NX_DERIV_FE_PATH1
                                         .dac1_on                (DACOn1),
                                         .dac1_en                (DACDataEn1),
                                         .dac1_i                 (DACDataI1),
                                         .dac1_q                 (DACDataQ1),
`endif
                                         //SPI interface
                                         .rf_spi_in              (rf_spi_in),
                                         .rf_spi_ss_n            (rf_spi_ss_n),
                                         .rf_spi_clk             (rf_spi_clk),
                                         .rf_spi_out             (rf_spi_out),
                                         //Fast write bus
                                         .rf_gpio                (rf_gpio),
                                         //Reset
                                         .rf_resetn              (rf_resetn),
                                         //RF AGC Disable command
                                         .rf_agcfreeze           (rf_agcfreeze),
                                         //RF Test mode
                                         .rf_tmode               (rf_tmode),
                                         //Tx/Rx switch
                                         .rf_trsw0               (rf_trsw0),
`ifdef RW_NX_DERIV_FE_PATH1
                                         .rf_trsw1               (rf_trsw1),
`endif
                                         //External PA
`ifdef RW_NX_DERIV_FE_PATH1
                                         .rf_extpaon_ch1_5G9     (rf_extpaon_ch1_5G9),
                                         .rf_extpaon_ch1_2G4     (rf_extpaon_ch1_2G4),
`endif
                                         .rf_extpaon_ch0_5G9     (rf_extpaon_ch0_5G9),
                                         .rf_extpaon_ch0_2G4     (rf_extpaon_ch0_2G4)
                                         );



always @ (*)
begin : AGCStateDescription
reg   [50*8:0]         StateDescriptionStr;
  case (`RW_HE_TOP.u_RIUKarstTop.U_RIUCORE.AGCMemAddr)
    9'h0, 9'h1                                                  : StateDescriptionStr = {"ST_Begin_ST"};
    9'h2, 9'h3, 9'h4                                            : StateDescriptionStr = {"ST_Set4Plat_ST"};
    9'h5, 9'h6, 9'h7                                            : StateDescriptionStr = {"ST_Wait4Plat_ST"};
    9'h8, 9'h9, 9'ha                                            : StateDescriptionStr = {"ST_Set4Det_ST"};
    9'hb, 9'hc, 9'hd                                            : StateDescriptionStr = {"ST_DsssDet_ST"};
    9'he, 9'hf, 9'h10                                           : StateDescriptionStr = {"ST_Set4AGCMode_ST"};
    9'h11, 9'h12, 9'h13                                         : StateDescriptionStr = {"ST_Set4DetInitGain_ST"};
    9'h14, 9'h15, 9'h16                                         : StateDescriptionStr = {"ST_FullDigReset_ST"};
    9'h17, 9'h18, 9'h19                                         : StateDescriptionStr = {"ST_Set4DetResetDSP_ST"};
    9'h1a, 9'h1b, 9'h1c                                         : StateDescriptionStr = {"ST_Set4DetStartDC_ST"};
    9'h1d, 9'h1e, 9'h1f                                         : StateDescriptionStr = {"ST_Set4DetStartPow_ST"};
    9'h20, 9'h21, 9'h22                                         : StateDescriptionStr = {"ST_Sleep_ST"};
    9'h23, 9'h24, 9'h25                                         : StateDescriptionStr = {"ST_CaptureNoiseSleep_ST"};
    9'h26, 9'h27, 9'h28, 9'h29, 9'h2a, 9'h2b                    : StateDescriptionStr = {"ST_ValidRadarPostDis_ST"};
    9'h2c, 9'h2d, 9'h2e                                         : StateDescriptionStr = {"ST_ValidRadarPostDis_1_ST"};
    9'h2f, 9'h30, 9'h31                                         : StateDescriptionStr = {"ST_ValidRadarPostDis_2_ST"};
    9'h32, 9'h33, 9'h34                                         : StateDescriptionStr = {"ST_ResetRadarPostDis_ST"};
    9'h35, 9'h36, 9'h37, 9'h38                                  : StateDescriptionStr = {"ST_Set4DetOpt_ST"};
    9'h39, 9'h3a, 9'h3b                                         : StateDescriptionStr = {"ST_Set4DetOpt_1_ST"};
    9'h3c, 9'h3d, 9'h3e                                         : StateDescriptionStr = {"ST_Set4DetOpt_2_ST"};
    9'h3f, 9'h40, 9'h41                                         : StateDescriptionStr = {"ST_OptDigReset_ST"};
    9'h42, 9'h43, 9'h44                                         : StateDescriptionStr = {"ST_SetDetParam_ST"};
    9'h45, 9'h46, 9'h47                                         : StateDescriptionStr = {"ST_SetDetParam1_ST"};
    9'h48, 9'h49, 9'h4a                                         : StateDescriptionStr = {"ST_SetDetParam2_ST"};
    9'h4b, 9'h4c, 9'h4d, 9'h4e, 9'h4f, 9'h50                    : StateDescriptionStr = {"ST_Set4PlatVsSatCount_ST"};
    9'h51, 9'h52, 9'h53                                         : StateDescriptionStr = {"ST_RadTimerOn_ST"};
    9'h54, 9'h55, 9'h56                                         : StateDescriptionStr = {"ST_RadMeas1_ST"};
    9'h57, 9'h58, 9'h59                                         : StateDescriptionStr = {"ST_Set4Plat1rstSat_ST"};
    9'h5a, 9'h5b, 9'h5c                                         : StateDescriptionStr = {"ST_Set4PlatConfPow_ST"};
    9'h5d, 9'h5e, 9'h5f                                         : StateDescriptionStr = {"ST_Set4PlatConfPow2_ST"};
    9'h60, 9'h61, 9'h62                                         : StateDescriptionStr = {"ST_Set4Plat2dSat_ST"};
    9'h63, 9'h64, 9'h65                                         : StateDescriptionStr = {"ST_Set4Plat3dSat_ST"};
    9'h66, 9'h67, 9'h68                                         : StateDescriptionStr = {"ST_PostSatEnPow_ST"};
    9'h69, 9'h6a, 9'h6b                                         : StateDescriptionStr = {"ST_PostSatEnPow2_ST"};
    9'h6c, 9'h6d, 9'h6e                                         : StateDescriptionStr = {"ST_WaitPostSat_ST"};
    9'h6f, 9'h70                                                : StateDescriptionStr = {"ST_PostSatEnCor_ST"};
    9'h71, 9'h72, 9'h73, 9'h74                                  : StateDescriptionStr = {"ST_PlatSearchSel_ST"};
    9'h75, 9'h76                                                : StateDescriptionStr = {"ST_Wait4PlatPostSat1_ST"};
    9'h77, 9'h78                                                : StateDescriptionStr = {"ST_Wait4PlatPostSat2_ST"};
    9'h79, 9'h7a                                                : StateDescriptionStr = {"ST_Wait4PlatPostSat3_ST"};
    9'h7b, 9'h7c, 9'h7d                                         : StateDescriptionStr = {"ST_PostDetConf_ST"};
    9'h7e, 9'h7f                                                : StateDescriptionStr = {"ST_PostDetCorEn_ST"};
    9'h80, 9'h81, 9'h82, 9'h83                                  : StateDescriptionStr = {"ST_Wait4PlatPostDet_ST"};
    9'h84, 9'h85, 9'h86, 9'h87, 9'h88                           : StateDescriptionStr = {"ST_CSFlag1_ST"};
    9'h89, 9'h8a, 9'h8b                                         : StateDescriptionStr = {"ST_CSFlag1OfdmHigh_ST"};
    9'h8c, 9'h8d, 9'h8e                                         : StateDescriptionStr = {"ST_CSFlag1OfdmLow_ST"};
    9'h8f, 9'h90, 9'h91                                         : StateDescriptionStr = {"ST_CSFlag1NoOfdm_ST"};
    9'h92, 9'h93, 9'h94                                         : StateDescriptionStr = {"ST_Set4Demod_ST"};
    9'h95, 9'h96, 9'h97                                         : StateDescriptionStr = {"ST_Set4DemodGain_ST"};
    9'h98, 9'h99, 9'h9a                                         : StateDescriptionStr = {"ST_DemodRIFS_ST"};
    9'h9b, 9'h9c, 9'h9d                                         : StateDescriptionStr = {"ST_DemodFEEn_ST"};
    9'h9e, 9'h9f, 9'ha0                                         : StateDescriptionStr = {"ST_OFDMon_ST"};
    9'ha1, 9'ha2, 9'ha3                                         : StateDescriptionStr = {"ST_DemConfPow_ST"};
    9'ha4, 9'ha5, 9'ha6                                         : StateDescriptionStr = {"ST_DemConfCorr_ST"};
    9'ha7, 9'ha8, 9'ha9                                         : StateDescriptionStr = {"ST_LaunchCorr_ST"};
    9'haa, 9'hab, 9'hac                                         : StateDescriptionStr = {"ST_LaunchDet_ST"};
    9'had, 9'hae, 9'haf                                         : StateDescriptionStr = {"ST_StoreInbd_ST"};
    9'hb0, 9'hb1, 9'hb2                                         : StateDescriptionStr = {"ST_FixedCorr_ST"};
    9'hb3, 9'hb4, 9'hb5, 9'hb6, 9'hb7, 9'hb8                    : StateDescriptionStr = {"ST_CSFlag2_ST"};
    9'hb9, 9'hba, 9'hbb, 9'hbc                                  : StateDescriptionStr = {"ST_CSFlag2OfdmHigh_ST"};
    9'hbd, 9'hbe, 9'hbf, 9'hc0                                  : StateDescriptionStr = {"ST_CSFlag2OfdmLow_ST"};
    9'hc1, 9'hc2, 9'hc3                                         : StateDescriptionStr = {"ST_CSFlag2OfdmNo_ST"};
    9'hc4, 9'hc5, 9'hc6, 9'hc7, 9'hc8                           : StateDescriptionStr = {"ST_OfdmOff_ST"};
    9'hc9, 9'hca, 9'hcb                                         : StateDescriptionStr = {"ST_OfdmOff2_ST"};
    9'hcc, 9'hcd, 9'hce                                         : StateDescriptionStr = {"ST_DSSSDiff_ST"};
    9'hcf, 9'hd0, 9'hd1                                         : StateDescriptionStr = {"ST_FixedDiffDet_ST"};
    9'hd2, 9'hd3, 9'hd4, 9'hd5, 9'hd6, 9'hd7, 9'hd8, 9'hd9      : StateDescriptionStr = {"ST_CSFlag3_ST"};
    9'hda, 9'hdb, 9'hdc                                         : StateDescriptionStr = {"ST_CSFlag3DsssHigh_ST"};
    9'hdd, 9'hde, 9'hdf                                         : StateDescriptionStr = {"ST_CSFlag3OfdmHigh_ST"};
    9'he0, 9'he1, 9'he2                                         : StateDescriptionStr = {"ST_CSFlag3DsssLow_ST"};
    9'he3, 9'he4, 9'he5                                         : StateDescriptionStr = {"ST_CSFlag3OfdmLow_ST"};
    9'he6, 9'he7, 9'he8                                         : StateDescriptionStr = {"ST_CSFlag3Noise_ST"};
    9'he9, 9'hea, 9'heb                                         : StateDescriptionStr = {"ST_MdmOff_ST"};
    9'hec, 9'hed, 9'hee                                         : StateDescriptionStr = {"ST_DsssOn_ST"};
    9'hef, 9'hf0, 9'hf1                                         : StateDescriptionStr = {"ST_DsssSetAnt_ST"};
    9'hf2, 9'hf3, 9'hf4                                         : StateDescriptionStr = {"ST_DsssMdmOn_ST"};
    9'hf5, 9'hf6, 9'hf7, 9'hf8                                  : StateDescriptionStr = {"ST_Wait4SFD_ST"};
    9'hf9, 9'hfa, 9'hfb                                         : StateDescriptionStr = {"ST_DsssOff_ST"};
    9'hfc, 9'hfd, 9'hfe, 9'hff                                  : StateDescriptionStr = {"ST_Wait4DsssSIG_ST"};
    9'h100, 9'h101                                              : StateDescriptionStr = {"ST_Wait4DsssRxEnd_ST"};
    9'h102, 9'h103, 9'h104, 9'h105                              : StateDescriptionStr = {"ST_RadarPulseEval_ST"};
    9'h106, 9'h107, 9'h108, 9'h109                              : StateDescriptionStr = {"ST_RadMeas1Check_ST"};
    9'h10a, 9'h10b                                              : StateDescriptionStr = {"ST_WaitRadMeas2_ST"};
    9'h10c, 9'h10d, 9'h10e                                      : StateDescriptionStr = {"ST_ConfirmRadMeas2_ST"};
    9'h10f, 9'h110, 9'h111                                      : StateDescriptionStr = {"ST_RadMeas2_ST"};
    9'h112, 9'h113, 9'h114, 9'h115                              : StateDescriptionStr = {"ST_RadMeas2Check_ST"};
    9'h116, 9'h117, 9'h118                                      : StateDescriptionStr = {"ST_Wait4PulseEnd_ST"};
    9'h119, 9'h11a                                              : StateDescriptionStr = {"ST_Wait4PulseEnd2_ST"};
    9'h11b, 9'h11c, 9'h11d, 9'h11e, 9'h11f, 9'h120              : StateDescriptionStr = {"ST_ValidRadar_ST"};
    9'h121, 9'h122, 9'h123                                      : StateDescriptionStr = {"ST_ValidRadar_1_ST"};
    9'h124, 9'h125, 9'h126                                      : StateDescriptionStr = {"ST_ValidRadar_2_ST"};
    9'h127, 9'h128, 9'h129                                      : StateDescriptionStr = {"ST_ResetRadar_ST"};
    9'h12a, 9'h12b, 9'h12c                                      : StateDescriptionStr = {"ST_SIGRadarPulseEval_ST"};
    9'h12d, 9'h12e, 9'h12f, 9'h130                              : StateDescriptionStr = {"ST_SIGRadMeas1Check_ST"};
    9'h131, 9'h132, 9'h133                                      : StateDescriptionStr = {"ST_SIGValidRadar_ST"};
    9'h134, 9'h135, 9'h136                                      : StateDescriptionStr = {"ST_SIGValidRadar2_ST"};
    9'h137, 9'h138, 9'h139                                      : StateDescriptionStr = {"ST_SIGResetRadar_ST"};
    9'h13a, 9'h13b                                              : StateDescriptionStr = {"ST_SIGWaitRadMeas2_ST"};
    9'h13c, 9'h13d, 9'h13e                                      : StateDescriptionStr = {"ST_SIGConfirmRadMeas2_ST"};
    9'h13f, 9'h140, 9'h141                                      : StateDescriptionStr = {"ST_SIGRadMeas2_ST"};
    9'h142, 9'h143, 9'h144                                      : StateDescriptionStr = {"ST_SIGRadMeas2Check_ST"};
    9'h145, 9'h146, 9'h147, 9'h148, 9'h149                      : StateDescriptionStr = {"ST_Wait4SIG_ST"};
    9'h14a, 9'h14b, 9'h14c, 9'h14d, 9'h14e                      : StateDescriptionStr = {"ST_Wait4SIG2_ST"};
    9'h14f, 9'h150, 9'h151, 9'h152                              : StateDescriptionStr = {"ST_Wait4HTSTF_ST"};
    9'h153, 9'h154, 9'h155                                      : StateDescriptionStr = {"ST_Wait4LRxEnd_ST"};
    9'h156, 9'h157, 9'h158                                      : StateDescriptionStr = {"ST_ShortLRxEnd_ST"};
    9'h159, 9'h15a, 9'h15b                                      : StateDescriptionStr = {"ST_HTSTFPowReset_ST"};
    9'h15c, 9'h15d, 9'h15e, 9'h15f, 9'h160                      : StateDescriptionStr = {"ST_Wait4GainUpdate_ST"};
    9'h161, 9'h162, 9'h163                                      : StateDescriptionStr = {"ST_Wait4HTSIG_ST"};
    9'h164, 9'h165, 9'h166, 9'h167                              : StateDescriptionStr = {"ST_HTSet4Demod_ST"};
    9'h168, 9'h169, 9'h16a, 9'h16b                              : StateDescriptionStr = {"ST_HTSet4DemodNoMarg_ST"};
    9'h16c, 9'h16d, 9'h16e                                      : StateDescriptionStr = {"ST_HTAGCUnlock_ST"};
    9'h16f, 9'h170, 9'h171                                      : StateDescriptionStr = {"ST_HTDemodFEEn_ST"};
    9'h172, 9'h173, 9'h174                                      : StateDescriptionStr = {"ST_HTOFDMon_ST"};
    9'h175, 9'h176, 9'h177                                      : StateDescriptionStr = {"ST_Wait4RxEnd_ST"};
    9'h178, 9'h179, 9'h17a                                      : StateDescriptionStr = {"ST_Check4RIFS_ST"};
    9'h17b, 9'h17c, 9'h17d                                      : StateDescriptionStr = {"ST_IQEstAccStore_ST"};
    9'h17e, 9'h17f, 9'h180                                      : StateDescriptionStr = {"ST_RIFSIQEstAccStore_ST"};
    9'h181, 9'h182, 9'h183                                      : StateDescriptionStr = {"ST_RIFSStoreRef_ST"};
    9'h184, 9'h185, 9'h186                                      : StateDescriptionStr = {"ST_RIFSResetEst_ST"};
    9'h187, 9'h188                                              : StateDescriptionStr = {"ST_RIFSWait4Conv_ST"};
    9'h189, 9'h18a, 9'h18b                                      : StateDescriptionStr = {"ST_RIFSCheckIdPow_ST"};
    9'h18c, 9'h18d, 9'h18e                                      : StateDescriptionStr = {"ST_RIFSDetected_ST"};
    9'h18f, 9'h190, 9'h191                                      : StateDescriptionStr = {"ST_NoRIFSDet_ST"};
    9'h192, 9'h193, 9'h194                                      : StateDescriptionStr = {"ST_DsssDetSet4Demod_ST"};
    9'h195, 9'h196, 9'h197                                      : StateDescriptionStr = {"ST_DsssDetSet4Demod_1_ST"};
    9'h198, 9'h199, 9'h19a                                      : StateDescriptionStr = {"ST_DsssDetSet4Demod_2_ST"};
    9'h19b, 9'h19c, 9'h19d                                      : StateDescriptionStr = {"ST_DsssDetSet4Demod_3_ST"};
    9'h19e, 9'h19f, 9'h1a0                                      : StateDescriptionStr = {"ST_DsssDetSet4Demod_4_ST"};
    9'h1a1, 9'h1a2                                              : StateDescriptionStr = {"ST_DsssDetSet4Demod_5_ST"};
    9'h1a3, 9'h1a4, 9'h1a5                                      : StateDescriptionStr = {"ST_DsssDetSetAnt_ST"};
    9'h1a6, 9'h1a7, 9'h1a8                                      : StateDescriptionStr = {"ST_DsssDetMdmOn_ST"};
    9'h1a9, 9'h1aa, 9'h1ab, 9'h1ac                              : StateDescriptionStr = {"ST_DsssDetWait4SFD_ST"};
    9'h1ad, 9'h1ae, 9'h1af, 9'h1b0                              : StateDescriptionStr = {"ST_DsssDetWait4DsssSIG_ST"};
    9'h1b1, 9'h1b2                                              : StateDescriptionStr = {"ST_DsssDetWait4DsssRxEnd_ST"};
    default                                                     : StateDescriptionStr = {"UNKNOWN"};
  endcase
end

`ifdef DEBUG_SAMPLES
  /*****************************************************************************
  * Equalizer stage 8 dump (Z,detG)
  *
  *****************************************************************************/
  reg  [ 3:0] mfsm_state_1t;
  reg  [ 3:0] equ_state_1t;
  wire [ 3:0] equ_state ;

  /* EQU 1SS */
  wire [18:0] equ_detg      = `EQU_TOP.s6_d;
  wire [19:0] equ_z0_i      = `EQU_TOP.s6_x0_i;
  wire [19:0] equ_z0_q      = `EQU_TOP.s6_x0_q;
  wire        equ_z_valid   = `EQU_TOP.s6_valid;
  wire [ 7:0] equ_z_index   = `EQU_TOP.s6_index;

  wire        equ_pilotdata = `EQU_TOP.PilotData;
  wire        equ_start     = `EQU_TOP.EqStart;
  wire        equ_done      = `EQU_TOP.EqDone;
  assign      equ_state     = `EQU_TOP.state;

  wire [ 3:0] mfsm_state    = `PHY_DUT.u_mfsm.mfsm_state[3:0];

  integer   v_sym;
  integer   v_frame;

  initial
  begin:b_equ_dump

    integer      v_file_z;
    real         v_i0,v_q0;
    real         v_i1,v_q1;

    v_file_z = $fopen("dump_z.txt","wb");

    if(!v_file_z)
    begin
      $display("error: can't create dump_z.txt !");
      $display("Simulation FAILURE");
      $stop();
    end

    v_frame = 'd0;
    v_sym   = 'd0;

    while(1)
    begin
      @(posedge `EQU_TOP.PhyClk);
      mfsm_state_1t <= mfsm_state;
      equ_state_1t  <= equ_state;

      if(mfsm_state==4'd6)
      begin
        if(mfsm_state_1t!=4'd6)
        begin
          /* entering RX_DEMOD */
          v_frame <= v_frame + 'd1;
          v_sym   <= 'd0;
        end
      end

      if(equ_state!=2'd3 && equ_state_1t==4'd3)
      begin
        /* leaving EQU_DATA */
        v_sym <= v_sym + 'd1;
      end

      /*******************************************************************************************
      * DUMP Z
      *******************************************************************************************/
      if(equ_z_valid && equ_state==4'd3)
      begin
        v_i0 = 'd0;
        v_q0 = 'd0;

        if(equ_detg!='d0)
        begin
          v_i0 = $signed(equ_z0_i) / $itor(equ_detg);
          v_q0 = $signed(equ_z0_q) / $itor(equ_detg);
        end

        $fwrite(v_file_z,"%d %d %d   %10.2f %10.2f    %10d    %10d %10d\n",
          v_frame,v_sym,$signed(equ_z_index),
          v_i0,v_q0,
          equ_detg,
          $signed(equ_z0_i),$signed(equ_z0_q));
      end
    end
  end


  /*****************************************************************************
  * RX FE dump
  *****************************************************************************/
  initial
  begin:b_rxfe_dump
    integer      v_file_fe;
    v_file_fe = $fopen("dump_fe.txt","wb");
    if(!v_file_fe)
    begin
      $display("error: can't create dump_fe.txt !");
      $display("Simulation FAILURE");
      $stop();
    end
    while(1)
    begin
      @(posedge `PHY_DUT.tdcomp_clk);

      /*******************************************************************************************
      * DUMP RX FE 20MHz
      *******************************************************************************************/
      if(`PHY_DUT.feif_rx_valid_20 || `PHY_DUT.feif_rx_valid_40)
      begin

        $fwrite(v_file_fe,"%d %d    %d %d    %10d %10d\n",
          $signed(`PHY_DUT.feif_rx_20p_i0),
          $signed(`PHY_DUT.feif_rx_20p_q0),
          $signed(`PHY_DUT.feif_rx_40p_i0),
          $signed(`PHY_DUT.feif_rx_40p_q0),
          $signed(`PHY_DUT.agc_p1_snr),
          $signed(`PHY_DUT.agc_p1_noise_var_db));
      end
    end
  end

  /*****************************************************************************
  * RX ADC dump
  *****************************************************************************/
  initial
  begin:b_adc_dump
    integer      v_file_adc;
    v_file_adc = $fopen("dump_adc.txt","wb");
    if(!v_file_adc)
    begin
      $display("error: can't create dump_adc.txt !");
      $display("Simulation FAILURE");
      $stop();
    end
    while(1)
    begin
      @(posedge fe_clk);
      /*******************************************************************************************
      * DUMP ADC
      *******************************************************************************************/
      if(ADCOn0)
      begin
        $fwrite(v_file_adc,"%d %d \n", $signed(ADCDataI0), $signed(ADCDataQ0));
      end
    end
  end

`endif

endmodule : wlan_top_tb

`endif //WLAN_TOP_TB_SV

