//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef TEST_MAC_PTA_SV
`define TEST_MAC_PTA_SV

//-----------------------------------

class test_mac_pta extends mac_test_base;
  `uvm_component_utils(test_mac_pta)

  function new (string name = "test_mac_pta", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void configure_env();
    super.configure_env();

    //m_cfg.has_mac_tx_scoreboard = 1;
    m_cfg.has_pta_scoreboard = 1;
    m_cfg.has_pta_wlan_agent = 1;
    m_cfg.m_pta_wlan_cfg.is_active = UVM_PASSIVE;
  endfunction : configure_env

  task run_phase(uvm_phase phase);

    `ifndef RW_WLAN_COEX_EN
      `uvm_warning(get_type_name(), "Skipped because RW_WLAN_COEX_EN is not defined")
    `else // RW_WLAN_COEX_EN 
    
      mac_core_pta_bt_seq seq;

      phase.raise_objection(this, "test_mac_pta");
      `uvm_info(get_type_name(), "TEST MAC CORE TRANSMITING DATA FRAME", UVM_LOW)

      seq = mac_core_pta_bt_seq::type_id::create("seq");
      seq.start(m_env.m_vsqr);

      phase.drop_objection(this, "test_mac_pta");
    `endif // RW_WLAN_COEX_EN 

  endtask : run_phase

endclass : test_mac_pta

`endif //TEST_MAC_PTA_SV


