//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef TEST_MAC_RX_MU_RTS_TRIGGER_CHAN_BUSY_FRAME_SV
`define TEST_MAC_RX_MU_RTS_TRIGGER_CHAN_BUSY_FRAME_SV

//-----------------------------------

class test_mac_rx_mu_rts_trigger_chan_busy extends mac_test_base;
  `uvm_component_utils(test_mac_rx_mu_rts_trigger_chan_busy)

  function new (string name = "test_mac_rx_mu_rts_trigger_chan_busy", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void configure_env();
    super.configure_env();

    m_cfg.has_mac_rx_scoreboard       = 1;
    m_cfg.has_mac_tx_scoreboard       = 1;
    m_cfg.has_mac_imm_resp_scoreboard = 1;
    m_cfg.m_mac_phy_cfg.m_phy_cfg.set_cca_to_busy = 1;
  endfunction : configure_env

  task run_phase(uvm_phase phase);

    mac_core_rx_trigger_frame_busy_channel_seq seq;

    phase.raise_objection(this, "test_mac_rx_mu_rts_trigger_chan_busy");
    `uvm_info(get_type_name(), "TEST MAC CORE RECEIVING BASIC TRIGGER FRAME WITH BUSY CCA", UVM_LOW)

    seq = mac_core_rx_trigger_frame_busy_channel_seq::type_id::create("seq");
    seq.custom_test = 1;
    seq.custom_trigger_type = MU_RTS;
    seq.start(m_env.m_vsqr);

    phase.drop_objection(this, "test_mac_rx_mu_rts_trigger_chan_busy");

  endtask : run_phase

endclass : test_mac_rx_mu_rts_trigger_chan_busy

`endif //TEST_MAC_RX_MU_RTS_TRIGGER_CHAN_BUSY_FRAME_SV



