//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef TEST_MAC_RX_NDP_SU_CALIB_VHT_SV
`define TEST_MAC_RX_NDP_SU_CALIB_VHT_SV

//-----------------------------------

class test_mac_rx_ndp_su_calib_vht extends mac_test_base;
  `uvm_component_utils(test_mac_rx_ndp_su_calib_vht)

  mac_core_rx_ndp_su_calib_seq seq;

  function new (string name = "test_mac_rx_ndp_su_calib_vht", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void configure_env();
    super.configure_env();

    m_cfg.has_mac_rx_scoreboard       = 1;
    m_cfg.has_mac_imm_resp_scoreboard = 1;
    m_cfg.has_bf_uvc                  = 1;
    m_cfg.m_bf_cfg.has_mac_bf_agent   = 0;
    m_cfg.m_bf_cfg.has_h_mem_agent    = 0;
    m_cfg.m_bf_cfg.has_phy_bf_agent   = 1;
  endfunction : configure_env

  task run_phase(uvm_phase phase);
`ifndef RW_BFMEE_EN
    `uvm_fatal(get_type_name(),"RW_BFMEE_EN not defined, this test case can't be run")
`endif

    phase.raise_objection(this, "test_mac_rx_ndp_su_calib_vht");
    `uvm_info(get_type_name(), "TEST MAC CORE RECEIVING NDP FRAME, SU CALIBRATION", UVM_LOW)

    seq = mac_core_rx_ndp_su_calib_seq::type_id::create("seq");
    seq.start(m_env.m_vsqr);

    phase.drop_objection(this, "test_mac_rx_ndp_su_calib_vht");

  endtask : run_phase

endclass : test_mac_rx_ndp_su_calib_vht

`endif //TEST_MAC_RX_NDP_SU_CALIB_SV

