//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef TEST_MAC_TX_NDP_SV
`define TEST_MAC_TX_NDP_SV

//-----------------------------------

class test_mac_tx_ndp extends mac_test_base;
  `uvm_component_utils(test_mac_tx_ndp)

  mac_core_tx_ndp_seq seq;

  function new (string name = "test_mac_tx_ndp", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void configure_env();
    super.configure_env();

    m_cfg.has_mac_tx_scoreboard = 1;
  endfunction : configure_env

  task run_phase(uvm_phase phase);
`ifndef RW_BFMER_EN
    `uvm_fatal(get_type_name(),
    $sformatf("Wrong configuration - RTL has no support for BFMER Tx. Please choose a configuration which defines RW_BFMER_EN!"))
`endif

    phase.raise_objection(this, "test_mac_tx_ndp");
    `uvm_info(get_type_name(), "TEST MAC CORE TRANSMITING NDPA + NDP FRAME", UVM_LOW)

    seq = mac_core_tx_ndp_seq::type_id::create("seq");
    seq.start(m_env.m_vsqr);

    phase.drop_objection(this, "test_mac_tx_ndp");

  endtask : run_phase

endclass : test_mac_tx_ndp

`endif //TEST_MAC_TX_NDP_SV


