//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef TEST_WLAN_BF_MU_RX_VHT_SV
`define TEST_WLAN_BF_MU_RX_VHT_SV

//-----------------------------------

class test_wlan_bf_mu_rx_vht extends wlan_test_base;
  `uvm_component_utils(test_wlan_bf_mu_rx_vht)

  wlan_bf_mu_rx_seq seq;

  function new (string name = "test_wlan_bf_mu_rx_vht", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase

  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  function void configure_env();
    super.configure_env();
    m_cfg.has_modem_stream_scoreboard     = 1;
    m_cfg.has_modem_rx_scoreboard         = 1;
    m_cfg.has_modem_tx_scoreboard         = 1;
    m_cfg.has_bf_uvc                      = 1;
    m_cfg.m_bf_cfg.m_phy_bf_cfg.is_active = UVM_PASSIVE;
    m_cfg.m_bf_cfg.has_mac_bf_agent       = 0;
    m_cfg.m_bf_cfg.has_h_mem_agent        = 0;
    m_cfg.m_bf_cfg.has_phy_bf_agent       = 1;
    m_cfg.has_modem_bf_scoreboard         = 0;
    m_cfg.has_mac_tx_scoreboard           = 0;
    m_cfg.has_mac_rx_scoreboard           = 1;
    m_cfg.has_mac_imm_resp_scoreboard     = 1;
    m_cfg.bf_calib_test                   = 1;
  endfunction : configure_env

  task run_phase(uvm_phase phase);
    `ifndef RW_BFMEE_EN
      `uvm_fatal(get_type_name(), $sformatf("Wrong configuration - RTL has no support for beamformer mode. Please choose a configuration which defines RW_BFMEE_EN!"))
    `endif
   `uvm_info(get_type_name(), "TEST WLAN MU RX BF FRAMES", UVM_LOW)
    phase.raise_objection(this, "test_wlan_bf_mu_rx_vht starts");

    // Disable AGC
    m_cfg.m_radio_cfg.m_rui_cfg.agcBypass = 0;

    seq = wlan_bf_mu_rx_seq::type_id::create("seq");
    seq.start(m_env.m_vsqr);
    phase.drop_objection(this, "test_wlan_bf_mu_rx_vht ends");
  endtask : run_phase

endclass : test_wlan_bf_mu_rx_vht

`endif //TEST_WLAN_BF_MU_RX_VHT_SV



