//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef TEST_WLAN_RX_AMPDU_FRAME_WC_SV
`define TEST_WLAN_RX_AMPDU_FRAME_WC_SV

//-----------------------------------

class test_wlan_rx_ampdu_frame_wc extends wlan_test_base;
  `uvm_component_utils(test_wlan_rx_ampdu_frame_wc)

  wlan_rx_ampdu_frame_seq seq;

  function new (string name = "test_wlan_rx_ampdu_frame_wc", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase

  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  function void configure_env();
    super.configure_env();

    m_cfg.has_modem_stream_scoreboard = 1;
    m_cfg.has_modem_rx_scoreboard     = 1;
    m_cfg.has_modem_tx_scoreboard     = 1;
    m_cfg.has_modem_bf_scoreboard     = 0;
    m_cfg.has_mac_rx_scoreboard       = 1;
    m_cfg.has_mac_imm_resp_scoreboard = 1;

    m_cfg.has_deint_agent             = 1;
    m_cfg.has_equ_agent               = 1;
    m_cfg.has_ldpc_agent              = 1;
    m_cfg.has_ldpc_data_agent         = 1;

    m_cfg.m_fft_out_cfg.is_active     = UVM_PASSIVE;
    m_cfg.m_fft_in_cfg.is_active      = UVM_PASSIVE;
    
  endfunction : configure_env

  task run_phase(uvm_phase phase);
   `uvm_info(get_type_name(), "TEST MAC CORE RECEIVING AMPDU FRAME", UVM_LOW)
    phase.raise_objection(this, "test_wlan_rx_ampdu_frame_wc starts");
    seq = wlan_rx_ampdu_frame_seq::type_id::create("seq");
    seq.force_high_data_rate = 1;
    seq.start(m_env.m_vsqr);
    phase.drop_objection(this, "test_wlan_rx_ampdu_frame_wc ends");
  endtask : run_phase

endclass : test_wlan_rx_ampdu_frame_wc

`endif //TEST_WLAN_RX_AMPDU_FRAME_WC_SV
