//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef TEST_WLAN_RX_POWER_SV
`define TEST_WLAN_RX_POWER_SV

//-----------------------------------

class test_wlan_rx_power extends wlan_test_base;
  `uvm_component_utils(test_wlan_rx_power)

  PPDU_frame        frame;

  wlan_custom_rx_seq seq;

  function new (string name = "test_wlan_rx_power", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase

  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  function void configure_env();
    super.configure_env();

    m_cfg.has_modem_stream_scoreboard = 1;
    m_cfg.has_modem_rx_scoreboard     = 1;
    m_cfg.has_modem_tx_scoreboard     = 1;
    m_cfg.has_modem_bf_scoreboard     = 0;
    m_cfg.has_mac_tx_scoreboard       = 1;
    m_cfg.has_mac_rx_scoreboard       = 0;
    m_cfg.has_mac_imm_resp_scoreboard = 0;
  endfunction : configure_env

  task run_phase(uvm_phase phase);
   `uvm_info(get_type_name(), "TEST MAC CORE TRANSMITING CUSTOM FRAME", UVM_LOW)
    phase.raise_objection(this, "test_wlan_rx_power starts");
    seq = wlan_custom_rx_seq::type_id::create("seq");
    frame = PPDU_frame::type_id::create("frame");
    assert (frame.randomize() with {
    //-------------------------------
    // TO GENERATE SINGLETON FRAME
    //-------------------------------
      kind == SINGLETON;
      //ppdu_format == NON_HT;  // options: [NON_HT, NON_HT_DUP_OFDM, HT_MF, HT_GF, VHT]
    //-------------------------------
    // TO GENERATE AGGREGATED FRAME
    //-------------------------------
      //kind == AGGREGATED;
      ppdu_format == HE_SU;   // options: [HT_MF, HT_GF, VHT]
    //-------------------------------
    // TO GENERATE NDP FRAME
    //-------------------------------
      //kind == NDP;
    //-------------------------------
    // TO GENERATE MU_MIMO FRAME
    //-------------------------------
      //kind == MU_MIMO;
      //num_of_users == 2;      // options: [2:4], default is 2 users
    //-------------------------------
      tx_frame == 0; // should be set to 0, valid only for MAC Core validation
    });

    //------------------------------------------------------
    // SETUP CUSTOM PARAMETERS FROM PREAMBLE HEADER
    // (uncomment and add value that needs to be overwritten)
    //------------------------------------------------------
     frame.preamble_header.ch_bw                = `RW_TEST_BW;
    // frame.preamble_header.preamble_type        = <value>;
    // frame.preamble_header.antenna_set          = <value>;
    // frame.preamble_header.rssi_legacy          = <value>;
    // frame.preamble_header.rssi                 = <value>;
    // frame.preamble_header.tx_pwr_level         = <value>;
    // frame.preamble_header.num_tx               = <value>;
    // frame.preamble_header.time_dep_req         = <value>;
    // frame.preamble_header.continuous_tx       = <value>;
    // frame.preamble_header.chbw_in_non_ht       = <value>;
    // frame.preamble_header.l_sig_valid          = <value>;
    // frame.preamble_header.leg_length           = <value>;
    // frame.preamble_header.leg_rate             = <value>;
    // frame.preamble_header.service              = <value>;
    // frame.preamble_header.trigger_responding   = <value>;
    // frame.preamble_header.sounding             = <value>;
    // frame.preamble_header.smoothing            = <value>;
     frame.preamble_header.gi_type              = `RW_TEST_SGI;
    // frame.preamble_header.aggregation          = <value>;
    // frame.preamble_header.stbc                 = <value>;
    // frame.preamble_header.num_extn_ss          = <value>;
    // frame.preamble_header.beamformed           = <value>;
    // frame.preamble_header.doze_not_allowed     = <value>;
    // frame.preamble_header.first_user           = <value>;
    // frame.preamble_header.pe_duration          = <value>;
    // frame.preamble_header.partial_aid          = <value>;
    // frame.preamble_header.group_id             = <value>;
    // frame.preamble_header.uplink_flag          = <value>;
    // frame.preamble_header.beam_change          = <value>;
    // frame.preamble_header.dcm                  = <value>;
    // frame.preamble_header.bss_color            = <value>;
    // frame.preamble_header.txop_duration        = <value>;
    // frame.preamble_header.spatial_reuse        = <value>;
    // frame.preamble_header.sig_b_comp_mode      = <value>;
    // frame.preamble_header.dcm_sig_b            = <value>;
    // frame.preamble_header.mcs_sig_b            = <value>;
    // frame.preamble_header.ru_allocation        = <value>;
    // frame.preamble_header.n_user               = <value>;
    // frame.preamble_header.spatial_reuse[0]     = <value>;
    // frame.preamble_header.spatial_reuse[1]     = <value>;
    // frame.preamble_header.spatial_reuse[2]     = <value>;
    // frame.preamble_header.spatial_reuse[3]     = <value>;
    // frame.preamble_header.he_siga_reserved     = <value>;
    // frame.preamble_header.num_he_ltf           = <value>;
    // frame.preamble_header.he_ltf_mode          = <value>;
    // frame.preamble_header.ldpc_extra_symbol    = <value>;
    // frame.preamble_header.starting_sts_num     = <value>;
    // frame.preamble_header.trigger_method       = <value>;
    // frame.preamble_header.ru_tone_set_index    = <value>;

    // configure user header specific parameters, in case of MU-MIMO there
    // USER HEADER for non-HE frames
    // will be up to num_of_users elements (N - user index)
    // frame.preamble_header.user_header[N].mcs_f           = <value>;
    // frame.preamble_header.user_header[N].ht_length_f     = <value>;
    // frame.preamble_header.user_header[N].fec_coding_f    = <value>;
    // frame.preamble_header.user_header[N].num_sts_f       = <value>;
    // frame.preamble_header.user_header[N].smm_index_f     = <value>;
    // frame.preamble_header.user_header[N].user_position_f = <value>;

    // USER HEADER for HE frames
     frame.preamble_header.user_header_he[0].fec_coding_f     = `RW_TEST_LDPC;
     frame.preamble_header.user_header_he[0].mcs_f            = `RW_TEST_MCS;
//     frame.preamble_header.user_header_he[0].he_length_f      = 20'd1000;
    // frame.preamble_header.user_header_he[N].user_position_f  = <value>;
    // frame.preamble_header.user_header_he[N].nss_f            = <value>;
    // frame.preamble_header.user_header_he[N].smm_index_f      = <value>;
    // frame.preamble_header.user_header_he[N].pkt_ext_f        = <value>;
    // frame.preamble_header.user_header_he[N].staid_f          = <value>;
    seq.data_frame = frame;
    seq.start(m_env.m_vsqr);
    phase.drop_objection(this, "test_wlan_rx_power ends");
  endtask : run_phase

endclass : test_wlan_rx_power

`endif //TEST_WLAN_RX_POWER_SV

