//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef WLAN_REPORT_CATCHER_SV
`define WLAN_REPORT_CATCHER_SV

class wlan_report_catcher extends uvm_report_catcher;
  `uvm_object_utils(wlan_report_catcher)

  int unsigned max_error_cnt;
  static int unsigned count;
  // handle to register model, in case of dump
  REGMODEL_pkg::TOP_register_block m_regmodel;

  function new (string name = "wlan_report_catcher");
    super.new(name);
    max_error_cnt = 0;
    count = 0;
  endfunction : new

  function action_e catch();

    if (get_severity() == UVM_ERROR) count++;
    if (get_severity() == UVM_ERROR && max_error_cnt == count) begin
`ifndef STANDALONE_MAC
      // dump registers
      save_register_model_value();
      // cleanup Matlab shared object session
      close_matlab_session_v();
`endif
    end

    return THROW;
  endfunction : catch

  //---------------------------------------------------------------------------
  // dump register model content to file
  // file organization is: <register name>  <value>
  //---------------------------------------------------------------------------
  function void save_register_model_value();
    int            fhandle;
    string         fname;
    string         reg_block_names[] = '{"PHYCONFIG","RCKARST","RIUKARST"};
    uvm_reg        regs[$];
    uvm_reg_data_t rdata;
    uvm_reg_block  block;

    fname = `REGMODEL_DUMP_FILE;
    fhandle = $fopen(fname, "w");
    if (!fhandle)
      `uvm_fatal(get_type_name(), $sformatf("Unable to open file %s for writing",fname))
    else
      `uvm_info(get_type_name(), $sformatf("Dumping register content to file %s",fname), UVM_LOW)

    foreach (reg_block_names[i]) begin
      block = m_regmodel.get_block_by_name(reg_block_names[i]);
      if (block == null) `uvm_fatal(get_type_name(), $sformatf("Reg block not found %s",reg_block_names[i]))
      regs.delete();
      block.get_registers(regs);
      // dump RW register content
      foreach (regs[i]) begin
        if (regs[i].get_rights() == "RW") begin
         rdata = regs[i].get_mirrored_value();
         $fwrite(fhandle, $sformatf("%s %0h\n", regs[i].get_name(), rdata));
        end//if
      end//foreach register
    end//foreach reg block

    $fclose(fhandle);
  endfunction : save_register_model_value

endclass : wlan_report_catcher

`endif//WLAN_REPORT_CATCHER_SV
