//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef WLAN_TEST_BASE_SV
`define WLAN_TEST_BASE_SV

//-----------------------------------

class wlan_test_base extends uvm_test;
  `uvm_component_utils(wlan_test_base)

  wlan_config            m_cfg; // main configuration object
  wlan_env               m_env; // main system environment

  // callbacks for report error handling
  wlan_report_catcher    handle_err_scb_cb;
  wlan_report_catcher    handle_err_mon_cb;
  wlan_report_catcher    handle_err_drv_cb;


  function new (string name = "wlan_test_base", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    // create WLAN configuration components
    m_cfg = wlan_config::type_id::create("m_cfg");
    //-------------------------------------------
    // Configure environment
    //-------------------------------------------
    configure_env();

    // push down configuration
    uvm_config_db #(wlan_config)::set(null, "*", "wlan_config", m_cfg);
    // override type of modem data model with version 2 if AX standard is
    // supported, new API is used and libdump.so
    mdm_data_model_pkg::mdm_data_model::type_id::set_type_override(mdm_data_model_pkg::mdm_data_model_ver2::get_type());

    // create WLAN environment
    m_env = wlan_env::type_id::create("m_env", this);

    //-------------------------------------------
    // simulation environment setup
    //-------------------------------------------
    set_verbosity();
    // prevent above LOW messages verbosity from register model
    uvm_top.set_report_id_verbosity("RegModel", UVM_LOW);
  endfunction : build_phase

  // function for custom configuration of environment,
  // it can be overwritten in child classe
  virtual function void configure_env();
    // configure MAC-PHY interface to be fully passive
    m_cfg.m_mac_phy_cfg.is_active = UVM_PASSIVE;
    m_cfg.m_mac_phy_cfg.has_mac_agent = 0;
    m_cfg.m_mac_phy_cfg.has_phy_agent = 0;
    // configure BF UVC to be passive
    m_cfg.has_bf_uvc                    = 0;
    m_cfg.has_modem_bf_scoreboard       = 0;
    m_cfg.m_bf_cfg.is_active            = UVM_PASSIVE;
    // configure HDMCORE agent
    m_cfg.has_hdmcore_agent             = 1;
    m_cfg.m_hdmcore_cfg.is_active       = UVM_PASSIVE;
    m_cfg.m_hdmcore_cfg.is_stream_agent = 1;

    // Change default configuration
    m_cfg.m_platform_in_irq_raw_cfg.irq_raw_polarity  = 1'b1; // Active high interrupts
    m_cfg.m_platform_out_irq_raw_cfg.irq_raw_polarity = 1'b0; // Active low interrupts

  endfunction : configure_env

  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);

    set_report_catcher();
  endfunction : connect_phase

  virtual function void end_of_elaboration();

    // set WDT to prevent simulation to hung
    uvm_top.set_timeout(`WDT_VALUE);

`ifndef STANDALONE_MAC
    initialize_matlab_session_v();
    `uvm_info(get_type_name(), $sformatf("Executing Matlab libdump revision %0d",getRevision_v()), UVM_LOW)

`endif//STANDALONE_MAC
  endfunction : end_of_elaboration

  virtual function void final_phase(uvm_phase phase);
`ifndef STANDALONE_MAC
    // cleanup Matlab shared object session
    close_matlab_session_v();
`endif
  endfunction : final_phase

  // function used to setup verbosity level inside testbench, it
  // parses command line entry UVM_VERBOSITY and setups verbosity
  // level for environment components
  function void set_verbosity();
    uvm_verbosity verbosity = UVM_LOW;
    string        args;

    if ($value$plusargs("UVM_VERBOSITY=%s", args)) begin
      case (args)
        "UVM_LOW"    : verbosity = UVM_LOW;
        "UVM_MEDIUM" : verbosity = UVM_MEDIUM;
        "UVM_HIGH"   : verbosity = UVM_HIGH;
        "UVM_FULL"   : verbosity = UVM_FULL;
        "UVM_DEBUG"  : verbosity = UVM_DEBUG;
        "UVM_NONE"   : verbosity = UVM_NONE;
        default      : verbosity = UVM_LOW;
      endcase
    end //if

    `uvm_info(get_type_name(), $sformatf("VERBOSITY LEVEL SET TO %s", args), UVM_NONE)
    uvm_top.set_report_verbosity_level_hier(verbosity);
  endfunction : set_verbosity

  // function that will set callback for report message handling
  function void set_report_catcher();
    string args;
    int    max_count;

    if ($value$plusargs("UVM_MAX_QUIT_COUNT=%s", args)) begin
      max_count = args.atoi();
      `uvm_info(get_type_name(),$sformatf("MAX QUIT COUNT SET TO %0d",max_count),UVM_LOW)

      // when max quit count is not set to infinit number
      if (max_count) begin
        // create callback
        handle_err_scb_cb = wlan_report_catcher::type_id::create("handle_err_scb_cb");
        handle_err_mon_cb = wlan_report_catcher::type_id::create("handle_err_mon_cb");
        handle_err_drv_cb = wlan_report_catcher::type_id::create("handle_err_drv_cb");
        // push down parameter
        handle_err_scb_cb.max_error_cnt = max_count;
        handle_err_mon_cb.max_error_cnt = max_count;
        handle_err_drv_cb.max_error_cnt = max_count;
        handle_err_scb_cb.m_regmodel = m_env.m_regmodel;
        handle_err_mon_cb.m_regmodel = m_env.m_regmodel;
        handle_err_drv_cb.m_regmodel = m_env.m_regmodel;
        // add specific component which can generate error message
        uvm_report_cb::add_by_name("*_scb", handle_err_scb_cb, m_env);
        uvm_report_cb::add_by_name("*monitor", handle_err_mon_cb, m_env);
        uvm_report_cb::add_by_name("*driver", handle_err_drv_cb, m_env);
      end
    end
  endfunction : set_report_catcher

endclass : wlan_test_base

`endif //WLAN_TEST_BASE_SV

