//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef WLAN_TEST_PKG_SV
`define WLAN_TEST_PKG_SV

package wlan_test_pkg;
  import uvm_pkg::*;
  `include "uvm_macros.svh"

  /* import all needed packages */
  import KeyStorageRAM_pkg::*;
  import frame_model_pkg::*;
  import wlan_pkg::*;
  import ahb_master_pkg::*;
  import rst_pkg::*;
  import mac_phy_pkg::*;

  /* end of imports */
  `include "mdm_import_func.sv"
  `include "wlan_report_catcher.sv"

  /* list all WLAN test cases */
  `include "wlan_test_base.sv"
  `include "test_wlan_regs_reset.sv"
  `include "test_wlan_regs_rw.sv"
  `include "test_wlan_axi_read_write.sv"
  `include "test_wlan_rx_ampdu_frame.sv"
  `include "test_wlan_rx_ampdu_frame_wc.sv"
  `include "test_wlan_tx_ampdu_frame.sv"
  `include "test_wlan_tx_ampdu_frame_wc.sv"
  `include "test_wlan_rx_mumimo_frame.sv"
  `include "test_wlan_bf_tx.sv"
  `include "test_wlan_tx_mumimo_frame.sv"
  `include "test_wlan_bf_su_rx_vht.sv"
  `include "test_wlan_bf_su_rx_he.sv"
  `include "test_wlan_bf_mu_rx_vht.sv"
  `include "test_wlan_rx_dsss_frame.sv"
  `include "test_wlan_tx_dsss_frame.sv"
  `include "test_wlan_tx_custom_frame.sv"
  `include "test_wlan_rx_custom_frame.sv"
  `include "test_wlan_mac_state_change.sv"
  `include "test_wlan_tx_power.sv"
  `include "test_wlan_rx_power.sv"
  `include "test_wlan_rx_ofdm_dsss_frame.sv"
  `include "test_wlan_bf_mu_rx_he.sv"

endpackage : wlan_test_pkg

`endif // WLAN_TEST_PKG_SV
