//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_TEST_BASE_SV
`define MODEM_TEST_BASE_SV

//-----------------------------------

class modem_test_base extends wlan_test_base;
  `uvm_component_utils(modem_test_base)


  function new (string name = "modem_test_base", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase

  // function for custom configuration of environment,
  // it can be overwritten in child class
  virtual function void configure_env();
    m_cfg.has_radio_uvc               = 1;
    m_cfg.has_bus_monitor_agent       = 1;
    // configure MAC-PHY to have one active agent (MAC)
    m_cfg.m_mac_phy_cfg.has_mac_agent = 1;
    m_cfg.m_mac_phy_cfg.has_phy_agent = 0;
    m_cfg.has_sram_agent              = 0;
    m_cfg.has_axi_uvc                 = 0;
    m_cfg.has_mac_irq_scoreboard      = 0;
    m_cfg.has_platf_irq_scoreboard    = 0;
    m_cfg.has_irq_raw_agent           = 0;
    m_cfg.has_irq_agent               = 0;
    m_cfg.has_sram_bus_agent          = 0;
    m_cfg.has_coex_bt_agent           = 0;
    // do not build verification environment with BF agents
    // if RTL has no support for them
`ifdef RW_BFMEE_EN
    m_cfg.has_bf_uvc                        = 1;
    m_cfg.has_modem_bf_scoreboard           = 1;
    m_cfg.m_bf_cfg.m_mac_bf_cfg.is_active   = UVM_ACTIVE;
    m_cfg.m_bf_cfg.has_mac_bf_agent         = 1;
`elsif RW_BFMER_EN
    m_cfg.has_bf_uvc                        = 1;
    m_cfg.has_modem_bf_scoreboard           = 1;
    m_cfg.m_bf_cfg.has_mac_bf_agent         = 0;
`else
    m_cfg.has_bf_uvc                        = 0;
    m_cfg.has_modem_bf_scoreboard           = 0;
`endif
    // configure HDMCORE agent
    m_cfg.has_hdmcore_agent               = 1;
    m_cfg.m_hdmcore_cfg.is_active         = UVM_PASSIVE;
    m_cfg.m_hdmcore_cfg.is_stream_agent   = 1;
    m_cfg.m_deint_cfg.is_active           = UVM_PASSIVE;
    m_cfg.m_deint_cfg.is_stream_agent     = 1;
    m_cfg.m_deint_cfg.buffer_mode_on      = 1;
    m_cfg.m_deint_cfg.symb_end_on_last    = 1;
    m_cfg.m_equ_cfg.is_active             = UVM_PASSIVE;
    m_cfg.m_equ_cfg.is_stream_agent       = 1;
    m_cfg.m_equ_cfg.buffer_mode_on        = 1;
    m_cfg.m_equ_cfg.symb_end_on_last      = 1;
    m_cfg.m_ldpc_cfg.is_active            = UVM_PASSIVE;
    m_cfg.m_ldpc_cfg.is_stream_agent      = 1;
    m_cfg.m_ldpc_cfg.buffer_mode_on       = 1;
    m_cfg.m_ldpc_data_cfg.is_active       = UVM_PASSIVE;
    m_cfg.m_ldpc_data_cfg.is_stream_agent = 1;
    m_cfg.m_ldpc_data_cfg.buffer_mode_on  = 1;
    m_cfg.has_viterbi_in_agent            = `VTB_IN_CHK;
    m_cfg.m_viterbi_in_cfg.is_active       = UVM_PASSIVE;
    m_cfg.m_viterbi_in_cfg.is_stream_agent = 1;
    m_cfg.m_viterbi_in_cfg.buffer_mode_on  = 1;
    m_cfg.m_viterbi_in_cfg.symb_end_on_last= 1;
    // configure FFT input agent
    m_cfg.has_fft_in_agent         = 1;
    m_cfg.m_fft_in_cfg.is_active   = UVM_PASSIVE;
    m_cfg.m_fft_in_cfg.is_read_mem = 0; // write memory agent
    // configure FFT output agent
    m_cfg.has_fft_out_agent         = 1;
    m_cfg.m_fft_out_cfg.is_active   = UVM_PASSIVE;
    m_cfg.m_fft_out_cfg.is_read_mem = 1; // read memory agent
//    m_cfg.m_fft_out_cfg.symb_end_on_last = 0; // end of symbol triggered by "last" signal

  endfunction : configure_env

  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  function void end_of_elaboration();
    super.end_of_elaboration();
  endfunction : end_of_elaboration

  function void final_phase(uvm_phase phase);
    super.final_phase(phase);
  endfunction : final_phase

endclass : modem_test_base

`endif //MODEM_TEST_BASE_SV

