//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef MODEM_TEST_PKG_SV
`define MODEM_TEST_PKG_SV

package modem_test_pkg;
  import uvm_pkg::*;
  `include "uvm_macros.svh"

  /* import all needed packages */
  import KeyStorageRAM_pkg::*;
  import frame_model_pkg::*;
  import wlan_pkg::*;
  import ahb_master_pkg::*;
  import rst_pkg::*;
  import mac_phy_pkg::*;
  import mac_pkg::*;
  import wlan_test_pkg::*;

  /* end of imports */
  `include "mdm_import_func.sv"

  /* list all MODEM test cases */
  `include "modem_test_base.sv"
  `include "test_modem_tx.sv"
  `include "test_modem_rx.sv"
  `include "test_modem_rx_non_ht.sv"
  `include "test_modem_rx_ht_mf.sv"
  `include "test_modem_rx_ht_gf.sv"
  `include "test_modem_rx_vht.sv"
  `include "test_modem_rx_he_tb.sv"
  `include "test_modem_rx_he_su.sv"
  `include "test_modem_rx_he_mu.sv"
  `include "test_modem_rx_err.sv"
  `include "test_modem_consecutive_rx_err.sv"
  `include "test_modem_correct_incorrect_rx.sv"
  `include "test_modem_no_agc_rx.sv"
  `include "test_modem_mu_rx_vht.sv"
  `include "test_modem_mu_rx_he.sv"
  `include "test_modem_ndp_rx_vht.sv"
  `include "test_modem_ndp_rx_he.sv"
  `include "test_modem_bf_tx.sv"
  `include "test_modem_mu_tx.sv"
  `include "test_modem_rx_tx.sv"
  `include "test_modem_rx_tx_dsss_frame.sv"
  `include "test_modem_tx_he_mu.sv"
  `include "test_modem_tx_he_su.sv"
  `include "test_modem_tx_he_tb.sv"
  `include "test_modem_tx_ht_gf.sv"
  `include "test_modem_tx_ht_mf.sv"
  `include "test_modem_tx_non_ht.sv"
  `include "test_modem_tx_vht.sv"
  `include "test_modem_rx_from_matlab.sv"
  `include "test_modem_tx_from_matlab.sv"
  `include "test_modem_rx_tx_he_tb.sv"
  `include "test_modem_rx_20mhz_only.sv"
  // test cases for TimeDomain only
  `include "test_modem_rx_td_non_ht.sv"
  `include "test_modem_rx_td_ht_mf.sv"
  `include "test_modem_rx_td_ht_gf.sv"
  `include "test_modem_rx_td_vht.sv"
  `include "test_modem_rx_td_he_su.sv"
  `include "test_modem_rx_td_he_tb.sv"
  `include "test_modem_rx_td_he_mu.sv"
  // test cases for FrequencyDomain only
  `include "test_modem_rx_fd_non_ht.sv"
  `include "test_modem_rx_fd_ht_mf.sv"
  `include "test_modem_rx_fd_ht_gf.sv"
  `include "test_modem_rx_fd_vht.sv"
  `include "test_modem_rx_fd_he_su.sv"
  `include "test_modem_rx_fd_he_tb.sv"
  `include "test_modem_rx_fd_he_mu.sv"
  // Custom HE MU testcase
  `include "test_modem_rx_custom_he_mu.sv"
  `include "test_modem_rx_ru_allocation.sv"
  // Custom SNR testcase
  `include "test_modem_rx_snr.sv"
  // Add NON-HT reception after NDP
  `include "test_modem_ndp_rx_he_with_non_ht.sv"

endpackage : modem_test_pkg

`endif // MODEM_TEST_PKG_SV
