//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef TEST_MODEM_BF_TX_SV
`define TEST_MODEM_BF_TX_SV

//-----------------------------------

class test_modem_bf_tx extends modem_test_base;
  `uvm_component_utils(test_modem_bf_tx)

  modem_bf_tx_seq seq;

  function new (string name = "test_modem_bf_tx", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  virtual function void configure_env();
    super.configure_env();
  endfunction : configure_env

  task run_phase(uvm_phase phase);

    `ifndef RW_BFMER_EN
      `uvm_fatal(get_type_name(), $sformatf("Wrong configuration - RTL has no support for beamformer mode. Please choose a configuration which defines RW_BFMER_EN!"))
    `endif

    phase.raise_objection(this, "test_modem_bf_tx");
    seq = modem_bf_tx_seq::type_id::create("seq");
    assert(seq.randomize());
    seq.start(m_env.m_vsqr);

    phase.drop_objection(this, "test_modem_bf_tx");
  endtask : run_phase

endclass : test_modem_bf_tx

`endif //TEST_MODEM_BF_TX_SV
