//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef TEST_MODEM_MU_RX_HE_SV
`define TEST_MODEM_MU_RX_HE_SV

//-----------------------------------

class test_modem_mu_rx_he extends modem_test_base;
  `uvm_component_utils(test_modem_mu_rx_he)

  modem_mu_rx_seq seq;

  function new (string name = "test_modem_mu_rx_he", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  virtual function void configure_env();
    super.configure_env();

    m_cfg.has_modem_stream_scoreboard = 1;
    m_cfg.has_modem_rx_scoreboard     = 1;
    m_cfg.has_modem_tx_scoreboard     = 0;
    m_cfg.has_modem_bf_scoreboard     = 0;
    m_cfg.has_deint_agent             = 1;
    m_cfg.has_equ_agent               = 1;
    m_cfg.has_ldpc_agent              = 1;
    m_cfg.has_ldpc_data_agent         = 1;
    m_cfg.has_viterbi_in_agent        = 0;

    m_cfg.m_fft_out_cfg.is_active     = UVM_PASSIVE;
    m_cfg.m_fft_in_cfg.is_active      = UVM_PASSIVE;
    // Disable AGC
    m_cfg.m_radio_cfg.m_rui_cfg.agcBypass = 1;
  endfunction : configure_env

  task run_phase(uvm_phase phase);
    `ifndef RW_MUMIMO_RX_EN
      `uvm_fatal(get_type_name(), $sformatf("Wrong configuration - RTL has no support for MU-MIMO Rx. Please choose a configuration which defines RW_MUMIMO_RX_EN!"))
    `endif
    phase.raise_objection(this, "test_modem_mu_rx_he");

    seq = modem_mu_rx_seq::type_id::create("seq");
    seq.is_he = 1;
    assert(seq.randomize());
    seq.start(m_env.m_vsqr);

    phase.drop_objection(this, "test_modem_mu_rx_he");
  endtask : run_phase

endclass : test_modem_mu_rx_he

`endif //TEST_MODEM_MU_RX_SV
