//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : In a 40 MHz BSS, the 40 MHz STA can be configured in 20 MHz only mode;
//                    Set HW in "20 MHz only mode" by writing MDMCONF.CONF_BW register = 0;
//                    40 MHz AP sends a 20 MHz frame: the Matlab configuration is the same
//                    for a 20 MHz STA or a 20 MHz only STA,
//                    so in MATLAB you have to set CFG.ChannelBW, [ 20 ] in defSTAs.txt
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef TEST_MODEM_RX_20MHZ_ONLY_SV
`define TEST_MODEM_RX_20MHZ_ONLY_SV

//-----------------------------------

class test_modem_rx_20mhz_only extends modem_test_base;
  `uvm_component_utils(test_modem_rx_20mhz_only)

  modem_rx_seq seq;

  function new (string name = "test_modem_rx_20mhz_only", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  virtual function void configure_env();
    super.configure_env();

    m_cfg.has_modem_stream_scoreboard = 1;
    m_cfg.has_modem_rx_scoreboard     = 1;
    m_cfg.has_modem_tx_scoreboard     = 0;
    m_cfg.has_modem_bf_scoreboard     = 0;
    m_cfg.has_deint_agent             = 1;
    m_cfg.has_equ_agent               = 1;
    m_cfg.has_ldpc_agent              = 1;
    m_cfg.has_ldpc_data_agent         = 1;

    m_cfg.m_fft_out_cfg.is_active     = UVM_PASSIVE;
    m_cfg.m_fft_in_cfg.is_active      = UVM_PASSIVE;

    m_cfg.m_radio_cfg.m_rui_cfg.agcBypass = 1;
  endfunction : configure_env

  task run_phase(uvm_phase phase);
`ifdef RW_NX_CHBW4020
    phase.raise_objection(this, "test_modem_rx_20mhz_only");

    seq = modem_rx_seq::type_id::create("seq");
    // force STA config to be 20MHZ and PPDU frames
    seq.force_20mhz = 1;
    assert(seq.randomize());
    seq.start(m_env.m_vsqr);

    phase.drop_objection(this, "test_modem_rx_20mhz_only");
`else
  `uvm_info(get_type_name(),"Configuration is only 20MHZ, test case will be skipped!",UVM_LOW)
`endif//RW_NX_CHBW4020
  endtask : run_phase

endclass : test_modem_rx_20mhz_only

`endif //TEST_MODEM_RX_20MHZ_ONLY_SV
