//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef TEST_MODEM_RX_ERR_SV
`define TEST_MODEM_RX_ERR_SV

//-----------------------------------

class test_modem_rx_err extends modem_test_base;
  `uvm_component_utils(test_modem_rx_err)

  modem_rx_err_seq seq;

  function new (string name = "test_modem_rx_err", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  virtual function void configure_env();
    super.configure_env();

    m_cfg.has_modem_stream_scoreboard = 1;
    m_cfg.has_modem_rx_scoreboard     = 1;
    m_cfg.has_modem_tx_scoreboard     = 0;
    m_cfg.has_modem_bf_scoreboard     = 0;
    m_cfg.has_deint_agent             = 1;
    m_cfg.has_equ_agent               = 1;
    m_cfg.has_ldpc_agent              = 1;
    m_cfg.has_ldpc_data_agent         = 1;

    m_cfg.m_fft_out_cfg.is_active     = UVM_PASSIVE;
    m_cfg.m_fft_in_cfg.is_active      = UVM_PASSIVE;

    m_cfg.m_radio_cfg.m_rui_cfg.agcBypass = 1;
    // set flag for error injection test case
    m_cfg.insert_modem_rx_error = 1;
    m_cfg.m_radio_cfg.m_rui_cfg.sig_error_injection = 1;
  endfunction : configure_env

  task run_phase(uvm_phase phase);
    phase.raise_objection(this, "test_modem_rx_err");

    `uvm_info(get_type_name(),"MODEM RX ERROR TEST CASE", UVM_LOW)
    seq = modem_rx_err_seq::type_id::create("seq");
    assert(seq.randomize());
    seq.start(m_env.m_vsqr);

    phase.drop_objection(this, "test_modem_rx_err");
  endtask : run_phase

endclass : test_modem_rx_err

`endif //TEST_MODEM_RX_ERR_SV
