//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : define SYSPARAM_TXT_DIR
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef TEST_MODEM_RX_FROM_MATLAB_SV
`define TEST_MODEM_RX_FROM_MATLAB_SV

//-----------------------------------

class test_modem_rx_from_matlab extends modem_test_base;
  `uvm_component_utils(test_modem_rx_from_matlab)

  modem_rx_from_matlab_seq seq;

  function new (string name = "test_modem_rx_from_matlab", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  virtual function void configure_env();
    super.configure_env();

    m_cfg.has_modem_stream_scoreboard = 1;
    m_cfg.has_modem_rx_scoreboard     = 1;
    m_cfg.has_modem_tx_scoreboard     = 0;
    m_cfg.has_modem_bf_scoreboard     = 0;

    m_cfg.has_deint_agent             = 1;
    m_cfg.has_equ_agent               = 1;
    m_cfg.has_ldpc_agent              = 1;
    m_cfg.has_ldpc_data_agent         = 1;
    m_cfg.has_viterbi_in_agent        = 1;

    m_cfg.check_ppdu_mpif             = 0;// don't check PPDU on MAC-PHY IF because we don't have referent one

    //---------------------------------------------
    // FD testing enabled
    // Comment this line, for full MODEM PATH
    // enable write of FFT input
    //---------------------------------------------
    //m_cfg.m_fft_in_cfg.is_active      = UVM_ACTIVE;

    //---------------------------------------------
    // TD testing enabled
    // Comment this line, for full MODEM PATH
    // enable read FFT out
    //---------------------------------------------
    //m_cfg.m_fft_out_cfg.is_active      = UVM_ACTIVE;

    //---------------------------------------------
    // enable setting SNR from file
    //---------------------------------------------
    m_cfg.m_radio_cfg.m_rui_cfg.set_snr_from_file = 1;
    //---------------------------------------------
    // Bypass AGC or enable
    //---------------------------------------------
    m_cfg.m_radio_cfg.m_rui_cfg.agcBypass = 1;

  endfunction : configure_env

  task run_phase(uvm_phase phase);
    phase.raise_objection(this, "test_modem_rx_from_matlab");

    //------------------------------------------------------
    // enable usage of pre-set files that Matlab uses
    //------------------------------------------------------
    m_env.m_mdm_data_model.use_preset_files = 1;

    // create sequence, randomize and execute sequence
    seq = modem_rx_from_matlab_seq::type_id::create("seq");
    // set number of frames to run
    seq.frame_num = 1;
    // set number of frames before MAC driver de-asserts rxReq
    seq.num_rx_frames = 1;
    // set frame kind
    seq.custom_kind = AGGREGATED; ///MU_MIMO/NDP/SINGLETON
    // set frame format
    seq.custom_format = HE_SU; //NON_HT/NON_HT_DUP_OFDM/HT_GF/HT_MF/VHT/HE_SU/HE_MU/HE_TB

    assert(seq.randomize());
    seq.start(m_env.m_vsqr);

    phase.drop_objection(this, "test_modem_rx_from_matlab");
  endtask : run_phase

endclass : test_modem_rx_from_matlab

`endif //TEST_MODEM_RX_FROM_MATLAB_SV




