//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef TEST_MODEM_RX_RU_ALLOCATION_SV
`define TEST_MODEM_RX_RU_ALLOCATION_SV

//-----------------------------------

class test_modem_rx_ru_allocation extends modem_test_base;
  `uvm_component_utils(test_modem_rx_ru_allocation)

  modem_rx_ru_allocation_seq seq;

  function new (string name = "test_modem_rx_ru_allocation", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  function void end_of_elaboration();
    super.end_of_elaboration();

    uvm_top.set_timeout(300ms);

  endfunction : end_of_elaboration

  virtual function void configure_env();
    super.configure_env();

    m_cfg.has_modem_stream_scoreboard = 1;
    m_cfg.has_modem_rx_scoreboard     = 1;
    m_cfg.has_modem_tx_scoreboard     = 0;
    m_cfg.has_modem_bf_scoreboard     = 0;
    m_cfg.has_deint_agent             = 1;
    m_cfg.has_equ_agent               = 1;
    m_cfg.has_ldpc_agent              = 1;
    m_cfg.has_ldpc_data_agent         = 1;
    // enable read of FFT input
    m_cfg.m_fft_in_cfg.is_active      = UVM_ACTIVE;
    // Disable AGC
    m_cfg.m_radio_cfg.m_rui_cfg.agcBypass = 1;
  endfunction : configure_env

  task run_phase(uvm_phase phase);
    phase.raise_objection(this, "test_modem_rx_ru_allocation");

    seq = modem_rx_ru_allocation_seq::type_id::create("seq");
    // customize sequence
    seq.custom_test = 1;
    seq.custom_format_mode = HE_MU;
    assert(seq.randomize());
    seq.start(m_env.m_vsqr);

    phase.drop_objection(this, "test_modem_rx_ru_allocation");
  endtask : run_phase

endclass : test_modem_rx_ru_allocation

`endif //TEST_MODEM_RX_RU_ALLOCATION_SV




