//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef AHB_MASTER_DIRECT_SEQ_SV
`define AHB_MASTER_DIRECT_SEQ_SV

class ahb_master_direct_seq extends ahb_master_seq_base;

  `uvm_object_utils(ahb_master_direct_seq)

  rand bit [ `AHB_MASTER_ADDR_WIDTH-1:0]       addr;
  rand bit [ `AHB_MASTER_DATA_WIDTH-1:0][31:0] data;
  rand bus_access_type_e                       access;
  rand ahb_burst_size_e                        burst_size;
  rand ahb_transfer_size_e                     size;
       bit [ `AHB_MASTER_DATA_WIDTH-1:0][31:0] read_data;


  function new(string name = "ahb_master_direct_seq");
    super.new(name);
  endfunction : new


  virtual task body();
    begin
      `uvm_info(get_type_name(), "Starting...", UVM_DEBUG)
      req = ahb_master_seq_item::type_id::create("req");

      start_item(req);

      assert(req.randomize() with {
        req.ahb_burst_size == burst_size;
        req.ahb_burst   == SINGLE;
        req.ahb_addr    == addr;
        req.ahb_access  == access;
        req.ahb_data    == data;
        req.ahb_size    == size;
        req.ahb_trans   == NONSEQ;
      });
      finish_item(req);
      // when read is performed, return read value
      if (access == READ) begin
        read_data = req.ahb_data;
      end
    end
  endtask : body

endclass : ahb_master_direct_seq


`endif //AHB_MASTER_DIRECT_SEQ_SV
