//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef AHB_MASTER_COMMON_SV
`define AHB_MASTER_COMMON_SV

  // add defines, parameters, typedefs, enums...

  // AHB bus signal widths
  `define AHB_MASTER_ADDR_WIDTH  32  // AHB bus address width
  `define AHB_MASTER_DATA_WIDTH  32  // AHB bus data width
  `define AHB_MASTER_TRANS_WIDTH  2  // AHB bus transfer type width
  `define AHB_MASTER_BURST_WIDTH  3  // AHB bus burst size width
  `define AHB_MASTER_SIZE_WIDTH   3  // AHB bus transfer size width
  `define AHB_MASTER_PROT_WIDTH   4  // AHB bus protection control width

  `define AHB_SLAVE_HRESP_WIDTH   2  // AHB bus transfer response width

  `define SPLIT_DELAY_MIN        50  // Min delay between split transactions
  `define SPLIT_DELAY_MAX       150  // Max delay between split transactions

  // Bus access type
  typedef enum {READ=0, WRITE} bus_access_type_e;

  // AHB bus transfer bus type
  typedef enum {IDLE=0, BUSY, NONSEQ, SEQ} ahb_transfer_type_e;

  //AHB burst size
  typedef enum {SINGLE=0, INCR, WRAP4, INCR4, WRAP8, INCR8, WRAP16, INCR16} ahb_burst_size_e;

  //AHB transfer size
  typedef enum {BYTE=0, HALFWORD, WORD, WORD2, WORD4_LINE, WORD8_LINE, WORD16, WORD32} ahb_transfer_size_e;

  //AHB protection control
  typedef struct packed{
    bit cacheable_f;
    bit bufferable_f;
    bit privileged_f;
    bit data_opcode_f;
    } ahb_protection_t;

  // AHB slave response
  typedef enum {OKAY=0, ERROR, RETRY, SPLIT} ahb_transfer_response_e;

  // calculate number of transferred bytes in one burst
  function int calculate_xfer_bytes (ahb_burst_size_e burst_size, ahb_transfer_size_e data_size);
    case (burst_size)
      WRAP4   :  return (4*(2**data_size));
      WRAP8   :  return (8*(2**data_size));
      WRAP16  :  return (16*(2**data_size));
      default :  return (0);
    endcase
  endfunction:calculate_xfer_bytes

  // calculate address increment for burst beats
  function int calculate_increment (ahb_transfer_size_e data_size);
    return (2**data_size);
  endfunction: calculate_increment

  // calculate next address in a burst
  function bit [`AHB_MASTER_ADDR_WIDTH-1:0] calculate_address([`AHB_MASTER_ADDR_WIDTH-1:0] addr, ahb_burst_size_e burst_size, int beat, ahb_transfer_size_e data_size );
     bit [`AHB_MASTER_ADDR_WIDTH-1:0] base_address; // rollover address
     bit [`AHB_MASTER_ADDR_WIDTH-1:0] wrap_address; // address at which the burst should wrap
     bit [`AHB_MASTER_ADDR_WIDTH-1:0] calc_address; // calculated address

     case (burst_size)
       SINGLE: begin
                 calc_address = addr; // there is no burst at all, shouldn't get here
               end
       INCR, INCR4, INCR8, INCR16: begin
                 calc_address = addr + beat * calculate_increment(data_size); // There is no address wraping in INCRx bursts
               end
       default: // all WRAPx cases
               begin
                 base_address = (addr/calculate_xfer_bytes(burst_size, data_size))* calculate_xfer_bytes(burst_size, data_size); // discard the fractional part
                 wrap_address = base_address + 2**(calculate_increment(data_size));
                 calc_address = addr + beat * calculate_increment(data_size);
                 if (calc_address >= wrap_address) begin
                   calc_address = calc_address - wrap_address + base_address ;
                 end
               end
    endcase

    `uvm_info("calculate_address :: ", $sformatf("Burst start address:0x%x base address: 0x%x wrap address: 0x%x beat: %4d calculated address: 0x%x ", addr, base_address, wrap_address, beat, calc_address), UVM_HIGH)
    return calc_address;

  endfunction: calculate_address




`endif// AHB_MASTER_COMMON_SV
