//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef AHB_MASTER_CONFIG_SV
`define AHB_MASTER_CONFIG_SV

class ahb_master_config extends uvm_object;

  uvm_active_passive_enum        is_active = UVM_ACTIVE;
  bit                            has_coverage = 1;
  bit                            has_checks   = 1;
  bit                            ahb_use_htrans_busy = 0; // If set to 0, burst transfers will not be interrupted
                                                          // with idle cycles (HTRANS = BUSY)
  bit                            ahb_use_htrans_idle = 0; // If set to 0, HTRANS=IDLE (no data transfer required)
                                                          // transaction types will be excluded
                                                          // from constrained random generation

  `uvm_object_utils_begin(ahb_master_config)
    `uvm_field_enum(uvm_active_passive_enum, is_active, UVM_DEFAULT)
    `uvm_field_int(has_coverage, UVM_DEFAULT)
    `uvm_field_int(has_checks, UVM_DEFAULT)
    `uvm_field_int(ahb_use_htrans_busy, UVM_DEFAULT)
    `uvm_field_int(ahb_use_htrans_idle, UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "ahb_master_config");
    super.new(name);
  endfunction

endclass : ahb_master_config

`endif
