//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef AHB_MASTER_COVERAGE_SV
`define AHB_MASTER_COVERAGE_SV

class ahb_master_coverage extends uvm_subscriber #(ahb_master_seq_item);

  `uvm_component_utils(ahb_master_coverage)

  ahb_master_seq_item item;

  //-------------------------------------------------
  // Cover groups
  //-------------------------------------------------
  covergroup ahb_master_active_cg (string name) ;
    option.per_instance = 1;
    option.name = name;
    AHB_TRANS_TYPE: coverpoint item.ahb_trans {
      bins IDLE   = {IDLE};
      bins BUSY   = {BUSY};
      bins NONSEQ = {NONSEQ};
      bins SEQ    = {SEQ};
    }

    AHB_TRANS_SIZE: coverpoint item.ahb_size {
      bins BITS_8    = {BYTE};
      bins BITS_16   = {HALFWORD};
      bins BITS_32   = {WORD};
      bins BITS_64   = {WORD2};
      bins BITS_128  = {WORD4_LINE};
      bins BITS_256  = {WORD8_LINE};
      bins BITS_512  = {WORD16};
      bins BITS_1024 = {WORD32};
    }

    AHB_ACCESS_TYPE: coverpoint item.ahb_access {
      bins READ  = {READ};
      bins WRITE = {WRITE};
    }

    AHB_BURST_SIZE: coverpoint item.ahb_burst {
      bins SINGLE = {SINGLE};
      bins INCR   = {INCR};
      bins WRAP4  = {WRAP4};
      bins INCR4  = {INCR4};
      bins WRAP8  = {WRAP8};
      bins INCR8  = {INCR8};
      bins WRAP16 = {WRAP16};
      bins INCR16 = {INCR16};
    }

    AHB_ADDRESS: coverpoint item.ahb_addr {
      //auto bins for now
      option.auto_bin_max = 20;
    }

    AHB_DATA: coverpoint item.ahb_data {
      //auto bins for now
      option.auto_bin_max = 20;
    }

    AHB_ADDR_ACCES: cross AHB_ACCESS_TYPE, AHB_ADDRESS;
    AHB_ADDR_DATA: cross AHB_ADDRESS,AHB_DATA;

  endgroup : ahb_master_active_cg

  function new(string name = "ahb_master_coverage", uvm_component parent = null);
    super.new(name, parent);

    ahb_master_active_cg  = new(name);
  endfunction : new

  function void write(ahb_master_seq_item t);
    item = t;
    ahb_master_active_cg .sample();
  endfunction : write

endclass : ahb_master_coverage

`endif //AHB_MASTER_COVERAGE_SV
