//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef AHB_MASTER_IF_SV
`define AHB_MASTER_IF_SV

interface ahb_master_if;

  // Check flags
  bit   has_checks = 1;
  bit   has_coverage = 1;

  // signal declaration
  logic [ `AHB_MASTER_ADDR_WIDTH-1:0] haddr;
  logic [ `AHB_MASTER_DATA_WIDTH-1:0] hwdata;
  logic [ `AHB_MASTER_DATA_WIDTH-1:0] hrdata;
  logic [`AHB_MASTER_TRANS_WIDTH-1:0] htrans;
  logic [ `AHB_MASTER_SIZE_WIDTH-1:0] hsize;
  logic [`AHB_MASTER_BURST_WIDTH-1:0] hburst;
  logic [ `AHB_MASTER_PROT_WIDTH-1:0] hprot;

  logic [ `AHB_SLAVE_HRESP_WIDTH-1:0] hresp;    // transfer response from slave
  logic                               hclk;     // this clock times all bus transfers
  logic                               hresetn;  // resets the system and bus
  logic                               hready;   // when high th etransfer has finished on the bus
  logic                               hwrite;

  /***************************/
  /* ASSERTIONS              */
  /***************************/

  /***************************/
  /* COVERAGE                */
  /***************************/

endinterface : ahb_master_if

`endif
