
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef AHB_MASTER_MONITOR_SV
`define AHB_MASTER_MONITOR_SV


class ahb_master_monitor extends uvm_monitor;

  virtual ahb_master_if vif;
  ahb_master_config     cfg;
  int                   burst_counter;
  bit                   transaction_done;
  bit                   burst_done;
  uvm_analysis_port #(ahb_master_seq_item) ap;

  `uvm_component_utils(ahb_master_monitor)

  function new(string name = "ahb_master_monitor", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual ahb_master_if)::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

    ap = new("ap", this);
  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    fork
      collect_transaction();
      observe_reset();
      /* add some task calls here */
    join_none;
  endtask : run_phase

  task observe_reset();
    wait (vif.hresetn == 'b0);
    `uvm_info(get_type_name(), "Transaction recording interrupted by reset assertion.", UVM_DEBUG);
  endtask : observe_reset


  task collect_transaction();

    forever begin
      ahb_master_seq_item item = ahb_master_seq_item::type_id::create("item");

      burst_counter    =   0;
      transaction_done = 'b0;

      wait(vif.htrans == 'h2); //wait for a NONSEQ which indicates start of transfer

      @(posedge vif.hclk); //sample the signals on the rising edge, as the slave does
      item.ahb_addr =  vif.haddr;
      item.ahb_trans = ahb_transfer_type_e'(vif.htrans);
      item.ahb_burst = ahb_burst_size_e'(vif.hburst);
      item.ahb_size = ahb_transfer_size_e'(vif.hsize);
      item.ahb_prot = ahb_protection_t'(vif.hprot);
      item.ahb_access = bus_access_type_e'(vif.hwrite);

      while (transaction_done != 'b1) begin

       @(posedge vif.hclk); //sample the signals on the rising edge, as the slave does

        if (item.ahb_access == WRITE) begin
          //collect data only in case of WRITE
          item.ahb_data[burst_counter] = vif.hwdata;
        end

        while (vif.hready != 1'b1)
          @(posedge vif.hclk);

        item.ahb_resp = ahb_transfer_response_e'(vif.hresp);

        if (item.ahb_resp == OKAY) begin
          if (item.ahb_access == READ) begin
            // collect read data
            item.ahb_data[burst_counter] = vif.hrdata;
          end
          burst_counter++;

          if (item.ahb_burst == SINGLE) begin
            transaction_done = 'b1;
          end else if (((item.ahb_burst == WRAP4) || (item.ahb_burst == INCR4)) && (burst_counter == 4)) begin
            transaction_done = 'b1;
          end else if (((item.ahb_burst == WRAP8) || (item.ahb_burst == INCR8)) && (burst_counter == 8)) begin
            transaction_done = 'b1;
          end else if (((item.ahb_burst == WRAP16) || (item.ahb_burst == INCR16)) && (burst_counter == 16)) begin
            transaction_done = 'b1;
          end else if ((item.ahb_burst == INCR) && ((vif.htrans == NONSEQ) || (vif.htrans == IDLE))) begin
            transaction_done = 'b1;
          end

        end else if (item.ahb_resp == ERROR) begin
          `uvm_info(get_type_name(), $sformatf("Detected HRESP = ERROR!"), UVM_DEBUG)
          transaction_done = 'b1;
        end

      end //while (transaction_done != 'b1)

      item.ahb_burst_size = burst_counter;

      `uvm_info(get_type_name(), $sformatf("Transaction collected :\n%s", item.sprint()), UVM_DEBUG)

      if (cfg.has_checks)
        perform_checks();

      ap.write(item);
    end// forever
  endtask : collect_transaction


  function void perform_checks();
  endfunction : perform_checks

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase


endclass : ahb_master_monitor

`endif //AHB_MASTER_MONITOR_SV
