//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef AHB_MASTER_REG_ADAPTER_SV
`define AHB_MASTER_REG_ADAPTER_SV

typedef uvm_reg_predictor#(ahb_master_seq_item) ahb_master_reg_predictor;

class ahb_master_reg_adapter extends uvm_reg_adapter;
    `uvm_object_utils(ahb_master_reg_adapter)

    function new(string name = "");
      super.new(name);
      supports_byte_enable = 0;
      provides_responses  = 0;
    endfunction: new

    virtual function uvm_sequence_item reg2bus (const ref uvm_reg_bus_op rw);
      ahb_master_seq_item bus_item;

      bus_item = ahb_master_seq_item::type_id::create("bus_item");

      if (rw.kind == UVM_READ) begin
        bus_item.ahb_trans      = NONSEQ;
        bus_item.ahb_access     = READ;
        bus_item.ahb_addr       = rw.addr;
        bus_item.ahb_size       = WORD;
        bus_item.ahb_burst_size = 1;
        bus_item.ahb_burst      = SINGLE;
      end else begin
        bus_item.ahb_trans      = NONSEQ;
        bus_item.ahb_access     = WRITE;
        bus_item.ahb_data       = rw.data;
        bus_item.ahb_addr       = rw.addr;
        bus_item.ahb_size       = WORD;
        bus_item.ahb_burst_size = 1;
        bus_item.ahb_burst      = SINGLE;
      end

      return bus_item;
    endfunction: reg2bus

    virtual function void bus2reg (uvm_sequence_item bus_item, ref uvm_reg_bus_op rw);
      ahb_master_seq_item local_bus_item;

      if (!$cast(local_bus_item, bus_item)) begin
        `uvm_fatal(get_type_name(), "Cast failed: bus_item is not of ahb_master_seq_item type!")
      end

      if (local_bus_item.ahb_access == READ) begin
        rw.kind = UVM_READ;
        rw.addr = local_bus_item.ahb_addr;
        rw.data = local_bus_item.ahb_data;
      end else begin
        rw.kind = UVM_WRITE;
        rw.data = local_bus_item.ahb_data;
        rw.addr = local_bus_item.ahb_addr;
      end

      rw.status = UVM_IS_OK;

    endfunction: bus2reg


endclass: ahb_master_reg_adapter

`endif //AHB_MASTER_REG_ADAPTER_SV
