//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef AHB_MASTER_SEQ_ITEM_SV
`define AHB_MASTER_SEQ_ITEM_SV


class ahb_master_seq_item extends uvm_sequence_item;

  rand bit [ `AHB_MASTER_ADDR_WIDTH-1:0]       ahb_addr;
  rand bit [ `AHB_MASTER_DATA_WIDTH-1:0][31:0] ahb_data;
  rand bus_access_type_e                       ahb_access;
  rand ahb_transfer_type_e                     ahb_trans;
  rand ahb_burst_size_e                        ahb_burst;
  rand ahb_transfer_size_e                     ahb_size;
  rand ahb_protection_t                        ahb_prot;
  rand ahb_transfer_response_e                 ahb_resp;

  rand int ahb_burst_size; // Burst size in ahb_size units

  `uvm_object_utils_begin(ahb_master_seq_item)
    `uvm_field_int(ahb_addr, UVM_DEFAULT)
    `uvm_field_int(ahb_data, UVM_DEFAULT)
    `uvm_field_enum(bus_access_type_e, ahb_access, UVM_DEFAULT)
    `uvm_field_enum(ahb_transfer_type_e, ahb_trans, UVM_DEFAULT)
    `uvm_field_enum(ahb_burst_size_e, ahb_burst, UVM_DEFAULT)
    `uvm_field_enum(ahb_transfer_size_e, ahb_size, UVM_DEFAULT)
    `uvm_field_int(ahb_prot, UVM_DEFAULT)
    `uvm_field_int(ahb_burst_size, UVM_DEFAULT)

  `uvm_object_utils_end

  // Limit AHB transfer size to the width of the data bus. The AHB protocol
  // supports up to 1024 bits
  constraint c_transfer_size {
    if (`AHB_MASTER_DATA_WIDTH > 512)
      {ahb_size inside {BYTE, HALFWORD, WORD, WORD2, WORD4_LINE, WORD8_LINE, WORD16, WORD32};}
    else if ((`AHB_MASTER_DATA_WIDTH > 256) && (`AHB_MASTER_DATA_WIDTH <= 512))
      {ahb_size inside {BYTE, HALFWORD, WORD, WORD2, WORD4_LINE, WORD8_LINE, WORD16};}
    else if ((`AHB_MASTER_DATA_WIDTH > 128 ) && (`AHB_MASTER_DATA_WIDTH <= 256))
      {ahb_size inside {BYTE, HALFWORD, WORD, WORD2, WORD4_LINE, WORD8_LINE};}
    else if ((`AHB_MASTER_DATA_WIDTH > 64) && (`AHB_MASTER_DATA_WIDTH <= 128))
      {ahb_size inside {BYTE, HALFWORD, WORD, WORD2, WORD4_LINE};}
    else if ((`AHB_MASTER_DATA_WIDTH > 32) && (`AHB_MASTER_DATA_WIDTH <= 64))
      {ahb_size inside {BYTE, HALFWORD, WORD, WORD2};}
    else if ((`AHB_MASTER_DATA_WIDTH > 16) && (`AHB_MASTER_DATA_WIDTH <= 32))
      {ahb_size inside {BYTE, HALFWORD, WORD};}
    else if ((`AHB_MASTER_DATA_WIDTH > 8) && (`AHB_MASTER_DATA_WIDTH <= 16))
      {ahb_size inside {BYTE, HALFWORD};}
    else
      {ahb_size == BYTE;}
  }

  // If ahb_size is WORD32, limit ahb_burst
  constraint c_ahb_burst {
    (ahb_size == WORD32) -> (ahb_burst inside {SINGLE, INCR, WRAP4, INCR4, WRAP8, INCR8});
  }

  // if ahb_burst is not INCR,limit burst size
  constraint c_burst_size_limit {
   if      (ahb_burst == SINGLE)                             (ahb_burst_size == 1);
   else if (ahb_burst == WRAP4)                              (ahb_burst_size == 4);
   else if (ahb_burst == INCR4)                              (ahb_burst_size == 4);
   else if (ahb_burst == WRAP8)                              (ahb_burst_size == 8);
   else if (ahb_burst == INCR8)                              (ahb_burst_size == 8);
   else if (ahb_burst == WRAP16)                             (ahb_burst_size == 16);
   else if (ahb_burst == INCR16)                             (ahb_burst_size == 16);
   else if ((ahb_burst == INCR) && (ahb_size == BYTE))       (ahb_burst_size inside {[1:1024]});
   else if ((ahb_burst == INCR) && (ahb_size == HALFWORD))   (ahb_burst_size inside {[1: 512]});
   else if ((ahb_burst == INCR) && (ahb_size == WORD))       (ahb_burst_size inside {[1: 256]});
   else if ((ahb_burst == INCR) && (ahb_size == WORD2))      (ahb_burst_size inside {[1: 128]});
   else if ((ahb_burst == INCR) && (ahb_size == WORD4_LINE)) (ahb_burst_size inside {[1:  64]});
   else if ((ahb_burst == INCR) && (ahb_size == WORD8_LINE)) (ahb_burst_size inside {[1:  32]});
   else if ((ahb_burst == INCR) && (ahb_size == WORD16))     (ahb_burst_size inside {[1:  16]});
   else if ((ahb_burst == INCR) && (ahb_size == WORD32))     (ahb_burst_size inside {[1:   8]});
   }

  // Transer type should be IDLE or NONSEQ initially
  constraint c_transf_type {ahb_trans inside {IDLE, NONSEQ};}

  // Address generation for bursts (final address should not exceed 1kb
  // boundary  = 0x100 = 256
  constraint c_burst_addr {
    solve ahb_burst_size before ahb_addr;
    ahb_burst != SINGLE -> {((ahb_addr + (ahb_burst_size * (2**ahb_size))) & 'b111) < 256};
  }

  // TODO implement protection control
  constraint c_protection {
    ahb_prot.data_opcode_f == 1;
    ahb_prot.privileged_f  == 0;
    ahb_prot.bufferable_f  == 0;
    ahb_prot.cacheable_f   == 0;
  }

  function new (string name = "ahb_master_seq_item");
    super.new(name);
  endfunction : new

endclass : ahb_master_seq_item

`endif //AHB_MASTER_SEQ_ITEM_SV
