//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company      : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies   : None
// Description    :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator    :
// Parameters     :
// Terms & concepts :
// Bugs       :
// Open issues and future enhancements :
// References     :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef AXI_SLAVE_SEQUENCE_SV
`define AXI_SLAVE_SEQUENCE_SV

class axi_slave_sequence extends uvm_sequence #(axi_slave_seq_item);

  `uvm_object_utils(axi_slave_sequence)

  axi_slave_memory m_axi_slv_mem;

  function new (string name = "axi_slave_sequence");
    super.new (name);
  endfunction : new

  virtual task pre_body();
  endtask : pre_body

  virtual task body();
    axi_slave_seq_item req;
    axi_slave_seq_item rsp;
    int unsigned       wr_req_cnt = 0;

    // AXI memory model
    if (!uvm_config_db #(axi_slave_memory)::get(null, "", "m_axi_slv_mem", m_axi_slv_mem)) begin
      `uvm_fatal(get_type_name(), "AXI memory model missing!")
    end

    forever  begin
      `uvm_info(get_type_name(), "Starting...", UVM_HIGH)
      req = axi_slave_seq_item::type_id::create("req");
      rsp = axi_slave_seq_item::type_id::create("rsp");

      // Request
      start_item(req);
      assert(req.randomize());
      finish_item(req);

      `uvm_info(get_type_name(), $sformatf("Request phase is completed Addres = 0x%x", (req.read_fl) ? req.araddr : req.awaddr), UVM_HIGH)

      // Response
      start_item(rsp);
      // Check if response for read access should be generated
      if (req.read_fl == 1'b1) begin
        //  Perform read from the memory model
        `uvm_info(get_type_name(), $sformatf("READ request is detected for address = 0x%x", req.araddr), UVM_HIGH)
        // Read data from the memory model
        for (int i = 0; i < req.arlen + 1; i++) begin
          `uvm_info(get_type_name(), $sformatf("DEBUG. Mem. Addres = 0x%x Data = 0x%x.", req.araddr + (i * (1 << req.arsize)), m_axi_slv_mem.read_mem(req.araddr + (i * (1 << req.arsize)))), UVM_HIGH)
          req.rdata[i] = m_axi_slv_mem.read_mem(req.araddr + (i * (1 << req.arsize))); // Address calculation should be updated for all possible arsize values
        end // for (int unsigned i = 0; i < req.arlen + 1; i++)
      end // if (rsp.read_fl == 1)

      rsp.copy(req);
      rsp.control_rnd(0); // Disable randomization for the particular properties of the transaction

      // Allows to support "tricky" scenarios for WRITE responses -> very late bresp, may be extended
      if (wr_req_cnt < 5) begin
        assert(rsp.randomize() with { bvalid_dly == bvalid_dly_very_long; });
      end
      else begin
        assert(rsp.randomize() with { bvalid_dly inside {bvalid_dly_zero}; });
      end

      rsp.control_rnd(1); // Enable randomization for the particular properties of the transaction
      finish_item(rsp);

      // Check if write to the memory model should be performed (only for WRITE transfers)
      if (rsp.read_fl == 1'b0) begin
        //  Write transfer -> Valid only for AXI 4
        //  Now we have a data to be written into a memory
        `uvm_info(get_type_name(), $sformatf("WRITE request is detected for address = 0x%x", req.awaddr), UVM_HIGH)
        for (int unsigned i = 0; i < req.awlen + 1; i++) begin
          `uvm_info(get_type_name(), $sformatf("DEBUG. Mem. Addres = 0x%x", rsp.awaddr + (i * (1 << rsp.awsize))), UVM_HIGH)
          m_axi_slv_mem.write_mem(rsp.awaddr + (i * (1 << rsp.awsize)), rsp.wdata[i]); // Address calculation should be updated for all possible arsize values
        end // for (int unsigned i = 0; i < req.awlen + 1; i++)
      end // if (rsp.read_fl == 0)
      `uvm_info(get_type_name(), $sformatf("Response phase is completed Addres = 0x%x", (rsp.read_fl) ? rsp.araddr : rsp.awaddr), UVM_HIGH)
      wr_req_cnt++;
    end // forever  begin
  endtask : body

  virtual task post_body();
  endtask : post_body

endclass : axi_slave_sequence

`endif // AXI_SLAVE_SEQUENCE_SV
