//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef AXI_SLAVE_AGENT_SV
`define AXI_SLAVE_AGENT_SV

//-----------------------------------

class axi_slave_agent extends uvm_agent;

  axi_slave_config         cfg;
  axi_slave_write_driver   write_driver;
  axi_slave_read_driver    read_driver;  
  axi_slave_read_monitor   read_monitor;
  axi_slave_write_monitor  write_monitor;
//  axi_slave_coverage     coverage;
  axi_slave_sequencer      sequencer;

  `uvm_component_utils_begin(axi_slave_agent)
    `uvm_field_object(cfg, UVM_DEFAULT)
  `uvm_component_utils_end

  function new (string name = "axi_slave_agent", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    // Get Configuration
    if (!uvm_config_db#(axi_slave_config)::get(this, "", "cfg", cfg)) begin
       `uvm_fatal(get_type_name(), "Config not set for slave agent using default is_active")
    end

    // Create components
     if(!cfg.direction) begin  
      write_monitor = axi_slave_write_monitor::type_id::create("write_monitor",this);
     end  
     else begin  
      read_monitor = axi_slave_read_monitor::type_id::create("read_monitor",this);
     end  

    if (cfg.has_coverage) begin
      // Coverage is not supported for the moment
      // coverage = axi_slave_coverage::type_id::create("coverage", this);
      // Coverage is not implemented for the moment
    end

    if (cfg.is_active == UVM_ACTIVE) begin
      sequencer = axi_slave_sequencer::type_id::create("sequencer",this);
      if(!cfg.direction) begin  
        write_driver = axi_slave_write_driver::type_id::create("write_driver",this);
      end  
      else begin  
        read_driver = axi_slave_read_driver::type_id::create("read_driver",this);
      end  
    end

  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    if (cfg.has_coverage) begin
     // read_monitor.ap.connect(coverage.analysis_export);
     // Coverage is not implemented for the moment
    end

    if(!cfg.direction) begin  
      write_monitor.cfg = cfg;
    end  
    else begin  
      read_monitor.cfg = cfg;
    end  
     
    if (cfg.is_active == UVM_ACTIVE) begin
      // Connect the driver to the sequencer using TLM interface
      if(!cfg.direction) begin  
        write_driver.cfg = cfg;
        write_driver.seq_item_port.connect(sequencer.seq_item_export);
      end  
      else begin 
        read_driver.cfg = cfg; 
        read_driver.seq_item_port.connect(sequencer.seq_item_export);
      end  
    end
  endfunction : connect_phase

endclass : axi_slave_agent

`endif // AXI_SLAVE_AGENT_SV
