//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef AXI_SLAVE_COMMON_SV
`define AXI_SLAVE_COMMON_SV

// AXI

`define AXI_SLAVE_ADDR_WIDTH    (32)
`define AXI_SLAVE_DATA_WIDTH    (64)
`define AXI_SLAVE_ID_WIDTH      (4)
`define AXI_SLAVE_USER_WIDTH    (12)
`define AXI_SLAVE_QOS_WIDTH     (2)
`define AXI_SLAVE_REGION_WIDTH  (2)

  // AXI burst type
  typedef enum bit[1:0] { FIXED = 2'b00, INCR = 2'b01, WRAP = 2'b10, BRST_RSV = 2'b11 } axi_burst_type_e;


  typedef enum bit[2:0] {
                 BYTE_1   = 3'b000,
                 BYTE_2   = 3'b001,
                 BYTE_4   = 3'b010,
                 BYTE_8   = 3'b011,
                 BYTE_16  = 3'b100,
                 BYTE_32  = 3'b101,
                 BYTE_64  = 3'b110,
                 BYTE_128 = 3'b111
               } axi_burst_size_e;

 typedef enum bit[1:0] { OK = 2'b00, EXOK = 2'b01, SLVERR = 2'b10, DECERR = 2'b11 } axi_resp_type_e;

 typedef struct {
                 int unsigned                 bvalid_delay; // Delay before BVALID assertion
                 axi_resp_type_e              bresp; 
                 bit[`AXI_SLAVE_ID_WIDTH-1:0] bid;
 } bresp_s;

// Delays

typedef enum  { bvalid_dly_zero, bvalid_dly_very_short, bvalid_dly_short, bvalid_dly_very_reasonable, bvalid_dly_long, bvalid_dly_very_long } bvalid_delay_spec_e;


//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
`endif // AXI_SLAVE_COMMON_SV
