//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef AXI_SLAVE_MEMORY_SV
`define AXI_SLAVE_MEMORY_SV

class axi_slave_memory extends uvm_object;

  `uvm_object_utils(axi_slave_memory)

  // Memory array
  bit [`AXI_SLAVE_DATA_WIDTH-1:0]  axi_mem_a[int];

  function new (string name = "axi_slave_memory");
   super.new(name);
  endfunction : new

  virtual function bit[`AXI_SLAVE_DATA_WIDTH-1:0] read_mem(bit[`AXI_SLAVE_ADDR_WIDTH-1:0]   address);
    bit[`AXI_SLAVE_DATA_WIDTH-1:0] tmp;

    if(axi_mem_a.exists(address >> 2)) begin
      tmp = axi_mem_a[address >> 2];
    end
    else begin
      tmp = 64'h12345678DEADBEEF;
    end

    `uvm_info(get_type_name(), $sformatf("AXI MEMORY READ Address = 0x%x Data = 0x%x", address >> 2, tmp), UVM_DEBUG)

    return tmp;
  endfunction : read_mem

  virtual function void write_mem(bit[`AXI_SLAVE_ADDR_WIDTH-1:0] address, bit[`AXI_SLAVE_DATA_WIDTH-1:0] data);

    axi_mem_a[address >> 2] = data;
    `uvm_info(get_type_name(), $sformatf("AXI MEMORY WRITE Address = 0x%x Data = 0x%x", address >> 2, axi_mem_a[address >> 2]), UVM_DEBUG)
  endfunction : write_mem

endclass : axi_slave_memory

`endif // AXI_SLAVE_MEMORY_SV
