//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef AXI_SLAVE_SEQ_ITEM_SV
`define AXI_SLAVE_SEQ_ITEM_SV

class axi_slave_seq_item extends uvm_sequence_item;

 const int unsigned axi_max_beat = 256; // Maximum number of beats in AXI transaction

  // Address from the master
  bit[`AXI_SLAVE_ID_WIDTH-1:0]     awid;
  bit[`AXI_SLAVE_ADDR_WIDTH-1:0]   awaddr;
  bit[7:0]                         awlen;
  bit[2:0]                         awsize;
  bit[1:0]                         awburst;
//  bit                              awlock;
//  bit[3:0]                         awcache;
//  bit[2:0]                         awprot;
  bit[`AXI_SLAVE_QOS_WIDTH-1:0]    awqos;
//  bit[`AXI_SLAVE_REGION_WIDTH-1:0] awregion;
  bit[`AXI_SLAVE_USER_WIDTH-1:0]   awuser;

  rand int unsigned                awvalid_delay; // Delay before AWVALID assertion

  // Data from the master (Not random)
  bit[`AXI_SLAVE_ID_WIDTH-1:0]         wid;          // Not supported in AXI 4
  rand bit[`AXI_SLAVE_DATA_WIDTH-1:0]   wdata[];
  rand bit[`AXI_SLAVE_DATA_WIDTH/8-1:0] wstrb[];
  bit[`AXI_SLAVE_USER_WIDTH-1:0]       wuser;

  rand int unsigned                    wvalid_delay[]; // Delays before WVALID assertion

   // Response to the master (Random)
   bit[`AXI_SLAVE_ID_WIDTH-1:0]     bid;    // Should be randomized manually
   bit[1:0]                         bresp;  // !!!!
   bit[`AXI_SLAVE_USER_WIDTH-1:0]   buser;

   rand int unsigned                     bvalid_delay; // Delays before BVALID assertion

  // Data from the master (Not Random)
  bit[`AXI_SLAVE_ID_WIDTH-1:0]     arid;
  bit[`AXI_SLAVE_ADDR_WIDTH-1:0]   araddr;
  bit[7:0]                         arlen;
  bit[2:0]                         arsize;
  bit[1:0]                         arburst;
//  bit                              arlock;
//  bit[3:0]                         arcache;
//  bit[2:0]                         arprot;
  bit[`AXI_SLAVE_QOS_WIDTH-1:0]    arqos;
//  bit[`AXI_SLAVE_REGION_WIDTH-1:0] arregion;
  bit[`AXI_SLAVE_USER_WIDTH-1:0]   aruser;

  rand int unsigned                arvalid_delay; // Delay before ARVALID assertion

  // Data to the master (Random)
  bit[`AXI_SLAVE_ID_WIDTH-1:0]        rid; // Should be randomized manually ???
  rand bit[`AXI_SLAVE_DATA_WIDTH-1:0] rdata[];
  rand bit[1:0]                       rresp[]; // !!!!
  bit[`AXI_SLAVE_USER_WIDTH-1:0]      ruser;

  rand int unsigned                rvalid_delay[]; // Delays before RVALID assertion
 // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  bit                              read_fl; // Indicates READ transfer 

  // Additional control of constraints
  rand bvalid_delay_spec_e         bvalid_dly; // Only for WRITE RESPONSE channel
  rand bit                         zero_delay_data;
  

  constraint wdata_c {
                       wdata.size()        == axi_max_beat; // Should be awlen + 1
		       wstrb.size()        == axi_max_beat; // Should be awlen + 1
                     }

  constraint zero_delay_data_c {
		                 (read_fl) -> zero_delay_data == 1'b0;
                               }

  constraint wvalid_delay_c {
                       wvalid_delay.size() == axi_max_beat; // Should be awlen + 1

                       foreach(wvalid_delay[k])
                       wvalid_delay[k] inside {[0:(zero_delay_data)?0:5]};
                       /*
                       foreach(wvalid_delay[k])
		        if(k == 0) wvalid_delay[k] == 3;
                        else  wvalid_delay[k] == 2;
                       */ 
                     }

  constraint awvalid_delay_c {
                               awvalid_delay inside {[1:3]};                    
                             }

  constraint arvalid_delay_c {
                               arvalid_delay inside {[1:3]};                    
                             }

  constraint bvalid_delay_c {
                               // bvalid_delay inside {[0:10]};
                              (bvalid_dly == bvalid_dly_zero)		 -> (bvalid_delay == 0);  
			      (bvalid_dly == bvalid_dly_very_short)	 -> (bvalid_delay inside {[1:2]});  
			      (bvalid_dly == bvalid_dly_short)  	 -> (bvalid_delay inside {[2:4]});  
			      (bvalid_dly == bvalid_dly_very_reasonable) -> (bvalid_delay inside {[5:10]});  
			      (bvalid_dly == bvalid_dly_long)		 -> (bvalid_delay inside {[11:30]});  
			      (bvalid_dly == bvalid_dly_very_long)	 -> (bvalid_delay inside {[100:120]}); 			      
                             }

  constraint rdata_c {
                       rdata.size()        == axi_max_beat; // Should be awlen + 1
                       rresp.size()        == axi_max_beat; // Should be awlen + 1  
                       rvalid_delay.size() == axi_max_beat; // Should be awlen + 1
 
                       foreach(rvalid_delay[k])
                       rvalid_delay[k] inside {[0:(zero_delay_data)?0:5]};
                     }


  `uvm_object_utils_begin(axi_slave_seq_item)
  `uvm_field_int(awid,               UVM_DEFAULT)
  `uvm_field_int(awid,               UVM_DEFAULT)
  `uvm_field_int(awaddr,             UVM_DEFAULT)
  `uvm_field_int(awlen,              UVM_DEFAULT)
  `uvm_field_int(awsize,             UVM_DEFAULT)
  `uvm_field_int(awburst,            UVM_DEFAULT)
  `uvm_field_int(awqos,              UVM_DEFAULT)
  `uvm_field_int(awuser,             UVM_DEFAULT)
  `uvm_field_int(awvalid_delay,      UVM_DEFAULT) 
  `uvm_field_int(wid,                UVM_DEFAULT)    
  `uvm_field_array_int(wdata,        UVM_DEFAULT)
  `uvm_field_array_int(wstrb,        UVM_DEFAULT)
  `uvm_field_int(wuser,              UVM_DEFAULT)
  `uvm_field_array_int(wvalid_delay, UVM_DEFAULT) 
  `uvm_field_int(bid,                UVM_DEFAULT)    
  `uvm_field_int(bresp,              UVM_DEFAULT)  
  `uvm_field_int(buser,              UVM_DEFAULT)
  `uvm_field_int(bvalid_delay,       UVM_DEFAULT) 
  `uvm_field_int(arid,               UVM_DEFAULT)
  `uvm_field_int(araddr,             UVM_DEFAULT)
  `uvm_field_int(arlen,              UVM_DEFAULT)
  `uvm_field_int(arsize,             UVM_DEFAULT)
  `uvm_field_int(arburst,            UVM_DEFAULT)
  `uvm_field_int(arqos,              UVM_DEFAULT)
  `uvm_field_int(aruser,             UVM_DEFAULT)
  `uvm_field_int(arvalid_delay,      UVM_DEFAULT) 
  `uvm_field_int(rid,                UVM_DEFAULT) 
  `uvm_field_array_int(rdata,        UVM_DEFAULT)
  `uvm_field_array_int(rresp,        UVM_DEFAULT) 
  `uvm_field_int(ruser,              UVM_DEFAULT)
  `uvm_field_array_int(rvalid_delay, UVM_DEFAULT)
  `uvm_field_int(read_fl,            UVM_DEFAULT)
  `uvm_field_int(zero_delay_data,    UVM_DEFAULT)  
  `uvm_object_utils_end

  function new (string name = "axi_slave_seq_item");
    super.new(name);
  endfunction : new

  function void post_randomize();
   //  May be used to improve control over randomization 
  endfunction : post_randomize
 
  // Allows to enable or disable random behaviour for some variables
   virtual function void control_rnd(input bit enable);
    awvalid_delay.rand_mode(enable);
    wvalid_delay.rand_mode(enable);
    arvalid_delay.rand_mode(enable);
    rvalid_delay.rand_mode(enable);
    rdata.rand_mode(enable);
    rresp.rand_mode(enable);
    wdata.rand_mode(enable);
    wstrb.rand_mode(enable);

    // Disable constraint for the selected rand variables
    awvalid_delay_c.constraint_mode(enable);
    arvalid_delay_c.constraint_mode(enable);
    rdata_c.constraint_mode(enable);        // For rdata and rvalid_delay
    wvalid_delay_c.constraint_mode(enable); // For wvalid_delay
    wdata_c.constraint_mode(enable);        // For wdata array saize
  endfunction : control_rnd  

   virtual function void disable_randomization();
     this.rand_mode(0);
     this.constraint_mode(0);
   endfunction : disable_randomization  

   virtual function void create_read_arrays(input int unsigned size = axi_max_beat);
     rdata	  = new[size];
     rresp	  = new[size]; 
     rvalid_delay = new[size];
   endfunction : create_read_arrays  

   virtual function void create_write_arrays(input int unsigned size = axi_max_beat);
     wdata        = new[size];
     wstrb        = new[size];
   endfunction : create_write_arrays  


   virtual function string convert2string();
    string res = "";
//    return(super.convert2string());
    res = "-------------------------------------------------------------\n"; // Delimiter
    if(read_fl == 1'b1) begin 
     // Procede address part
     res = {res, $sformatf("ARADDR   %8X\n", araddr)};
     res = {res, $sformatf("ARLEN    %2X\n", arlen)};
     res = {res, $sformatf("ARSIZE   %2X\n", arsize)};     
     res = {res, $sformatf("ARBURST  %2X\n", arburst)};               
     res = {res, $sformatf("ARID     %2X\n", arid)};

   // Procede DATA/RESPONSE part
     res = {res, $sformatf("RID      %2X\n", rid)};   
    for(int unsigned idx = 0; idx < arlen + 1; idx++) begin
     res = {res, $sformatf("DATA[%3d]   %16X RRESP[%3d] %d\n", idx, rdata[idx], idx, rresp[idx])};
`ifdef EXTENDED_AXI_TRANS_INFO
     res = {res, $sformatf("rvalid_delay[%3d] %d\n", rvalid_delay[idx])};     
`endif          
    end
`ifdef EXTENDED_AXI_TRANS_INFO
     res = {res, $sformatf("ruser %d\n", ruser)};
`endif
    end // if(read_fl == 1'b1)
    else begin
    // Write transfer

     // Procede address part
     res = {res, $sformatf("AWADDR   %8X\n", awaddr)};
     res = {res, $sformatf("AWLEN    %2X\n", awlen)};
     res = {res, $sformatf("AWSIZE   %2X\n", awsize)};     
     res = {res, $sformatf("AWBURST  %2X\n", awburst)};               
     res = {res, $sformatf("AWID     %2X\n", awid)};
`ifdef EXTENDED_AXI_TRANS_INFO     	  
     res = {res, $sformatf("AWQOS         %2X\n", awqos)};	  
     res = {res, $sformatf("AWUSER        %2X\n", awuser)};	            	  
     res = {res, $sformatf("arvalid_delay %2X\n", awvalid_delay)};	           
`endif     

   // Procede DATA part
     res = {res, $sformatf("WID      %2X\n", wid)};   
    for(int unsigned idx = 0; idx < awlen + 1; idx++) begin
     res = {res, $sformatf("DATA[%3d]   %16X\n", idx, wdata[idx])};
`ifdef EXTENDED_AXI_TRANS_INFO
     res = {res, $sformatf("rvalid_delay[%3d] %d\n", rvalid_delay[idx])};     
`endif          
    end
`ifdef EXTENDED_AXI_TRANS_INFO
     res = {res, $sformatf("ruser %d\n", wuser)};
`endif
       // Procede RESPONSE part
     res = {res, $sformatf("BID        %2X\n", bid)};	  
     res = {res, $sformatf("BRESP      %2X\n", bresp)};	            	  
`ifdef EXTENDED_AXI_TRANS_INFO
     res = {res, $sformatf("BUSER      %2X\n", buser)};
     res = {res, $sformatf("bvalid_delay      %2X\n", bvalid_delay)};     
`endif

    end
    res = {res, "-------------------------------------------------------------\n"}; // Delimiter
    
    return res;
   endfunction : convert2string  

endclass : axi_slave_seq_item

`endif // AXI_SLAVE_SEQ_ITEM_SV
