//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef AXI_CONFIG_SV
`define AXI_CONFIG_SV

class axi_config extends uvm_object;
  /************************************/
  /* UVC configuration fields         */
  /************************************/
  uvm_active_passive_enum is_active = UVM_ACTIVE;
  bit                     has_slave_agent = 1;
  bit                     has_coverage  = 1;
  bit                     has_checks    = 1;
  /************************************/

  /*****************************************/
  /* list of agent configurations          */
  /*****************************************/
  axi_slave_config        m_axi_write_slv_cfg;
  axi_slave_config        m_axi_read_slv_cfg;
  /*****************************************/

  `uvm_object_utils_begin(axi_config)
    `uvm_field_enum(uvm_active_passive_enum, is_active, UVM_DEFAULT)
    `uvm_field_int(has_slave_agent, UVM_DEFAULT)
    `uvm_field_int(has_coverage, UVM_DEFAULT)
    `uvm_field_int(has_checks, UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "axi_config");
    super.new(name);

    /******************************/
    /* create all configurations  */
    /******************************/
    m_axi_write_slv_cfg = axi_slave_config::type_id::create("m_axi_write_slv_cfg");
    m_axi_read_slv_cfg  = axi_slave_config::type_id::create("m_axi_read_slv_cfg");
    /******************************/
    // configure AXI slaves
    m_axi_write_slv_cfg.direction  = 1'b0;  // WRITE channel
    m_axi_read_slv_cfg.direction   = 1'b1;  // READ channel

  endfunction

endclass : axi_config

`endif// AXI_CONFIG_SV
