//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef AXI_ENV_SV
`define AXI_ENV_SV

//-----------------------------------

class axi_env extends uvm_env;
  `uvm_component_utils(axi_env)

  axi_config                     m_axi_cfg;
  axi_virtual_sequencer          m_axi_vsqr;
  // list of AXI agents
  axi_slave_agent                m_axi_slave_write_agent;
  axi_slave_agent                m_axi_slave_read_agent;

  function new (string name = "axi_env", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    // Get configurations for both (WRITE and READ) agents
    if (!uvm_config_db #(axi_config)::get(this, "", "axi_config", m_axi_cfg))
      `uvm_error(get_type_name(), "AXI configuration not set in configuration DB!!!")

    if (m_axi_cfg.has_slave_agent) begin
      // Write agent
      uvm_config_db #(axi_slave_config)::set(this, "m_axi_slave_write_agent", "cfg", m_axi_cfg.m_axi_write_slv_cfg); // Provide configuration for AXI WRITE agent
      m_axi_slave_write_agent = axi_slave_agent::type_id::create("m_axi_slave_write_agent", this);
      // Read agent
      uvm_config_db #(axi_slave_config)::set(this, "m_axi_slave_read_agent", "cfg", m_axi_cfg.m_axi_read_slv_cfg); // Provide configuration for AXI READ agent
      m_axi_slave_read_agent = axi_slave_agent::type_id::create("m_axi_slave_read_agent", this);
    end

    if (m_axi_cfg.is_active == UVM_ACTIVE) begin
      m_axi_vsqr = axi_virtual_sequencer::type_id::create("m_axi_vsqr",this);
    end

  endfunction : build_phase

  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);

    if (m_axi_cfg.has_slave_agent && m_axi_cfg.is_active == UVM_ACTIVE) begin
      m_axi_vsqr.m_axi_wr_slv_sqr = m_axi_slave_write_agent.sequencer;
      m_axi_vsqr.m_axi_rd_slv_sqr = m_axi_slave_read_agent.sequencer;
    end
  endfunction : connect_phase

endclass : axi_env

`endif // AXI_ENV_SV






