//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef H_MEM_WR_RD_SEQ_SV
`define H_MEM_WR_RD_SEQ_SV

class h_mem_wr_rd_seq extends h_mem_seq_base;

  h_mem_cmd_e  seq_cmd;             // command to execute
  bit [1:0]    seq_ch_bw;           // channel bandwidth
  bit [2:0]    seq_num_rx;          // Number of received path used to generate H
  bit [2:0]    seq_num_ss;          // Number of spatial stream used to generate H

  `uvm_object_utils(h_mem_wr_rd_seq)


  function new(string name = "h_mem_wr_rd_seq");
    super.new(name);
  endfunction : new


  virtual task body();
    begin
      `uvm_info(get_type_name(), "Starting...", UVM_HIGH)
      req = h_mem_seq_item::type_id::create("req");

      start_item(req);
      assert(req.randomize() with {
        req.cmd    == seq_cmd;
        req.ch_bw  == seq_ch_bw;
        req.num_rx == seq_num_rx;
        req.num_ss == seq_num_ss;
      });
      finish_item(req);
    end
  endtask : body

endclass : h_mem_wr_rd_seq


`endif //H_MEM_WR_RD_SEQ_SV

