//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef H_MEM_SEQ_ITEM_SV
`define H_MEM_SEQ_ITEM_SV


class h_mem_seq_item extends uvm_sequence_item;

  rand h_mem_cmd_e  cmd;             // command to execute
  rand bit [1:0]    ch_bw;           // channel bandwidth
  rand bit [2:0]    num_rx;          // Number of received path used to generate H
  rand bit [2:0]    num_ss;          // Number of spatial stream used to generate H

  // read/write H memory content
  bit signed [`HMEM_WIDTH-1:0] hmem_re[];
  bit signed [`HMEM_WIDTH-1:0] hmem_im[];

  `uvm_object_utils_begin(h_mem_seq_item)
    `uvm_field_enum(h_mem_cmd_e, cmd, UVM_DEFAULT)
    `uvm_field_int(ch_bw, UVM_DEFAULT)
    `uvm_field_int(num_rx, UVM_DEFAULT)
    `uvm_field_int(num_ss, UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "h_mem_seq_item");
    super.new(name);
  endfunction : new

endclass : h_mem_seq_item

`endif //H_MEM_SEQ_ITEM_SV
