//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_BF_CMD_SEQ_SV
`define MAC_BF_CMD_SEQ_SV


class mac_bf_cmd_seq extends mac_bf_seq_base;

  `uvm_object_utils(mac_bf_cmd_seq)

  bfmee_cmd_e      seq_cmd;
  bit [1:0]        seq_Nc;
  bit [1:0]        seq_Nr;
  bit [1:0]        seq_grouping;
  bit              seq_feedback_type;
  bit              seq_codebook;
  bit [1:0]        seq_ch_bw;
  int              seq_bfm_sample_num;
  bit              seq_he;
  bit [5:0]        seq_ruindex_start;
  bit [5:0]        seq_ruindex_end;


  function new (string name = "mac_bf_cmd_seq");
    super.new (name);
  endfunction : new

  virtual task pre_body();
  endtask : pre_body

  virtual task body();
    begin
      `uvm_info(get_type_name(), "Starting...", UVM_HIGH)
      req = mac_bf_seq_item::type_id::create("req");

      start_item(req);
      assert (req.randomize() with {
        req.cmd            == seq_cmd;
        req.Nc             == seq_Nc;
        req.Nr             == seq_Nr;
        req.grouping       == seq_grouping;
        req.feedback_type  == seq_feedback_type;
        req.codebook       == seq_codebook;
        req.ch_bw          == seq_ch_bw;
        req.bfm_sample_num == seq_bfm_sample_num;
        req.he             == seq_he;
        req.ruindex_start  == seq_ruindex_start;
        req.ruindex_end    == seq_ruindex_end;
      });
      finish_item(req);
    end
  endtask : body

  virtual task post_body();
  endtask : post_body

endclass : mac_bf_cmd_seq


`endif //MAC_BF_CMD_SEQ_SV
