//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_BF_AGENT_SV
`define MAC_BF_AGENT_SV

//-----------------------------------

class mac_bf_agent extends uvm_agent;

  mac_bf_config    cfg;
  mac_bf_driver    driver;
  mac_bf_monitor   monitor;
  mac_bf_coverage  coverage;
  mac_bf_sequencer sequencer;

  `uvm_component_utils_begin(mac_bf_agent)
    `uvm_field_object(cfg, UVM_DEFAULT)
  `uvm_component_utils_end

  function new (string name = "mac_bf_agent", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    // Get Configuration
    if (!uvm_config_db#(mac_bf_config)::get(this, "", "cfg", cfg)) begin
       `uvm_fatal(get_type_name(), "Config not set for slave agent using default is_active")
    end

    // Create components
    monitor = mac_bf_monitor::type_id::create("monitor",this);
    monitor.cfg = cfg;
    if (cfg.has_coverage) begin
      coverage = mac_bf_coverage::type_id::create("coverage", this);
    end

    if (cfg.is_active == UVM_ACTIVE) begin
      sequencer = mac_bf_sequencer::type_id::create("sequencer",this);
      driver = mac_bf_driver::type_id::create("driver",this);
    end

  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    if (cfg.has_coverage) begin
      monitor.ap.connect(coverage.analysis_export);
    end

    if (cfg.is_active == UVM_ACTIVE) begin
      driver.cfg = cfg;
      // Connect the driver to the sequencer using TLM interface
      driver.seq_item_port.connect(sequencer.seq_item_export);
    end
  endfunction : connect_phase

endclass : mac_bf_agent

`endif //MAC_BF_AGENT_SV
