//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_BF_DRIVER_SV
`define MAC_BF_DRIVER_SV


class mac_bf_driver extends uvm_driver #(mac_bf_seq_item);

  `uvm_component_utils(mac_bf_driver)

  virtual mac_bf_if vif;
  mac_bf_config     cfg;


  function new (string name = "mac_bf_driver", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual mac_bf_if)::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    fork
      get_and_drive();
      /* add other tasks here */
    join_none;
  endtask : run_phase

  task initialize();
    vif.bfmee_mac_start          <= 0;
    vif.bfmee_mac_ChBw           <= 0;
    vif.bfmee_mac_Codebook       <= 0;
    vif.bfmee_mac_DataOutRequest <= 0;
    vif.bfmee_mac_FeedbackType   <= 0;
    vif.bfmee_mac_Nc             <= 0;
    vif.bfmee_mac_Grouping       <= 0;
    vif.bfmee_mac_Nr             <= 0;
    vif.bfmee_mac_he_rustartidx  <= 0;
    vif.bfmee_mac_he_ruendidx    <= 0;
    vif.bfmee_mac_he             <= 0;
    // wait reset to be inactive
    wait (vif.bfmee_rst_n == 1'b1);
  endtask : initialize


  task get_and_drive();
    initialize();

    forever begin
      `uvm_info(get_type_name(), "Start of a bus cycle detected.", UVM_DEBUG)
      seq_item_port.get_next_item(req);
      `uvm_info(get_type_name(), "Got new item.", UVM_DEBUG)

      case (req.cmd)
        BFMEE_CFG: begin
          @(posedge vif.bfmee_clk);
          vif.bfmee_mac_ChBw           <= req.ch_bw;
          vif.bfmee_mac_Codebook       <= req.codebook;
          vif.bfmee_mac_FeedbackType   <= req.feedback_type;
          vif.bfmee_mac_Nc             <= req.Nc;
          vif.bfmee_mac_Grouping       <= req.grouping;
          vif.bfmee_mac_Nr             <= req.Nr;
          vif.bfmee_mac_he_rustartidx  <= req.ruindex_start;
          vif.bfmee_mac_he_ruendidx    <= req.ruindex_end;
          vif.bfmee_mac_he             <= req.he;
          @(posedge vif.bfmee_clk);
        end
        BFMEE_CTRL: begin
          @(posedge vif.bfmee_clk);
          vif.bfmee_mac_start <= 1'b1;
          @(posedge vif.bfmee_clk iff vif.bfmee_mac_done == 1'b1);
          @(posedge vif.bfmee_clk);
          vif.bfmee_mac_start <= 1'b0;
          @(posedge vif.bfmee_clk);
        end
        BFMEE_REPORT: begin
          // assert data request
          @(posedge vif.bfmee_clk);
          vif.bfmee_mac_DataOutRequest <= 1'b1;
          // read out beamforming report from BFMEE memory
          repeat (req.bfm_sample_num) begin
            @(posedge vif.bfmee_clk iff vif.bfmee_mac_DataOutValid == 1'b1);
          end
          // de-assert data request
          @(posedge vif.bfmee_clk);
          vif.bfmee_mac_DataOutRequest <= 1'b0;
        end
      endcase

      seq_item_port.item_done();
    end // forever
  endtask : get_and_drive

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase

endclass : mac_bf_driver

`endif // MAC_BF_DRIVER_SV
