//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_BF_MONITOR_SV
`define MAC_BF_MONITOR_SV


class mac_bf_monitor extends uvm_monitor;

  virtual mac_bf_if vif;
  mac_bf_config     cfg;
  uvm_analysis_port #(mac_bf_seq_item) ap;
  mac_bf_seq_item   item;

  `uvm_component_utils(mac_bf_monitor)

  function new(string name = "mac_bf_monitor", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual mac_bf_if)::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

    ap = new("ap", this);
    item = mac_bf_seq_item::type_id::create("item");
  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    wait (vif.bfmee_rst_n == 1'b1);

    fork
      collect_bfm_start();
      collect_read_bfm();
    join_none;
  endtask : run_phase


  task collect_bfm_start();
    forever begin
      @(posedge vif.bfmee_clk iff vif.bfmee_mac_start == 1'b1);
      // wait for SVD done
      @(posedge vif.bfmee_mac_done);
      @(posedge vif.bfmee_clk);
      item.cmd           = BFMEE_CTRL;
      item.ch_bw         = vif.bfmee_mac_ChBw;
      item.codebook      = vif.bfmee_mac_Codebook;
      item.feedback_type = vif.bfmee_mac_FeedbackType;
      item.grouping      = vif.bfmee_mac_Grouping;
      item.Nc            = vif.bfmee_mac_Nc;
      item.Nr            = vif.bfmee_mac_Nr;
      item.he            = vif.bfmee_mac_he;
      item.ruindex_start = vif.bfmee_mac_he_rustartidx;
      item.ruindex_end   = vif.bfmee_mac_he_ruendidx;
      ap.write(item);
      `uvm_info(get_type_name(), $sformatf("Transaction collected :\n%s", item.sprint()), UVM_HIGH)
    end//forever
  endtask : collect_bfm_start

  task collect_read_bfm();
    int sample_cnt;

    forever begin
      sample_cnt = 0;
      item.bfm_report.delete();
      @(posedge vif.bfmee_mac_DataOutRequest);
      fork
        forever begin
          @(posedge vif.bfmee_clk iff vif.bfmee_mac_DataOutValid == 1'b1);
          item.bfm_report = new[item.bfm_report.size()+1](item.bfm_report);
          item.bfm_report[sample_cnt++] = vif.bfmee_mac_DataOut;
        end

        wait (vif.bfmee_mac_DataOutRequest == 1'b0);
      join_any

      disable fork;

      item.cmd           = BFMEE_REPORT;
      item.ch_bw         = vif.bfmee_mac_ChBw;
      item.codebook      = vif.bfmee_mac_Codebook;
      item.feedback_type = vif.bfmee_mac_FeedbackType;
      item.Nc            = vif.bfmee_mac_Nc;
      item.grouping      = vif.bfmee_mac_Grouping;
      item.Nr            = vif.bfmee_mac_Nr;
      item.he            = vif.bfmee_mac_he;
      item.ruindex_start = vif.bfmee_mac_he_rustartidx;
      item.ruindex_end   = vif.bfmee_mac_he_ruendidx;
      item.bfm_sample_num = sample_cnt;
      ap.write(item);
      `uvm_info(get_type_name(), $sformatf("Transaction collected :\n%s", item.sprint()), UVM_HIGH)
    end//forever
  endtask : collect_read_bfm

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase


endclass : mac_bf_monitor

`endif //MAC_BF_MONITOR_SV
