//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_BF_SEQ_ITEM_SV
`define MAC_BF_SEQ_ITEM_SV


class mac_bf_seq_item extends uvm_sequence_item;

  rand bfmee_cmd_e      cmd;
  rand bit [1:0]        Nc;
  rand bit [1:0]        Nr;
  rand bit [1:0]        grouping;
  rand bit              feedback_type;
  rand bit              codebook;
  rand bit [1:0]        ch_bw;
  rand int              bfm_sample_num; // number of samples to read out from memory
  rand bit              he;
  rand bit [5:0]        ruindex_start;
  rand bit [5:0]        ruindex_end;
       bit [7:0]        bfm_report[];

  `uvm_object_utils_begin(mac_bf_seq_item)
    `uvm_field_enum(bfmee_cmd_e, cmd, UVM_DEFAULT)
    `uvm_field_int(Nc, UVM_DEFAULT)
    `uvm_field_int(Nr, UVM_DEFAULT)
    `uvm_field_int(grouping, UVM_DEFAULT)
    `uvm_field_int(feedback_type, UVM_DEFAULT)
    `uvm_field_int(codebook, UVM_DEFAULT)
    `uvm_field_int(ch_bw, UVM_DEFAULT)
    `uvm_field_int(bfm_sample_num, UVM_DEFAULT)
    `uvm_field_int(he, UVM_DEFAULT)
    `uvm_field_int(ruindex_start, UVM_DEFAULT)
    `uvm_field_int(ruindex_end, UVM_DEFAULT)
  `uvm_object_utils_end


  function new (string name = "mac_bf_seq_item");
    super.new(name);
  endfunction : new

  //------------------------------------------------------------
  // custom copy function
  //------------------------------------------------------------
  virtual function void do_copy(uvm_object rhs);
    mac_bf_seq_item rhs_;

    if (!$cast(rhs_,rhs)) begin
      `uvm_fatal(get_type_name(), "do_copy cast failed!")
    end
    super.do_copy(rhs);

    bfm_report = new[rhs_.bfm_report.size()];
    foreach (rhs_.bfm_report[i]) bfm_report[i] = rhs_.bfm_report[i];
  endfunction : do_copy

endclass : mac_bf_seq_item

`endif //MAC_BF_SEQ_ITEM_SV
