//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef PHY_BF_DRIVER_SV
`define PHY_BF_DRIVER_SV


class phy_bf_driver extends uvm_driver #(phy_bf_seq_item);

  `uvm_component_utils(phy_bf_driver)

  virtual phy_bf_if      vif;
  phy_bf_config          cfg;
  int                    bfm_report_size;
  int                    sample_cnt;
  bit                    buffer_ready[$], dummy;

  //---------------------------------------------------------------------------
  // variables
  //---------------------------------------------------------------------------

  //---------------------------------------------------------------------------


  function new (string name = "phy_bf_driver", uvm_component parent = null);
    super.new(name, parent);

  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual phy_bf_if)::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  //-----------------------------------------------------------------------
  // list of tasks and functions
  //-----------------------------------------------------------------------
  //-----------------------------------------------------------------------

  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    fork
      get_and_drive();
      /* add other tasks here */
    join_none;
  endtask : run_phase

  task initialize();
    vif.done       <= 0;
    vif.data_valid <= 0;
    vif.data       <= 0;
  endtask : initialize

  task get_and_drive();
    initialize();

    forever begin
      `uvm_info(get_type_name(), "Start of a bus cycle detected.", UVM_DEBUG)
      seq_item_port.get_next_item(req);
      `uvm_info(get_type_name(), "Got new item.", UVM_DEBUG)

      // wait for start to be triggered, then PHY should start calculation
      // of beamforming report data
      @(posedge vif.clk iff vif.start == 1'b1);
      // from configuration values caluculate size of BFM report
      if (vif.he)
        bfm_report_size = he_bfm_report_size_estimator(.Nr(vif.nr),
                                                    .Nc(vif.nc),
                                                    .ch_bw(vif.chbw),
                                                    .grouping(vif.grouping),
                                                    .codebook(vif.codebook),
                                                    .feedbacktype(vif.feedback_type),
                                                    .ru_start_index(vif.he_runindex_start),
                                                    .ru_end_index(vif.he_runindex_end),
                                                    .debug(0));
      else
        bfm_report_size = bfm_report_size_estimator(.Nr(vif.nr),
                                                    .Nc(vif.nc),
                                                    .ch_bw(vif.chbw),
                                                    .grouping(vif.grouping),
                                                    .codebook(vif.codebook),
                                                    .feedbacktype(vif.feedback_type[0]),
                                                    .debug(0));

      `uvm_info(get_type_name(), $sformatf("BFM report size: %0d", bfm_report_size), UVM_LOW)
      #(`PHY_BFM_REPORT_CALC_TIME);
      @(posedge vif.clk);
      vif.done <= 1'b1;  // signal to MAC that processing is done
      @(posedge vif.clk);
      @(posedge vif.clk);
      vif.done <= 1'b0;

      // wait for data ready from MAC
      sample_cnt = 0;
      fork
        // collect ready signals
        forever begin
          @(posedge vif.clk iff vif.data_ready == 1'b1);
          buffer_ready.push_front(1'b1);
        end
        // generate random BFM report data and valid signal
        while (sample_cnt < bfm_report_size) begin
          @(posedge vif.clk);
          if (buffer_ready.size() != 0) begin
            vif.data_valid <= 1'b1;
            vif.data       <= $urandom_range(0, 255);
            sample_cnt++;
            dummy = buffer_ready.pop_back();
          end
          else begin
            vif.data_valid <= 1'b0;
            vif.data       <= 8'h0;
          end
        end// while
      join_any

      disable fork;

      @(posedge vif.clk);
      vif.data_valid <= 1'b0;
      vif.data       <= 8'h0;

      seq_item_port.item_done();
    end // forever
  endtask : get_and_drive

endclass : phy_bf_driver


`endif
