//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef PHY_BF_MONITOR_SV
`define PHY_BF_MONITOR_SV


class phy_bf_monitor extends uvm_monitor;

  virtual phy_bf_if     vif;
  phy_bf_config         cfg;
  uvm_analysis_port     #(phy_bf_seq_item) ap;
  phy_bf_seq_item       item;
  int                   bfm_report_size;
  int                   sample_cnt;


  `uvm_component_utils(phy_bf_monitor)

  function new(string name = "phy_bf_monitor", uvm_component parent = null);
    super.new(name, parent);

    ap = new("ap", this);
    item = phy_bf_seq_item::type_id::create("item");
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual phy_bf_if)::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    collect_transaction();
  endtask : run_phase

  task collect_transaction();
    forever begin
      item.bfm_data.delete(); // delete queue data

      @(posedge vif.clk iff vif.start == 1'b1);
      // from configuration values caluculate size of BFM report
      if (vif.he)
        bfm_report_size = he_bfm_report_size_estimator(.Nr(vif.nr),
                                                    .Nc(vif.nc),
                                                    .ch_bw(vif.chbw),
                                                    .grouping(vif.grouping),
                                                    .codebook(vif.codebook),
                                                    .feedbacktype(vif.feedback_type),
                                                    .ru_start_index(vif.he_runindex_start),
                                                    .ru_end_index(vif.he_runindex_end),
                                                    .debug(0));
      else
        bfm_report_size = bfm_report_size_estimator(.Nr(vif.nr),
                                                    .Nc(vif.nc),
                                                    .ch_bw(vif.chbw),
                                                    .grouping(vif.grouping),
                                                    .codebook(vif.codebook),
                                                    .feedbacktype(vif.feedback_type[0]),
                                                    .debug(0));

      `uvm_info(get_type_name(), $sformatf("BFM report size: %0d", bfm_report_size), UVM_HIGH)
      sample_cnt = 0;
      // collect BFM report data on valid signal
      while (sample_cnt < bfm_report_size) begin
        @(posedge vif.clk iff vif.data_valid == 1'b1);
        item.bfm_data.push_front(vif.data);
        sample_cnt++;
      end

      `uvm_info(get_type_name(), $sformatf("Transaction collected :\n%s", item.sprint()), UVM_HIGH)
      ap.write(item);
    end//forever
  endtask : collect_transaction

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase


endclass : phy_bf_monitor

`endif //PHY_BF_MONITOR_SV
