//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef BEAMFORMING_CONFIG_SV
`define BEAMFORMING_CONFIG_SV

class beamforming_config extends uvm_object;
  /************************************/
  /* UVC configuration fields         */
  /************************************/
  uvm_active_passive_enum  is_active = UVM_ACTIVE;
  bit                      has_mac_bf_agent  = 1;
  bit                      has_phy_bf_agent  = 0;
  bit                      has_h_mem_agent   = 1;
  /************************************/

  /*****************************************/
  /* list of agent configurations          */
  /*****************************************/
  mac_bf_config            m_mac_bf_cfg;
  phy_bf_config            m_phy_bf_cfg;
  mem_config               m_h_mem_cfg;
  /*****************************************/

  `uvm_object_utils_begin(beamforming_config)
    `uvm_field_enum(uvm_active_passive_enum, is_active, UVM_DEFAULT)
    `uvm_field_int(has_mac_bf_agent, UVM_DEFAULT)
    `uvm_field_int(has_phy_bf_agent, UVM_DEFAULT)
    `uvm_field_int(has_h_mem_agent, UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "beamforming_config");
    super.new(name);

    /******************************/
    /* create all configurations  */
    /******************************/
    m_mac_bf_cfg = mac_bf_config::type_id::create("m_mac_bf_cfg");
    m_phy_bf_cfg = phy_bf_config::type_id::create("m_phy_bf_cfg");
    m_h_mem_cfg  = mem_config::type_id::create("m_h_mem_cfg");

    //configure MEM agent for read memory
    m_h_mem_cfg.is_active   = UVM_PASSIVE;
    m_h_mem_cfg.is_read_mem = 1;

  endfunction

endclass : beamforming_config

`endif //BEAMFORMING_CONFIG_SV
