//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef BEAMFORMING_ENV_SV
`define BEAMFORMING_ENV_SV

//-----------------------------------

class beamforming_env extends uvm_env;
  `uvm_component_utils(beamforming_env)

  beamforming_config            m_cfg;
  beamforming_virtual_sequencer m_vsqr;
  mac_bf_agent                  m_mac_bf_agent;
  phy_bf_agent                  m_phy_bf_agent;
  mem_agent#(`HMEM_WIDTH)       m_h_mem_agent;


  function new (string name = "beamforming_env", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    // Get configuration
    if (!uvm_config_db #(beamforming_config)::get(this, "", "beamforming_config", m_cfg))
      `uvm_error(get_type_name(), "BEAMFORMING configuration not set in configuration DB!!!")

    // Create components
    if (m_cfg.is_active == UVM_ACTIVE) begin
      m_vsqr = beamforming_virtual_sequencer::type_id::create("m_vsqr", this);
    end
    else begin
      m_cfg.m_mac_bf_cfg.is_active = UVM_PASSIVE;
    end

    if (m_cfg.has_mac_bf_agent) begin
      uvm_config_db #(mac_bf_config)::set(this, "m_mac_bf_agent", "cfg", m_cfg.m_mac_bf_cfg);
      m_mac_bf_agent = mac_bf_agent::type_id::create("m_mac_bf_agent", this);
    end

    if (m_cfg.has_phy_bf_agent) begin
      uvm_config_db #(phy_bf_config)::set(this, "m_phy_bf_agent", "cfg", m_cfg.m_phy_bf_cfg);
      m_phy_bf_agent = phy_bf_agent::type_id::create("m_phy_bf_agent", this);
    end

    if (m_cfg.has_h_mem_agent) begin
      uvm_config_db #(mem_config)::set(this, "m_h_mem_agent", "cfg", m_cfg.m_h_mem_cfg);
      m_h_mem_agent = mem_agent#(`HMEM_WIDTH)::type_id::create("m_h_mem_agent", this);
    end

  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);

    /* connect environment components and handles */
    if (m_cfg.has_mac_bf_agent) begin
      if (m_cfg.m_mac_bf_cfg.is_active == UVM_ACTIVE)
        m_vsqr.m_mac_bf_sqr = m_mac_bf_agent.sequencer;
    end // has_mac_bf_agent

    if (m_cfg.has_phy_bf_agent) begin
      if (m_cfg.m_phy_bf_cfg.is_active == UVM_ACTIVE)
        m_vsqr.m_phy_bf_sqr = m_phy_bf_agent.sequencer;
    end // has_phy_bf_agent

  endfunction : connect_phase

endclass : beamforming_env

`endif //BEAMFORMING_ENV_SV
