//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef BUS_MONITOR_AGENT_SV
`define BUS_MONITOR_AGENT_SV

//-----------------------------------

class bus_monitor_agent extends uvm_agent;

  bus_monitor_config    cfg;
  bus_monitor_monitor   monitor;
  bus_monitor_coverage  coverage;

  `uvm_component_utils_begin(bus_monitor_agent)
    `uvm_field_object(cfg, UVM_DEFAULT)
  `uvm_component_utils_end

  function new (string name = "bus_monitor_agent", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    // Get Configuration
    if (!uvm_config_db#(bus_monitor_config)::get(this, "", "cfg", cfg)) begin
       `uvm_fatal(get_type_name(), "Config not set for slave agent using default is_active")
    end

    // Create components
    monitor = bus_monitor_monitor::type_id::create("monitor",this);
    monitor.cfg = cfg;
    if (cfg.has_coverage) begin
      coverage = bus_monitor_coverage::type_id::create("coverage", this);
    end

  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    if (cfg.has_coverage) begin
      monitor.ap.connect(coverage.analysis_export);
    end
  endfunction : connect_phase

endclass : bus_monitor_agent

`endif
