//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef BUS_MONITOR_CONFIG_SV
`define BUS_MONITOR_CONFIG_SV

class bus_monitor_config extends uvm_object;

  bit                            has_coverage = 1;
  bit                            has_checks   = 1;
  // probed signals
  logic                          tx_end;
  logic                          rx_end;
  logic                          frame_violation;
  // RxTD status registers
  logic [20:0]                   status_coarse_fo_angle;
  logic [20:0]                   status_fine_fo_angle;

  logic [21:0]                   totalPower;
  logic [21:0]                   noisePower;
  logic [9:0]                    noisePowerMant;
  logic [4:0]                    noisePowerExp;
  logic [11:0]                   RatioNoiseSignal;
  logic [5:0]                    RatioShift;
  logic [21:0]                   StatusFDOData;
  logic [21:0]                   StatusFDOPreamb;
  logic [24:0]                   StatusdPhi;
  logic [26:0]                   StatusTsNormOut;

  `uvm_object_utils_begin(bus_monitor_config)
    `uvm_field_int(has_coverage, UVM_DEFAULT)
    `uvm_field_int(has_checks, UVM_DEFAULT)
  `uvm_object_utils_end


  function new (string name = "bus_monitor_config");
    super.new(name);
  endfunction

endclass : bus_monitor_config

`endif
