//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef BUS_MONITOR_IF_SV
`define BUS_MONITOR_IF_SV

interface bus_monitor_if;

  // Check flags
  bit   has_checks = 1;
  bit   has_coverage = 1;

  // signal declaration
  logic        rst_n;
  // MAC-PHY interface signals
  logic        tx_end;
  logic        rx_end;
  logic        frame_violation;
  // SIG signals
  logic        sig_update;
  logic [17:0] l_sig;
  logic [41:0] ht_sig;
  logic [45:0] he_siga;
  // RxTD status registers
  logic [20:0] status_coarse_fo_angle;
  logic [20:0] status_fine_fo_angle;

  logic [21:0] totalPower;
  logic [21:0] noisePower;
  logic  [9:0] noisePowerMant;
  logic  [4:0] noisePowerExp;
  logic [11:0] RatioNoiseSignal;
  logic  [5:0] RatioShift;
  logic [21:0] StatusFDOData;
  logic [21:0] StatusFDOPreamb;
  logic [24:0] StatusdPhi;
  logic [26:0] StatusTsNormOut;
  logic [5:0]  SynchSkip;
  logic        doppler;

  /***************************/
  /* ASSERTIONS              */
  /***************************/

  /***************************/
  /* COVERAGE                */
  /***************************/

endinterface : bus_monitor_if

`endif
