//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef BUS_MONITOR_MONITOR_SV
`define BUS_MONITOR_MONITOR_SV


class bus_monitor_monitor extends uvm_monitor;

  virtual bus_monitor_if vif;
  bus_monitor_config     cfg;
  uvm_analysis_port #(bus_monitor_seq_item) ap;
  bus_monitor_seq_item   item;

  `uvm_component_utils(bus_monitor_monitor)

  function new(string name = "bus_monitor_monitor", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual bus_monitor_if)::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

    ap = new("ap", this);
    item = bus_monitor_seq_item::type_id::create("item");
  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    wait (vif.rst_n == 1'b1);
    item.tx_end = vif.tx_end;
    cfg.tx_end  = vif.tx_end;
    item.rx_end = vif.rx_end;
    cfg.rx_end  = vif.rx_end;

    fork
      collect_transaction();
      sample_txend();
      sample_rxend();
      sample_synchskip();
      sample_rxtd_status_reg();
    join_none;
  endtask : run_phase


  task collect_transaction();

    forever begin
      sample_sig_signals();

      `uvm_info(get_type_name(), $sformatf("Transaction collected :\n%s", item.sprint()), UVM_DEBUG)

      if (cfg.has_checks)
        perform_checks();

      ap.write(item);
    end// forever
  endtask : collect_transaction

  task sample_sig_signals();
    @(posedge vif.sig_update);
    item.l_sig   = vif.l_sig;
    item.ht_sig  = vif.ht_sig;
    item.he_siga = vif.he_siga;
  endtask : sample_sig_signals

  task sample_txend();
    forever begin
      wait (cfg.tx_end !== vif.tx_end);
      item.tx_end = vif.tx_end;
      cfg.tx_end  = vif.tx_end;
    end
  endtask : sample_txend

  task sample_rxend();
    forever begin
      wait (cfg.rx_end !== vif.rx_end);
      item.rx_end = vif.rx_end;
      cfg.rx_end  = vif.rx_end;
    end
  endtask : sample_rxend

  task sample_synchskip();
    forever begin
      @(vif.SynchSkip);
      if (vif.doppler == 1 && vif.SynchSkip != 0)
        `uvm_warning(get_type_name(),$sformatf("SynchSkip has value different than 0, (%0d)", signed'(vif.SynchSkip)))
    end
  endtask : sample_synchskip

  task sample_rxtd_status_reg();
    forever begin
      wait (   cfg.status_coarse_fo_angle !== vif.status_coarse_fo_angle
            || cfg.status_fine_fo_angle   !== vif.status_fine_fo_angle
            || cfg.totalPower             !== vif.totalPower
            || cfg.noisePower             !== vif.noisePower
            || cfg.noisePowerMant         !== vif.noisePowerMant
            || cfg.noisePowerExp          !== vif.noisePowerExp
            || cfg.RatioShift             !== vif.RatioShift
            || cfg.RatioNoiseSignal       !== vif.RatioNoiseSignal
            || cfg.StatusFDOData          !== vif.StatusFDOData
            || cfg.StatusFDOPreamb        !== vif.StatusFDOPreamb
            || cfg.StatusdPhi             !== vif.StatusdPhi
            || cfg.StatusTsNormOut        !== vif.StatusTsNormOut
            || cfg.frame_violation        !== vif.frame_violation);
      cfg.status_coarse_fo_angle = vif.status_coarse_fo_angle;
      cfg.status_fine_fo_angle   = vif.status_fine_fo_angle;
      cfg.totalPower = vif.totalPower;
      cfg.noisePower = vif.noisePower;
      cfg.noisePowerMant = vif.noisePowerMant;
      cfg.noisePowerExp = vif.noisePowerExp ;
      cfg.RatioNoiseSignal = vif.RatioNoiseSignal;
      cfg.RatioShift = vif.RatioShift;
      cfg.StatusFDOData = vif.StatusFDOData;
      cfg.StatusFDOPreamb = vif.StatusFDOPreamb;
      cfg.StatusTsNormOut = vif.StatusTsNormOut;
      cfg.StatusdPhi = vif.StatusdPhi;
      cfg.frame_violation = vif.frame_violation;
      
    end//forever
  endtask : sample_rxtd_status_reg

  function void perform_checks();
  endfunction : perform_checks

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase


endclass : bus_monitor_monitor

`endif //BUS_MONITOR_MONITOR_SV
